"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSql, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional
import PySide6.QtCore
import PySide6.QtWidgets
import PySide6.QtSql

bytes = str


class QSqlDriver(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsqldriver.html

    **Detailed Description**

    This class should not be used directly. Use **QSqlDatabase**  instead.

    If you want to create your own SQL drivers, you can subclass this class and
    reimplement its pure virtual functions and those virtual functions that you
    need. See **How to Write Your Own Database Driver**  for more information.

    **See also** **QSqlDatabase**  and **QSqlResult** .
    """

    UnknownDbms: QSqlDriver.DbmsType = ...
    MSSqlServer: QSqlDriver.DbmsType = ...
    MySqlServer: QSqlDriver.DbmsType = ...
    PostgreSQL: QSqlDriver.DbmsType = ...
    Oracle: QSqlDriver.DbmsType = ...
    Sybase: QSqlDriver.DbmsType = ...
    SQLite: QSqlDriver.DbmsType = ...
    Interbase: QSqlDriver.DbmsType = ...
    DB2: QSqlDriver.DbmsType = ...
    Transactions: QSqlDriver.DriverFeature = ...
    QuerySize: QSqlDriver.DriverFeature = ...
    BLOB: QSqlDriver.DriverFeature = ...
    Unicode: QSqlDriver.DriverFeature = ...
    PreparedQueries: QSqlDriver.DriverFeature = ...
    NamedPlaceholders: QSqlDriver.DriverFeature = ...
    PositionalPlaceholders: QSqlDriver.DriverFeature = ...
    LastInsertId: QSqlDriver.DriverFeature = ...
    BatchOperations: QSqlDriver.DriverFeature = ...
    SimpleLocking: QSqlDriver.DriverFeature = ...
    LowPrecisionNumbers: QSqlDriver.DriverFeature = ...
    EventNotifications: QSqlDriver.DriverFeature = ...
    FinishQuery: QSqlDriver.DriverFeature = ...
    MultipleResultSets: QSqlDriver.DriverFeature = ...
    CancelQuery: QSqlDriver.DriverFeature = ...
    FieldName: QSqlDriver.IdentifierType = ...
    TableName: QSqlDriver.IdentifierType = ...
    UnknownSource: QSqlDriver.NotificationSource = ...
    SelfSource: QSqlDriver.NotificationSource = ...
    OtherSource: QSqlDriver.NotificationSource = ...
    WhereStatement: QSqlDriver.StatementType = ...
    SelectStatement: QSqlDriver.StatementType = ...
    UpdateStatement: QSqlDriver.StatementType = ...
    InsertStatement: QSqlDriver.StatementType = ...
    DeleteStatement: QSqlDriver.StatementType = ...

    class DbmsType(Enum):
        UnknownDbms: QSqlDriver.DbmsType = ...
        MSSqlServer: QSqlDriver.DbmsType = ...
        MySqlServer: QSqlDriver.DbmsType = ...
        PostgreSQL: QSqlDriver.DbmsType = ...
        Oracle: QSqlDriver.DbmsType = ...
        Sybase: QSqlDriver.DbmsType = ...
        SQLite: QSqlDriver.DbmsType = ...
        Interbase: QSqlDriver.DbmsType = ...
        DB2: QSqlDriver.DbmsType = ...

    class DriverFeature(Enum):
        Transactions: QSqlDriver.DriverFeature = ...
        QuerySize: QSqlDriver.DriverFeature = ...
        BLOB: QSqlDriver.DriverFeature = ...
        Unicode: QSqlDriver.DriverFeature = ...
        PreparedQueries: QSqlDriver.DriverFeature = ...
        NamedPlaceholders: QSqlDriver.DriverFeature = ...
        PositionalPlaceholders: QSqlDriver.DriverFeature = ...
        LastInsertId: QSqlDriver.DriverFeature = ...
        BatchOperations: QSqlDriver.DriverFeature = ...
        SimpleLocking: QSqlDriver.DriverFeature = ...
        LowPrecisionNumbers: QSqlDriver.DriverFeature = ...
        EventNotifications: QSqlDriver.DriverFeature = ...
        FinishQuery: QSqlDriver.DriverFeature = ...
        MultipleResultSets: QSqlDriver.DriverFeature = ...
        CancelQuery: QSqlDriver.DriverFeature = ...

    class IdentifierType(Enum):
        FieldName: QSqlDriver.IdentifierType = ...
        TableName: QSqlDriver.IdentifierType = ...

    class NotificationSource(Enum):
        UnknownSource: QSqlDriver.NotificationSource = ...
        SelfSource: QSqlDriver.NotificationSource = ...
        OtherSource: QSqlDriver.NotificationSource = ...

    class StatementType(Enum):
        WhereStatement: QSqlDriver.StatementType = ...
        SelectStatement: QSqlDriver.StatementType = ...
        UpdateStatement: QSqlDriver.StatementType = ...
        InsertStatement: QSqlDriver.StatementType = ...
        DeleteStatement: QSqlDriver.StatementType = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#QSqlDriver

        **QSqlDriver::QSqlDriver(QObject * parent = nullptr)**

        Constructs a new driver with the given **parent**.
        """
        ...

    def beginTransaction(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#beginTransaction

        **[virtual] bool QSqlDriver::beginTransaction()**

        This function is called to begin a transaction. If successful, return
        true, otherwise return false. The default implementation does nothing
        and returns `false`.

        **See also** **commitTransaction** () and **rollbackTransaction** ().
        """
        ...

    def cancelQuery(self) -> bool:
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#close

        **[pure virtual] void QSqlDriver::close()**

        Derived classes must reimplement this pure virtual function in order to
        close the database connection. Return true on success, false on failure.

        **See also** **open** () and **setOpen** ().
        """
        ...

    def commitTransaction(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#commitTransaction

        **[virtual] bool QSqlDriver::commitTransaction()**

        This function is called to commit a transaction. If successful, return
        true, otherwise return false. The default implementation does nothing
        and returns `false`.

        **See also** **beginTransaction** () and **rollbackTransaction** ().
        """
        ...

    def createResult(self) -> PySide6.QtSql.QSqlResult:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#createResult

        **[pure virtual] QSqlResult *QSqlDriver::createResult() const**

        Creates an empty SQL result on the database. Derived classes must
        reimplement this function and return a **QSqlResult**  object
        appropriate for their database to the caller.
        """
        ...

    def dbmsType(self) -> PySide6.QtSql.QSqlDriver.DbmsType:
        ...

    def escapeIdentifier(
        self, identifier: str, type: PySide6.QtSql.QSqlDriver.IdentifierType
    ) -> str:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#escapeIdentifier

        **[virtual] QString QSqlDriver::escapeIdentifier(const QString &
        identifier , QSqlDriver::IdentifierType type ) const**

        Returns the **identifier** escaped according to the database rules.
        **identifier** can either be a table name or field name, dependent on
        **type**.

        The default implementation does nothing.

        **See also** **isIdentifierEscaped** ().
        """
        ...

    def formatValue(
        self, field: PySide6.QtSql.QSqlField, trimStrings: bool = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#formatValue

        **[virtual] QString QSqlDriver::formatValue(const QSqlField & field ,
        bool trimStrings = false) const**

        Returns a string representation of the **field** value for the database.
        This is used, for example, when constructing INSERT and UPDATE
        statements.

        The default implementation returns the value formatted as a string
        according to the following rules:

        * If **field** is character data, the value is returned enclosed in
        single quotation marks, which is appropriate for many SQL databases. Any
        embedded single-quote characters are escaped (replaced with two single-
        quote characters). If **trimStrings** is true (the default is false),
        all trailing whitespace is trimmed from the field.
          * If **field** is
        date/time data, the value is formatted in ISO format and enclosed in
        single quotation marks. If the date/time data is invalid, "NULL" is
        returned.
          * If **field** is **bytearray**  data, and the driver can
        edit binary fields, the value is formatted as a hexadecimal string.
          *
        For any other field type, toString() is called on its value and the
        result of this is returned.

        **See also** **QVariant::toString** ().
        """
        ...

    def hasFeature(self, f: PySide6.QtSql.QSqlDriver.DriverFeature) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#hasFeature

        **[pure virtual] bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature
        feature ) const**

        Returns `true` if the driver supports feature **feature** ; otherwise
        returns `false`.

        Note that some databases need to be **open** () before this can be
        determined.

        **See also** **DriverFeature** .
        """
        ...

    def isIdentifierEscaped(
        self, identifier: str, type: PySide6.QtSql.QSqlDriver.IdentifierType
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#isIdentifierEscaped

        **[virtual] bool QSqlDriver::isIdentifierEscaped(const QString &
        identifier , QSqlDriver::IdentifierType type ) const**

        Returns whether **identifier** is escaped according to the database
        rules. **identifier** can either be a table name or field name,
        dependent on **type**.

        Reimplement this function if you want to provide your own implementation
        in your **QSqlDriver**  subclass,

        **See also** **stripDelimiters** () and **escapeIdentifier** ().
        """
        ...

    def isOpen(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#isOpen

        **[virtual] bool QSqlDriver::isOpen() const**

        Returns `true` if the database connection is open; otherwise returns
        false.
        """
        ...

    def isOpenError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#isOpenError

        **bool QSqlDriver::isOpenError() const**

        Returns `true` if the there was an error opening the database
        connection; otherwise returns `false`.
        """
        ...

    def lastError(self) -> PySide6.QtSql.QSqlError:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#lastError

        **QSqlError QSqlDriver::lastError() const**

        Returns a **QSqlError**  object which contains information about the
        last error that occurred on the database.

        **See also** **setLastError** ().
        """
        ...

    def maximumIdentifierLength(
        self, type: PySide6.QtSql.QSqlDriver.IdentifierType
    ) -> int:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#maximumIdentifierLength

        **[virtual, since 6.0] int
        QSqlDriver::maximumIdentifierLength(QSqlDriver::IdentifierType type )
        const**

        Returns the maximum length for the identifier **type** according to the
        database settings. Returns INT_MAX by default if the is no maximum for
        the database.

        This function was introduced in Qt 6.0.
        """
        ...

    def numericalPrecisionPolicy(self) -> PySide6.QtSql.QSql.NumericalPrecisionPolicy:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#numericalPrecisionPolicy

        **QSql::NumericalPrecisionPolicy QSqlDriver::numericalPrecisionPolicy()
        const**

        Returns the current default precision policy for the database
        connection.

        **See also** **QSql::NumericalPrecisionPolicy** ,
        **setNumericalPrecisionPolicy** (),
        **QSqlQuery::numericalPrecisionPolicy** (), and
        **QSqlQuery::setNumericalPrecisionPolicy** ().
        """
        ...

    def open(
        self,
        db: str,
        user: str = ...,
        password: str = ...,
        host: str = ...,
        port: int = ...,
        connOpts: str = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#open

        **[pure virtual] bool QSqlDriver::open(const QString & db , const
        QString & user = QString(), const QString & password = QString(), const
        QString & host = QString(), int port = -1, const QString & options =
        QString())**

        Derived classes must reimplement this pure virtual function to open a
        database connection on database **db** , using user name **user** ,
        password **password** , host **host** , port **port** and connection
        options **options**.

        The function must return true on success and false on failure.

        **See also** **setOpen** ().
        """
        ...

    def primaryIndex(self, tableName: str) -> PySide6.QtSql.QSqlIndex:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#primaryIndex

        **[virtual] QSqlIndex QSqlDriver::primaryIndex(const QString & tableName
        ) const**

        Returns the primary index for table **tableName**. Returns an empty
        **QSqlIndex**  if the table doesn't have a primary index. The default
        implementation returns an empty index.
        """
        ...

    def record(self, tableName: str) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#record

        **[virtual] QSqlRecord QSqlDriver::record(const QString & tableName )
        const**

        Returns a **QSqlRecord**  populated with the names of the fields in
        table **tableName**. If no such table exists, an empty record is
        returned. The default implementation returns an empty record.
        """
        ...

    def rollbackTransaction(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#rollbackTransaction

        **[virtual] bool QSqlDriver::rollbackTransaction()**

        This function is called to rollback a transaction. If successful, return
        true, otherwise return false. The default implementation does nothing
        and returns `false`.

        **See also** **beginTransaction** () and **commitTransaction** ().
        """
        ...

    def setLastError(self, e: PySide6.QtSql.QSqlError) -> None:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#setLastError

        **[virtual protected] void QSqlDriver::setLastError(const QSqlError &
        error )**

        This function is used to set the value of the last error, **error** ,
        that occurred on the database.

        **See also** **lastError** ().
        """
        ...

    def setNumericalPrecisionPolicy(
        self, precisionPolicy: PySide6.QtSql.QSql.NumericalPrecisionPolicy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#setNumericalPrecisionPolicy

        **void
        QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy
        precisionPolicy )**

        Sets the default numerical precision policy used by queries created by
        this driver to **precisionPolicy**.

        Note: Setting the default precision policy to **precisionPolicy**
        doesn't affect any currently active queries.

        **See also** **QSql::NumericalPrecisionPolicy** ,
        **numericalPrecisionPolicy** (),
        **QSqlQuery::setNumericalPrecisionPolicy** (), and
        **QSqlQuery::numericalPrecisionPolicy** ().
        """
        ...

    def setOpen(self, o: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#setOpen

        **[virtual protected] void QSqlDriver::setOpen(bool open )**

        This function sets the open state of the database to **open**. Derived
        classes can use this function to report the status of **open** ().

        **See also** **open** () and **setOpenError** ().
        """
        ...

    def setOpenError(self, e: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#setOpenError

        **[virtual protected] void QSqlDriver::setOpenError(bool error )**

        This function sets the open error state of the database to **error**.
        Derived classes can use this function to report the status of **open**
        (). Note that if **error** is true the open state of the database is set
        to closed (i.e., **isOpen** () returns `false`).

        **See also** **isOpenError** (), **open** (), and **setOpen** ().
        """
        ...

    def sqlStatement(
        self,
        type: PySide6.QtSql.QSqlDriver.StatementType,
        tableName: str,
        rec: PySide6.QtSql.QSqlRecord,
        preparedStatement: bool,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#sqlStatement

        **[virtual] QString QSqlDriver::sqlStatement(QSqlDriver::StatementType
        type , const QString & tableName , const QSqlRecord & rec , bool
        preparedStatement ) const**

        Returns a SQL statement of type **type** for the table **tableName**
        with the values from **rec**. If **preparedStatement** is true, the
        string will contain placeholders instead of values.

        The generated flag in each field of **rec** determines whether the field
        is included in the generated statement.

        This method can be used to manipulate tables without having to worry
        about database-dependent SQL dialects. For non-prepared statements, the
        values will be properly escaped.

        In the WHERE statement, each non-null field of **rec** specifies a
        filter condition of equality to the field value, or if prepared, a
        placeholder. However, prepared or not, a null field specifies the
        condition IS NULL and never introduces a placeholder. The application
        must not attempt to bind data for the null field during execution. The
        field must be set to some non-null value if a placeholder is desired.
        Furthermore, since non-null fields specify equality conditions and SQL
        NULL is not equal to anything, even itself, it is generally not useful
        to bind a null to a placeholder.
        """
        ...

    def stripDelimiters(
        self, identifier: str, type: PySide6.QtSql.QSqlDriver.IdentifierType
    ) -> str:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#stripDelimiters

        **[virtual] QString QSqlDriver::stripDelimiters(const QString &
        identifier , QSqlDriver::IdentifierType type ) const**

        Returns the **identifier** with the leading and trailing delimiters
        removed, **identifier** can either be a table name or field name,
        dependent on **type**. If **identifier** does not have leading and
        trailing delimiter characters, **identifier** is returned without
        modification.

        Reimplement this function if you want to provide your own implementation
        in your **QSqlDriver**  subclass,

        **See also** **isIdentifierEscaped** ().
        """
        ...

    def subscribeToNotification(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#subscribeToNotification

        **[virtual] bool QSqlDriver::subscribeToNotification(const QString &
        name )**

        This function is called to subscribe to event notifications from the
        database. **name** identifies the event notification.

        If successful, return true, otherwise return false.

        The database must be open when this function is called. When the
        database is closed by calling **close** () all subscribed event
        notifications are automatically unsubscribed. Note that calling **open**
        () on an already open database may implicitly cause **close** () to be
        called, which will cause the driver to unsubscribe from all event
        notifications.

        When an event notification identified by **name** is posted by the
        database the **notification** () signal is emitted.

        Reimplement this function if you want to provide event notification
        support in your own **QSqlDriver**  subclass,

        **See also** **unsubscribeFromNotification** (),
        **subscribedToNotifications** (), and **QSqlDriver::hasFeature** ().
        """
        ...

    def subscribedToNotifications(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#subscribedToNotifications

        **[virtual] QStringList QSqlDriver::subscribedToNotifications() const**

        Returns a list of the names of the event notifications that are
        currently subscribed to.

        Reimplement this function if you want to provide event notification
        support in your own **QSqlDriver**  subclass,

        **See also** **subscribeToNotification** () and
        **unsubscribeFromNotification** ().
        """
        ...

    def tables(self, tableType: PySide6.QtSql.QSql.TableType) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#tables

        **[virtual] QStringList QSqlDriver::tables(QSql::TableType tableType )
        const**

        Returns a list of the names of the tables in the database. The default
        implementation returns an empty list.

        The **tableType** argument describes what types of tables should be
        returned. Due to binary compatibility, the string contains the value of
        the enum QSql::TableTypes as text. An empty string should be treated as
        **QSql::Tables**  for backward compatibility.
        """
        ...

    def unsubscribeFromNotification(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#unsubscribeFromNotification

        **[virtual] bool QSqlDriver::unsubscribeFromNotification(const QString &
        name )**

        This function is called to unsubscribe from event notifications from the
        database. **name** identifies the event notification.

        If successful, return true, otherwise return false.

        The database must be open when this function is called. All subscribed
        event notifications are automatically unsubscribed from when the
        **close** () function is called.

        After calling **this** function the **notification** () signal will no
        longer be emitted when an event notification identified by **name** is
        posted by the database.

        Reimplement this function if you want to provide event notification
        support in your own **QSqlDriver**  subclass,

        **See also** **subscribeToNotification** () and
        **subscribedToNotifications** ().
        """
        ...

    @property
    def notification(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsqldriver.html#notification

        **[signal, since 5.0] void QSqlDriver::notification(const QString & name
        , QSqlDriver::NotificationSource source , const QVariant & payload )**

        This signal is emitted when the database posts an event notification
        that the driver subscribes to. **name** identifies the event
        notification, **source** indicates the signal source, **payload** holds
        the extra data optionally delivered with the notification.

        This function was introduced in Qt 5.0.

        **See also** **subscribeToNotification** ().
        """
        ...
