"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSerialPort, except for defaults which are replaced by "...".
"""
from typing import List, overload
import PySide6.QtCore
import PySide6.QtSerialPort

bytes = str


class QSerialPortInfo(object):
    """
    https://doc.qt.io/qt-6/qserialportinfo.html

    **Detailed Description**

    Use the static functions to generate a list of QSerialPortInfo objects. Each
    QSerialPortInfo object in the list represents a single serial port and can
    be queried for the port name, system location, description, and
    manufacturer. The QSerialPortInfo class can also be used as an input
    parameter for the setPort() method of the **QSerialPort**  class.

    **See also** **QSerialPort** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#QSerialPortInfo

        **QSerialPortInfo::QSerialPortInfo()**

        Constructs an empty QSerialPortInfo object.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#QSerialPortInfo-1

        **QSerialPortInfo::QSerialPortInfo(const QSerialPort & port )**

        Constructs a QSerialPortInfo object from serial **port**.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtSerialPort.QSerialPortInfo) -> None:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#QSerialPortInfo-2

        **QSerialPortInfo::QSerialPortInfo(const QString & name )**

        Constructs a QSerialPortInfo object from serial port **name**.

        This constructor finds the relevant serial port among the available ones
        according to the port name **name** , and constructs the serial port
        info instance for that port.
        """
        ...

    @overload
    def __init__(self, port: PySide6.QtSerialPort.QSerialPort) -> None:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#QSerialPortInfo-3

        **QSerialPortInfo::QSerialPortInfo(const QSerialPortInfo & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def availablePorts() -> List[PySide6.QtSerialPort.QSerialPortInfo]:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#availablePorts

        **[static] QList<QSerialPortInfo> QSerialPortInfo::availablePorts()**

        Returns a list of available serial ports on the system.
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#description

        **QString QSerialPortInfo::description() const**

        Returns the description string of the serial port, if available;
        otherwise returns an empty string.

        **See also** **manufacturer** () and **serialNumber** ().
        """
        ...

    def hasProductIdentifier(self) -> bool:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#hasProductIdentifier

        **bool QSerialPortInfo::hasProductIdentifier() const**

        Returns `true` if there is a valid `16-bit` product number present;
        otherwise returns `false`.

        **See also** **productIdentifier** (), **vendorIdentifier** (), and
        **hasVendorIdentifier** ().
        """
        ...

    def hasVendorIdentifier(self) -> bool:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#hasVendorIdentifier

        **bool QSerialPortInfo::hasVendorIdentifier() const**

        Returns `true` if there is a valid `16-bit` vendor number present;
        otherwise returns `false`.

        **See also** **vendorIdentifier** (), **productIdentifier** (), and
        **hasProductIdentifier** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#isNull

        **bool QSerialPortInfo::isNull() const**

        Returns whether this **QSerialPortInfo**  object holds a serial port
        definition.
        """
        ...

    def manufacturer(self) -> str:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#manufacturer

        **QString QSerialPortInfo::manufacturer() const**

        Returns the manufacturer string of the serial port, if available;
        otherwise returns an empty string.

        **See also** **description** () and **serialNumber** ().
        """
        ...

    def portName(self) -> str:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#portName

        **QString QSerialPortInfo::portName() const**

        Returns the name of the serial port.

        **See also** **systemLocation** ().
        """
        ...

    def productIdentifier(self) -> int:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#productIdentifier

        **quint16 QSerialPortInfo::productIdentifier() const**

        Returns the 16-bit product number for the serial port, if available;
        otherwise returns zero.

        **See also** **hasProductIdentifier** (), **vendorIdentifier** (), and
        **hasVendorIdentifier** ().
        """
        ...

    def serialNumber(self) -> str:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#serialNumber

        **[since 5.3] QString QSerialPortInfo::serialNumber() const**

        Returns the serial number string of the serial port, if available;
        otherwise returns an empty string.

        **Note:** The serial number may include letters.

        This function was introduced in Qt 5.3.

        **See also** **description** () and **manufacturer** ().
        """
        ...

    @staticmethod
    def standardBaudRates() -> List[int]:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#standardBaudRates

        **[static] QList<qint32> QSerialPortInfo::standardBaudRates()**

        Returns a list of available standard baud rates supported by the target
        platform.
        """
        ...

    def swap(self, other: PySide6.QtSerialPort.QSerialPortInfo) -> None:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#swap

        **void QSerialPortInfo::swap(QSerialPortInfo & other )**

        Swaps **QSerialPortInfo**  **other** with this **QSerialPortInfo** .
        This operation is very fast and never fails.
        """
        ...

    def systemLocation(self) -> str:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#systemLocation

        **QString QSerialPortInfo::systemLocation() const**

        Returns the system location of the serial port.

        **See also** **portName** ().
        """
        ...

    def vendorIdentifier(self) -> int:
        """
        https://doc.qt.io/qt-6/qserialportinfo.html#vendorIdentifier

        **quint16 QSerialPortInfo::vendorIdentifier() const**

        Returns the 16-bit vendor number for the serial port, if available;
        otherwise returns zero.

        **See also** **hasVendorIdentifier** (), **productIdentifier** (), and
        **hasProductIdentifier** ().
        """
        ...
