"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QSensorBackendFactory(object):
    """
    https://doc.qt.io/qt-6/qsensorbackendfactory.html

    **Detailed Description**

    This interface must be implemented in order to register a sensor backend.

    **See also** **Creating a sensor plugin** .
    """

    def __init__(self) -> None:
        ...

    def createBackend(
        self, sensor: PySide6.QtSensors.QSensor
    ) -> PySide6.QtSensors.QSensorBackend:
        """
        https://doc.qt.io/qt-6/qsensorbackendfactory.html#createBackend

        **[pure virtual] QSensorBackend
        *QSensorBackendFactory::createBackend(QSensor * sensor )**

        Instantiate a backend. If the factory handles multiple identifiers it
        should check with the **sensor** to see which one is requested.

        If the factory cannot create a backend it should return 0.
        """
        ...
