"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QRotationSensor(PySide6.QtSensors.QSensor):
    """
    https://doc.qt.io/qt-6/qrotationsensor.html

    **Detailed Description**

    The only behavioural difference is that this class sets the type properly.

    This class also features a **reading** () function that returns a
    **QRotationReading**  instead of a **QSensorReading** .

    For details about how the sensor works, see **QRotationReading** .

    **See also** **QRotationReading** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qrotationsensor.html#QRotationSensor

        **QRotationSensor::QRotationSensor(QObject * parent = nullptr)**

        Construct the sensor as a child of **parent**.
        """
        ...

    def hasZ(self) -> bool:
        """
        https://doc.qt.io/qt-6/qrotationsensor.html#hasZ-prop

        **[read-only] hasZ : const bool**

        This property holds a value indicating if the z angle is available.

        Returns true if z is available. Returns false if z is not available.

        **Access functions:**

        bool **hasZ** () const

        **Notifier signal:**

        void **hasZChanged** (bool **hasZ** )

        **Member Function Documentation**
        """
        ...

    def reading(self) -> PySide6.QtSensors.QRotationReading:
        """
        https://doc.qt.io/qt-6/qrotationsensor.html#reading

        **QRotationReading *QRotationSensor::reading() const**

        Returns the reading class for this sensor.

        **See also** **QSensor::reading** ().
        """
        ...

    def setHasZ(self, hasZ: bool) -> None:
        """
        https://doc.qt.io/qt-6/qrotationsensor.html#setHasZ

        **[since 5.1] void QRotationSensor::setHasZ(bool hasZ )**

        Sets whether the z angle is available to **hasZ**. This is to be called
        from the backend. By default the **hasZ**  property is true, so a
        backend only has to call this if its rotation sensor can not report z
        angles.

        This function was introduced in Qt 5.1.

        **See also** **hasZ** ().
        """
        ...

    @property
    def hasZChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
