"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QGyroscopeReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qgyroscopereading.html

    **Detailed Description**

    **QGyroscopeReading Units**

    The reading contains 3 values, measured in degrees per second that define
    the movement of the device around the x, y and z axes. Unlike
    **QRotationReading** , the values represent the current angular velocity
    rather than a fixed rotation. The measurements are in degrees per second.

    ![](images/sensors-coordinates3.jpg)
    """

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qgyroscopereading.html#setX

        **void QGyroscopeReading::setX(qreal x )**

        Sets the angular velocity around the x axis to **x**.

        **See also** **x** ().
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qgyroscopereading.html#setY

        **void QGyroscopeReading::setY(qreal y )**

        Sets the angular velocity around the y axis to **y**.

        **See also** **y** ().
        """
        ...

    def setZ(self, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qgyroscopereading.html#setZ

        **void QGyroscopeReading::setZ(qreal z )**

        Sets the angular velocity around the z axis to **z**.

        **See also** **z** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qgyroscopereading.html#x-prop

        **[read-only] x : const qreal**

        This property holds the angular velocity around the x axis.

        Measured as degrees per second.

        **Access functions:**

        qreal **x** () const

        **See also** **QGyroscopeReading Units** .
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qgyroscopereading.html#y-prop

        **[read-only] y : const qreal**

        This property holds the angular velocity around the y axis.

        Measured as degrees per second.

        **Access functions:**

        qreal **y** () const

        **See also** **QGyroscopeReading Units** .
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qgyroscopereading.html#z-prop

        **[read-only] z : const qreal**

        This property holds the angular velocity around the z axis.

        Measured as degrees per second.

        **Access functions:**

        qreal **z** () const

        **See also** **QGyroscopeReading Units** .

        **Member Function Documentation**
        """
        ...
