"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QAmbientTemperatureReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qambienttemperaturereading.html

    **Detailed Description**

    The ambient (room) temperature is the temperature in degree Celsius.
    """

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def setTemperature(self, temperature: float) -> None:
        """
        https://doc.qt.io/qt-6/qambienttemperaturereading.html#setTemperature

        **void QAmbientTemperatureReading::setTemperature(qreal temperature )**

        Sets ambient temperature to **temperature**.

        **See also** **temperature** ().
        """
        ...

    def temperature(self) -> float:
        """
        https://doc.qt.io/qt-6/qambienttemperaturereading.html#temperature-prop

        **[read-only] temperature : const qreal**

        This property holds the ambient temperature

        Measured in degree Celsius.

        **Access functions:**

        qreal **temperature** () const

        **Member Function Documentation**
        """
        ...
