"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtScxml, except for defaults which are replaced by "...".
"""
from typing import List, Tuple
import PySide6.QtCore
import PySide6.QtScxml

bytes = str


class QScxmlTableData(object):
    """
    https://doc.qt.io/qt-6/qscxmltabledata.html

    **Detailed Description**

    QScxmlTableData is the interface to the compiled representation of SCXML
    state machines. It should only be used internally and by state machines
    compiled from SCXML documents.
    """

    def __init__(self) -> None:
        ...

    def assignmentInfo(
        self, assignmentId: int
    ) -> PySide6.QtScxml.QScxmlExecutableContent.AssignmentInfo:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#assignmentInfo

        **[pure virtual] QScxmlExecutableContent::AssignmentInfo
        QScxmlTableData::assignmentInfo(QScxmlExecutableContent::EvaluatorId
        assignmentId ) const**

        Returns the **QScxmlExecutableContent::AssignmentInfo**  object for the
        given **assignmentId**.
        """
        ...

    def dataNames(self) -> Tuple[List[int], int]:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#dataNames

        **[pure virtual] QScxmlExecutableContent::StringId
        *QScxmlTableData::dataNames(int * count ) const**

        Retrieves the string IDs for the names of data items in the data model.
        The number of strings is saved into **count** and a pointer to an array
        of string IDs is returned.

        Returns a pointer to an array of string IDs.
        """
        ...

    def evaluatorInfo(
        self, evaluatorId: int
    ) -> PySide6.QtScxml.QScxmlExecutableContent.EvaluatorInfo:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#evaluatorInfo

        **[pure virtual] QScxmlExecutableContent::EvaluatorInfo
        QScxmlTableData::evaluatorInfo(QScxmlExecutableContent::EvaluatorId
        evaluatorId ) const**

        Returns the **QScxmlExecutableContent::EvaluatorInfo**  object for the
        given **evaluatorId**.
        """
        ...

    def foreachInfo(
        self, foreachId: int
    ) -> PySide6.QtScxml.QScxmlExecutableContent.ForeachInfo:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#foreachInfo

        **[pure virtual] QScxmlExecutableContent::ForeachInfo
        QScxmlTableData::foreachInfo(QScxmlExecutableContent::EvaluatorId
        foreachId ) const**

        Returns the **QScxmlExecutableContent::ForeachInfo**  object for the
        given **foreachId**.
        """
        ...

    def initialSetup(self) -> int:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#initialSetup

        **[pure virtual] QScxmlExecutableContent::ContainerId
        QScxmlTableData::initialSetup() const**

        Initializes the table data. Returns the ID of the container with
        instructions to be executed when initializing the state machine.
        """
        ...

    def instructions(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#instructions

        **[pure virtual] QScxmlExecutableContent::InstructionId
        *QScxmlTableData::instructions() const**

        Returns a pointer to the instructions of executable content contained in
        the state machine.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#name

        **[pure virtual] QString QScxmlTableData::name() const**

        Returns the name of the state machine.
        """
        ...

    def serviceFactory(self, id: int) -> PySide6.QtScxml.QScxmlInvokableServiceFactory:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#serviceFactory

        **[pure virtual] QScxmlInvokableServiceFactory
        *QScxmlTableData::serviceFactory(int id ) const**

        Returns the service factory that creates invokable services for the
        state with the ID **id**.
        """
        ...

    def stateMachineTable(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#stateMachineTable

        **[pure virtual] const qint32 *QScxmlTableData::stateMachineTable()
        const**

        Returns a pointer to the complete state table, expressed as an opaque
        sequence of integers.
        """
        ...

    def string(self, id: int) -> str:
        """
        https://doc.qt.io/qt-6/qscxmltabledata.html#string

        **[pure virtual] QString
        QScxmlTableData::string(QScxmlExecutableContent::StringId id ) const**

        Returns a **QString**  for the given **id**.
        """
        ...
