"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtScxml, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, overload
import PySide6.QtCore
import PySide6.QtScxml

bytes = str


class QScxmlEvent(object):
    """
    https://doc.qt.io/qt-6/qscxmlevent.html

    **Detailed Description**

    SCXML **events** drive transitions. Most events are generated by using the
    `<raise>` and `<send>` elements in the application. The state machine
    automatically generates some mandatory events, such as errors.

    For more information, see **SCXML Specification - 5.10.1 The Internal
    Structure of Events** . For more information about how the Qt SCXML API
    differs from the specification, see **SCXML Compliance** .

    **See also** **QScxmlStateMachine** .
    """

    PlatformEvent: QScxmlEvent.EventType = ...
    InternalEvent: QScxmlEvent.EventType = ...
    ExternalEvent: QScxmlEvent.EventType = ...

    class EventType(Enum):
        PlatformEvent: QScxmlEvent.EventType = ...
        InternalEvent: QScxmlEvent.EventType = ...
        ExternalEvent: QScxmlEvent.EventType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#QScxmlEvent

        **QScxmlEvent::QScxmlEvent()**

        Creates a new external SCXML event.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtScxml.QScxmlEvent) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#QScxmlEvent-1

        **QScxmlEvent::QScxmlEvent(const QScxmlEvent & other )**

        Constructs a copy of **other**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#clear

        **[invokable] void QScxmlEvent::clear()**

        Clears the contents of the event.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def data(self) -> Any:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#data

        **QVariant QScxmlEvent::data() const**

        Returns the data included by the sender.

        **Note:** Getter function for property data.

        **See also** **setData** ().
        """
        ...

    def delay(self) -> int:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#delay

        **int QScxmlEvent::delay() const**

        Returns the delay in milliseconds after which this event is to be
        delivered after processing the `<send>` element.

        **Note:** Getter function for property delay.

        **See also** **setDelay** ().
        """
        ...

    def errorMessage(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#errorMessage

        **QString QScxmlEvent::errorMessage() const**

        If this is an error event, returns the error message. Otherwise, returns
        an empty **QString** .

        **Note:** Getter function for property errorMessage.

        **See also** **setErrorMessage** ().
        """
        ...

    def eventType(self) -> PySide6.QtScxml.QScxmlEvent.EventType:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#eventType

        **QScxmlEvent::EventType QScxmlEvent::eventType() const**

        Returns the type of this event.

        **Note:** Getter function for property eventType.

        **See also** **setEventType** () and **QScxmlEvent::EventType** .
        """
        ...

    def invokeId(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#invokeId

        **QString QScxmlEvent::invokeId() const**

        If this event is generated by an invoked state machine, returns the ID
        of the `<invoke>` element. Otherwise, returns an empty value.

        **Note:** Getter function for property invokeId.

        **See also** **setInvokeId** ().
        """
        ...

    def isErrorEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#isErrorEvent

        **bool QScxmlEvent::isErrorEvent() const**

        Returns `true` when this is an error event, `false` otherwise.

        **Note:** Getter function for property **errorEvent** .
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#name

        **QString QScxmlEvent::name() const**

        Returns the name of the event.

        **Note:** Getter function for property name.

        **See also** **setName** ().
        """
        ...

    def origin(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#origin

        **QString QScxmlEvent::origin() const**

        Returns a URI that points to the origin of an SCXML event.

        **Note:** Getter function for property origin.

        **See also** **setOrigin** ().
        """
        ...

    def originType(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#originType

        **QString QScxmlEvent::originType() const**

        Returns the origin type of an SCXML event.

        **Note:** Getter function for property originType.

        **See also** **setOriginType** ().
        """
        ...

    def scxmlType(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#scxmlType

        **QString QScxmlEvent::scxmlType() const**

        Returns the event type.

        **Note:** Getter function for property scxmlType.
        """
        ...

    def sendId(self) -> str:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#sendId

        **QString QScxmlEvent::sendId() const**

        Returns the ID of the event.

        **Note:** Getter function for property sendId.

        **See also** **setSendId** ().
        """
        ...

    def setData(self, data: Any) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setData

        **void QScxmlEvent::setData(const QVariant & data )**

        Sets the payload data to **data**.

        **Note:** Setter function for property **data** .

        **See also** **QScxmlEvent::data** .
        """
        ...

    def setDelay(self, delayInMiliSecs: int) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setDelay

        **void QScxmlEvent::setDelay(int delayInMiliSecs )**

        Sets the delay in milliseconds as the value of **delayInMiliSecs**.

        **Note:** Setter function for property **delay** .

        **See also** **QScxmlEvent::delay** .
        """
        ...

    def setErrorMessage(self, message: str) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setErrorMessage

        **void QScxmlEvent::setErrorMessage(const QString & message )**

        If this is an error event, the **message** is set as the error message.

        **Note:** Setter function for property **errorMessage** .

        **See also** **errorMessage** ().
        """
        ...

    def setEventType(self, type: PySide6.QtScxml.QScxmlEvent.EventType) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setEventType

        **void QScxmlEvent::setEventType(const QScxmlEvent::EventType & type )**

        Sets the event type to **type**.

        **Note:** Setter function for property **eventType** .

        **See also** **QScxmlEvent::eventType**  and **QScxmlEvent::EventType**
        .
        """
        ...

    def setInvokeId(self, invokeId: str) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setInvokeId

        **void QScxmlEvent::setInvokeId(const QString & invokeid )**

        Sets the ID of an invoked state machine to **invokeid**.

        **Note:** Setter function for property **invokeId** .

        **See also** **QScxmlEvent::invokeId** .
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setName

        **void QScxmlEvent::setName(const QString & name )**

        Sets the name of the event to **name**.

        **Note:** Setter function for property **name** .

        **See also** **name** ().
        """
        ...

    def setOrigin(self, origin: str) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setOrigin

        **void QScxmlEvent::setOrigin(const QString & origin )**

        Sets the origin of an SCXML event to **origin**.

        **Note:** Setter function for property **origin** .

        **See also** **QScxmlEvent::origin** .
        """
        ...

    def setOriginType(self, originType: str) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setOriginType

        **void QScxmlEvent::setOriginType(const QString & origintype )**

        Sets the origin type of an SCXML event to **origintype**.

        **Note:** Setter function for property **originType** .

        **See also** **QScxmlEvent::originType** .
        """
        ...

    def setSendId(self, sendId: str) -> None:
        """
        https://doc.qt.io/qt-6/qscxmlevent.html#setSendId

        **void QScxmlEvent::setSendId(const QString & sendid )**

        Sets the ID **sendid** for this event.

        **Note:** Setter function for property **sendId** .

        **See also** **sendId** ().
        """
        ...
