"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtRemoteObjects, except for defaults which are replaced by "...".
"""
from typing import Dict, Tuple
import PySide6.QtCore
import PySide6.QtRemoteObjects

bytes = str


class QRemoteObjectRegistry(PySide6.QtRemoteObjects.QRemoteObjectReplica):
    """
    https://doc.qt.io/qt-6/qremoteobjectregistry.html

    **Detailed Description**

    The Registry is a special Source/Replica pair held by a **node**  itself. It
    knows about all other **Source** s available on the network, and simplifies
    the process of connecting to other **node** s.
    """

    def addSource(
        self, entry: Tuple[str, PySide6.QtRemoteObjects.QRemoteObjectSourceLocationInfo]
    ) -> None:
        ...

    def initialize(self) -> None:
        ...

    def pushToRegistryIfNeeded(self) -> None:
        ...

    @staticmethod
    def registerMetatypes() -> None:
        ...

    def removeSource(
        self, entry: Tuple[str, PySide6.QtRemoteObjects.QRemoteObjectSourceLocationInfo]
    ) -> None:
        ...

    def sourceLocations(
        self,
    ) -> Dict[str, PySide6.QtRemoteObjects.QRemoteObjectSourceLocationInfo]:
        """
        https://doc.qt.io/qt-6/qremoteobjectregistry.html#sourceLocations

        **QRemoteObjectSourceLocations QRemoteObjectRegistry::sourceLocations()
        const**

        Returns a QRemoteObjectSourceLocations object, which includes the name
        and additional information of all sources known to the registry.

        **Note:** Getter function for property sourceLocations.
        """
        ...

    @property
    def remoteObjectAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qremoteobjectregistry.html#remoteObjectAdded

        **[signal] void QRemoteObjectRegistry::remoteObjectAdded(const
        QRemoteObjectSourceLocation & entry )**

        This signal is emitted whenever a new source location is added to the
        registry.

        **entry** is a QRemoteObjectSourceLocation, a typedef for
        QPair<**QString** , **QUrl** >.

        **See also** **remoteObjectRemoved** ().
        """
        ...

    @property
    def remoteObjectRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qremoteobjectregistry.html#remoteObjectRemoved

        **[signal] void QRemoteObjectRegistry::remoteObjectRemoved(const
        QRemoteObjectSourceLocation & entry )**

        This signal is emitted whenever a Source location is removed from the
        Registry.

        **entry** is a QRemoteObjectSourceLocation, a typedef for
        QPair<**QString** , **QUrl** >.

        **See also** **remoteObjectAdded** ().
        """
        ...
