"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick3D, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtQml
import PySide6.QtQuick3D

bytes = str


class QQuick3DObject(PySide6.QtCore.QObject, PySide6.QtQml.QQmlParserStatus):
    """
    https://doc.qt.io/qt-6/qquick3dobject.html

    **Detailed Description**

    **Object3D**  is the base class for all Qt Quick 3D scene objects. Currently
    the types available in C++ are:

    * **QQuick3DGeometry**
      * **QQuick3DTextureData**

    Both of these types are resource objects which directly inherit
    QQuick3DObject.

    It should not be necessary to use QQuick3DObject directly anywhere currently
    because it is just an interface for supporting spatial items and resources
    in a 3D scene, as well as exposing similar functionality as **QQuickItem**
    for 3D scene content.
    """

    ItemChildAddedChange: QQuick3DObject.ItemChange = ...
    ItemChildRemovedChange: QQuick3DObject.ItemChange = ...
    ItemSceneChange: QQuick3DObject.ItemChange = ...
    ItemVisibleHasChanged: QQuick3DObject.ItemChange = ...
    ItemParentHasChanged: QQuick3DObject.ItemChange = ...
    ItemOpacityHasChanged: QQuick3DObject.ItemChange = ...
    ItemActiveFocusHasChanged: QQuick3DObject.ItemChange = ...
    ItemRotationHasChanged: QQuick3DObject.ItemChange = ...
    ItemAntialiasingHasChanged: QQuick3DObject.ItemChange = ...
    ItemDevicePixelRatioHasChanged: QQuick3DObject.ItemChange = ...
    ItemEnabledHasChanged: QQuick3DObject.ItemChange = ...

    class ItemChange(Enum):
        ItemChildAddedChange: QQuick3DObject.ItemChange = ...
        ItemChildRemovedChange: QQuick3DObject.ItemChange = ...
        ItemSceneChange: QQuick3DObject.ItemChange = ...
        ItemVisibleHasChanged: QQuick3DObject.ItemChange = ...
        ItemParentHasChanged: QQuick3DObject.ItemChange = ...
        ItemOpacityHasChanged: QQuick3DObject.ItemChange = ...
        ItemActiveFocusHasChanged: QQuick3DObject.ItemChange = ...
        ItemRotationHasChanged: QQuick3DObject.ItemChange = ...
        ItemAntialiasingHasChanged: QQuick3DObject.ItemChange = ...
        ItemDevicePixelRatioHasChanged: QQuick3DObject.ItemChange = ...
        ItemEnabledHasChanged: QQuick3DObject.ItemChange = ...

    def childItems(self) -> List[PySide6.QtQuick3D.QQuick3DObject]:
        ...

    def classBegin(self) -> None:
        ...

    def componentComplete(self) -> None:
        ...

    def isComponentComplete(self) -> bool:
        ...

    def markAllDirty(self) -> None:
        ...

    def parentItem(self) -> PySide6.QtQuick3D.QQuick3DObject:
        ...

    def preSync(self) -> None:
        ...

    def setParentItem(self, parentItem: PySide6.QtQuick3D.QQuick3DObject) -> None:
        ...

    def setState(self, state: str) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dobject.html#state-prop

        **state : QString**

        This property holds the name of the current state of the object.

        If the item is in its default state, that is, no explicit state has been
        set, then this property holds an empty string. Likewise, you can return
        an item to its default state by setting this property to an empty
        string.

        **Access functions:**

        QString **state** () const
        void **setState** (const QString &
        **state** )

        **Notifier signal:**

        void **stateChanged** ()

        **See also** **Qt Quick States** .
        """
        ...

    def state(self) -> str:
        """
        https://doc.qt.io/qt-6/qquick3dobject.html#state-prop

        **state : QString**

        This property holds the name of the current state of the object.

        If the item is in its default state, that is, no explicit state has been
        set, then this property holds an empty string. Likewise, you can return
        an item to its default state by setting this property to an empty
        string.

        **Access functions:**

        QString **state** () const
        void **setState** (const QString &
        **state** )

        **Notifier signal:**

        void **stateChanged** ()

        **See also** **Qt Quick States** .
        """
        ...

    def update(self) -> None:
        ...

    @property
    def parentChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def stateChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
