"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGTexture(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsgtexture.html

    **Detailed Description**

    Users can freely implement their own texture classes to support arbitrary
    input textures, such as YUV video frames or 8 bit alpha masks. The scene
    graph provides a default implementation for RGBA textures.The default
    implementation is not instantiated directly, rather they are constructed via
    factory functions, such as **QQuickWindow::createTextureFromImage** ().

    With the default implementation, each QSGTexture is backed by a QRhiTexture,
    which in turn contains a native texture object, such as an OpenGL texture or
    a Vulkan image.

    The size in pixels is given by **textureSize** (). **hasAlphaChannel** ()
    reports if the texture contains opacity values and **hasMipmaps** () reports
    if the texture contains mipmap levels.

    **Materials**  that work with textures reimplement **updateSampledImage** ()
    to provide logic that decides which QSGTexture's underlying native texture
    should be exposed at a given shader resource binding point.

    QSGTexture does not separate image (texture) and sampler objects. The
    parameters for filtering and wrapping can be specified with
    **setMipmapFiltering** (), **setFiltering** (), **setHorizontalWrapMode** ()
    and **setVerticalWrapMode** (). The scene graph and Qt's graphics
    abstraction takes care of creating separate sampler objects, when
    applicable.

    **Texture Atlases**

    Some scene graph backends use texture atlasses, grouping multiple small
    textures into one large texture. If this is the case, the function
    **isAtlasTexture** () will return true. Atlases are used to aid the
    rendering algorithm to do better sorting which increases performance.
    Atlases are also essential for batching (merging together geometry to reduce
    the number of draw calls), because two instances of the same material using
    two different QSGTextures are not batchable, whereas if both QSGTextures
    refer to the same atlas, batching can happen, assuming the materials are
    otherwise compatible.

    The location of the texture inside the atlas is given with the
    **normalizedTextureSubRect** () function.

    If the texture is used in such a way that atlas is not preferable, the
    function **removedFromAtlas** () can be used to extract a non-atlased copy.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **See also** **Scene Graph - Rendering FBOs** .
    """

    AnisotropyNone: QSGTexture.AnisotropyLevel = ...
    Anisotropy2x: QSGTexture.AnisotropyLevel = ...
    Anisotropy4x: QSGTexture.AnisotropyLevel = ...
    Anisotropy8x: QSGTexture.AnisotropyLevel = ...
    Anisotropy16x: QSGTexture.AnisotropyLevel = ...
    None_: QSGTexture.Filtering = ...
    Nearest: QSGTexture.Filtering = ...
    Linear: QSGTexture.Filtering = ...
    Repeat: QSGTexture.WrapMode = ...
    ClampToEdge: QSGTexture.WrapMode = ...
    MirroredRepeat: QSGTexture.WrapMode = ...

    class AnisotropyLevel(Enum):
        AnisotropyNone: QSGTexture.AnisotropyLevel = ...
        Anisotropy2x: QSGTexture.AnisotropyLevel = ...
        Anisotropy4x: QSGTexture.AnisotropyLevel = ...
        Anisotropy8x: QSGTexture.AnisotropyLevel = ...
        Anisotropy16x: QSGTexture.AnisotropyLevel = ...

    class Filtering(Enum):
        None_: QSGTexture.Filtering = ...
        Nearest: QSGTexture.Filtering = ...
        Linear: QSGTexture.Filtering = ...

    class WrapMode(Enum):
        Repeat: QSGTexture.WrapMode = ...
        ClampToEdge: QSGTexture.WrapMode = ...
        MirroredRepeat: QSGTexture.WrapMode = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#QSGTexture

        **QSGTexture::QSGTexture()**

        Constructs the QSGTexture base class.
        """
        ...

    def anisotropyLevel(self) -> PySide6.QtQuick.QSGTexture.AnisotropyLevel:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#anisotropyLevel

        **[since 5.9] QSGTexture::AnisotropyLevel QSGTexture::anisotropyLevel()
        const**

        Returns the anisotropy level in use for filtering this texture.

        This function was introduced in Qt 5.9.

        **See also** **setAnisotropyLevel** ().
        """
        ...

    def comparisonKey(self) -> int:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#comparisonKey

        **[pure virtual, since 5.14] qint64 QSGTexture::comparisonKey() const**

        Returns a key suitable for comparing textures. Typically used in
        **QSGMaterial::compare** () implementations.

        Just comparing **QSGTexture**  pointers is not always sufficient because
        two **QSGTexture**  instances that refer to the same native texture
        object underneath should also be considered equal. Hence the need for
        this function.

        Implementations of this function are not expected to, and should not
        create any graphics resources (native texture objects) in case there are
        none yet.

        A **QSGTexture**  that does not have a native texture object underneath
        is typically **not** equal to any other **QSGTexture** , so the return
        value has to be crafted accordingly. There are exceptions to this, in
        particular when atlasing is used (where multiple textures share the same
        atlas texture under the hood), that is then up to the subclass
        implementations to deal with as appropriate.

        **Warning:** This function can only be called from the rendering thread.

        This function was introduced in Qt 5.14.
        """
        ...

    def convertToNormalizedSourceRect(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#convertToNormalizedSourceRect

        **QRectF QSGTexture::convertToNormalizedSourceRect(const QRectF & rect )
        const**

        Returns **rect** converted to normalized coordinates.

        **See also** **normalizedTextureSubRect** ().
        """
        ...

    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#filtering

        **QSGTexture::Filtering QSGTexture::filtering() const**

        Returns the sampling mode to be used for this texture.

        **See also** **setFiltering** ().
        """
        ...

    def hasAlphaChannel(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#hasAlphaChannel

        **[pure virtual] bool QSGTexture::hasAlphaChannel() const**

        Returns true if the texture data contains an alpha channel.
        """
        ...

    def hasMipmaps(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#hasMipmaps

        **[pure virtual] bool QSGTexture::hasMipmaps() const**

        Returns true if the texture data contains mipmap levels.
        """
        ...

    def horizontalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#horizontalWrapMode

        **QSGTexture::WrapMode QSGTexture::horizontalWrapMode() const**

        Returns the horizontal wrap mode to be used for this texture.

        **See also** **setHorizontalWrapMode** ().
        """
        ...

    def isAtlasTexture(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#isAtlasTexture

        **[virtual] bool QSGTexture::isAtlasTexture() const**

        Returns whether this texture is part of an atlas or not.

        The default implementation returns false.
        """
        ...

    def mipmapFiltering(self) -> PySide6.QtQuick.QSGTexture.Filtering:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#mipmapFiltering

        **QSGTexture::Filtering QSGTexture::mipmapFiltering() const**

        Returns whether mipmapping should be used when sampling from this
        texture.

        **See also** **setMipmapFiltering** ().
        """
        ...

    def normalizedTextureSubRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#normalizedTextureSubRect

        **[virtual] QRectF QSGTexture::normalizedTextureSubRect() const**

        Returns the rectangle inside **textureSize** () that this texture
        represents in normalized coordinates.

        The default implementation returns a rect at position (0, 0) with width
        and height of 1.
        """
        ...

    def resolveInterface(self, name: bytes, revision: int) -> int:
        ...

    def setAnisotropyLevel(
        self, level: PySide6.QtQuick.QSGTexture.AnisotropyLevel
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#setAnisotropyLevel

        **[since 5.9] void
        QSGTexture::setAnisotropyLevel(QSGTexture::AnisotropyLevel level )**

        Sets the level of anisotropic filtering to **level**. The default value
        is **QSGTexture::AnisotropyNone** , which means no anisotropic filtering
        is enabled.

        **Note:** The request may be ignored depending on the graphics API in
        use. There is no guarantee anisotropic filtering is supported at run
        time.

        This function was introduced in Qt 5.9.

        **See also** **anisotropyLevel** ().
        """
        ...

    def setFiltering(self, filter: PySide6.QtQuick.QSGTexture.Filtering) -> None:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#setFiltering

        **void QSGTexture::setFiltering(QSGTexture::Filtering filter )**

        Sets the sampling mode to **filter**.

        **See also** **filtering** ().
        """
        ...

    def setHorizontalWrapMode(self, hwrap: PySide6.QtQuick.QSGTexture.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#setHorizontalWrapMode

        **void QSGTexture::setHorizontalWrapMode(QSGTexture::WrapMode hwrap )**

        Sets the horizontal wrap mode to **hwrap**

        **See also** **horizontalWrapMode** ().
        """
        ...

    def setMipmapFiltering(self, filter: PySide6.QtQuick.QSGTexture.Filtering) -> None:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#setMipmapFiltering

        **void QSGTexture::setMipmapFiltering(QSGTexture::Filtering filter )**

        Sets the mipmap sampling mode to **filter**.

        Setting the mipmap filtering has no effect it the texture does not have
        mipmaps.

        **See also** **mipmapFiltering** () and **hasMipmaps** ().
        """
        ...

    def setVerticalWrapMode(self, vwrap: PySide6.QtQuick.QSGTexture.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#setVerticalWrapMode

        **void QSGTexture::setVerticalWrapMode(QSGTexture::WrapMode vwrap )**

        Sets the vertical wrap mode to **vwrap**

        **See also** **verticalWrapMode** ().
        """
        ...

    def textureSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#textureSize

        **[pure virtual] QSize QSGTexture::textureSize() const**

        Returns the size of the texture.
        """
        ...

    def verticalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode:
        """
        https://doc.qt.io/qt-6/qsgtexture.html#verticalWrapMode

        **QSGTexture::WrapMode QSGTexture::verticalWrapMode() const**

        Returns the vertical wrap mode to be used for this texture.

        **See also** **setVerticalWrapMode** ().
        """
        ...
