"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from typing import Any, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGSimpleRectNode(PySide6.QtQuick.QSGGeometryNode):
    """
    https://doc.qt.io/qt-6/qsgsimplerectnode.html

    **Detailed Description**

    **Warning:** This utility class is only functional when running with the
    default or software backends of the Qt Quick scenegraph. As an alternative,
    prefer using **QSGRectangleNode**  via **QQuickWindow::createRectangleNode**
    (). However, this standalone class is still useful when used via subclassing
    and the application knows that no special scenegraph backends will be
    involved.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimplerectnode.html#QSGSimpleRectNode

        **QSGSimpleRectNode::QSGSimpleRectNode(const QRectF & rect , const
        QColor & color )**

        Constructs a QSGSimpleRectNode instance which is spanning **rect** with
        the color **color**.
        """
        ...

    @overload
    def __init__(
        self,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimplerectnode.html#QSGSimpleRectNode-1

        **QSGSimpleRectNode::QSGSimpleRectNode()**

        Constructs a QSGSimpleRectNode instance with an empty rectangle and
        white color.
        """
        ...

    def color(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qsgsimplerectnode.html#color

        **QColor QSGSimpleRectNode::color() const**

        Returns the color of this rectangle.

        **See also** **setColor** ().
        """
        ...

    def rect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qsgsimplerectnode.html#rect

        **QRectF QSGSimpleRectNode::rect() const**

        Returns the rectangle that this rect node covers.

        **See also** **setRect** ().
        """
        ...

    def setColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimplerectnode.html#setColor

        **void QSGSimpleRectNode::setColor(const QColor & color )**

        Sets the color of this rectangle to **color**. The default color will be
        white.

        **See also** **color** ().
        """
        ...

    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimplerectnode.html#setRect

        **void QSGSimpleRectNode::setRect(const QRectF & rect )**

        Sets the rectangle of this rect node to **rect**.

        **See also** **rect** ().
        """
        ...

    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimplerectnode.html#setRect-1

        **void QSGSimpleRectNode::setRect(qreal x , qreal y , qreal w , qreal h
        )**

        This is an overloaded function.

        Sets the rectangle of this rect node to begin at ( **x** , **y** ) and
        have width **w** and height **h**.
        """
        ...
