"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGRendererInterface(object):
    """
    https://doc.qt.io/qt-6/qsgrendererinterface.html

    **Detailed Description**

    Renderer interfaces allow accessing graphics API specific functionality in
    the scenegraph. Such internals are not typically exposed. However, when
    integrating custom rendering via **QSGRenderNode**  for example, it may
    become necessary to query certain values, for instance the graphics device
    (e.g. the Direct3D or Vulkan device) that is used by the scenegraph.

    QSGRendererInterface's functions have varying availability. API and language
    queries, such as, **graphicsApi** () or **shaderType** () are always
    available, meaning it is sufficient to construct a **QQuickWindow**  or
    **QQuickView** , and the graphics API or shading language in use can be
    queried right after via **QQuickWindow::rendererInterface** (). This
    guarantees that utilities like the **GraphicsInfo**  QML type are able to
    report the correct values as early as possible, without having conditional
    property values - depending on for instance **shaderType** () - evaluate to
    unexpected values.

    Engine-specific accessors, like **getResource** (), are however available
    only after the scenegraph is initialized. Additionally, there may be
    backend-specific limitations on when such functions can be called. The only
    way that is guaranteed to succeed is calling them when the rendering of a
    node (i.e. the preparation of the command list for the next frame) is
    active. In practice this typically means **QSGRenderNode::render** ().
    """

    Unknown: QSGRendererInterface.GraphicsApi = ...
    Software: QSGRendererInterface.GraphicsApi = ...
    OpenVG: QSGRendererInterface.GraphicsApi = ...
    OpenGL: QSGRendererInterface.GraphicsApi = ...
    OpenGLRhi: QSGRendererInterface.GraphicsApi = ...
    Direct3D11: QSGRendererInterface.GraphicsApi = ...
    Direct3D11Rhi: QSGRendererInterface.GraphicsApi = ...
    Vulkan: QSGRendererInterface.GraphicsApi = ...
    VulkanRhi: QSGRendererInterface.GraphicsApi = ...
    Metal: QSGRendererInterface.GraphicsApi = ...
    MetalRhi: QSGRendererInterface.GraphicsApi = ...
    Null: QSGRendererInterface.GraphicsApi = ...
    NullRhi: QSGRendererInterface.GraphicsApi = ...
    RenderMode2D: QSGRendererInterface.RenderMode = ...
    RenderMode2DNoDepthBuffer: QSGRendererInterface.RenderMode = ...
    RenderMode3D: QSGRendererInterface.RenderMode = ...
    DeviceResource: QSGRendererInterface.Resource = ...
    CommandQueueResource: QSGRendererInterface.Resource = ...
    CommandListResource: QSGRendererInterface.Resource = ...
    PainterResource: QSGRendererInterface.Resource = ...
    RhiResource: QSGRendererInterface.Resource = ...
    RhiSwapchainResource: QSGRendererInterface.Resource = ...
    RhiRedirectCommandBuffer: QSGRendererInterface.Resource = ...
    RhiRedirectRenderTarget: QSGRendererInterface.Resource = ...
    PhysicalDeviceResource: QSGRendererInterface.Resource = ...
    OpenGLContextResource: QSGRendererInterface.Resource = ...
    DeviceContextResource: QSGRendererInterface.Resource = ...
    CommandEncoderResource: QSGRendererInterface.Resource = ...
    VulkanInstanceResource: QSGRendererInterface.Resource = ...
    RenderPassResource: QSGRendererInterface.Resource = ...
    RuntimeCompilation: QSGRendererInterface.ShaderCompilationType = ...
    OfflineCompilation: QSGRendererInterface.ShaderCompilationType = ...
    ShaderSourceString: QSGRendererInterface.ShaderSourceType = ...
    ShaderSourceFile: QSGRendererInterface.ShaderSourceType = ...
    ShaderByteCode: QSGRendererInterface.ShaderSourceType = ...
    UnknownShadingLanguage: QSGRendererInterface.ShaderType = ...
    GLSL: QSGRendererInterface.ShaderType = ...
    HLSL: QSGRendererInterface.ShaderType = ...
    RhiShader: QSGRendererInterface.ShaderType = ...

    class GraphicsApi(Enum):
        Unknown: QSGRendererInterface.GraphicsApi = ...
        Software: QSGRendererInterface.GraphicsApi = ...
        OpenVG: QSGRendererInterface.GraphicsApi = ...
        OpenGL: QSGRendererInterface.GraphicsApi = ...
        OpenGLRhi: QSGRendererInterface.GraphicsApi = ...
        Direct3D11: QSGRendererInterface.GraphicsApi = ...
        Direct3D11Rhi: QSGRendererInterface.GraphicsApi = ...
        Vulkan: QSGRendererInterface.GraphicsApi = ...
        VulkanRhi: QSGRendererInterface.GraphicsApi = ...
        Metal: QSGRendererInterface.GraphicsApi = ...
        MetalRhi: QSGRendererInterface.GraphicsApi = ...
        Null: QSGRendererInterface.GraphicsApi = ...
        NullRhi: QSGRendererInterface.GraphicsApi = ...

    class RenderMode(Enum):
        RenderMode2D: QSGRendererInterface.RenderMode = ...
        RenderMode2DNoDepthBuffer: QSGRendererInterface.RenderMode = ...
        RenderMode3D: QSGRendererInterface.RenderMode = ...

    class Resource(Enum):
        DeviceResource: QSGRendererInterface.Resource = ...
        CommandQueueResource: QSGRendererInterface.Resource = ...
        CommandListResource: QSGRendererInterface.Resource = ...
        PainterResource: QSGRendererInterface.Resource = ...
        RhiResource: QSGRendererInterface.Resource = ...
        RhiSwapchainResource: QSGRendererInterface.Resource = ...
        RhiRedirectCommandBuffer: QSGRendererInterface.Resource = ...
        RhiRedirectRenderTarget: QSGRendererInterface.Resource = ...
        PhysicalDeviceResource: QSGRendererInterface.Resource = ...
        OpenGLContextResource: QSGRendererInterface.Resource = ...
        DeviceContextResource: QSGRendererInterface.Resource = ...
        CommandEncoderResource: QSGRendererInterface.Resource = ...
        VulkanInstanceResource: QSGRendererInterface.Resource = ...
        RenderPassResource: QSGRendererInterface.Resource = ...

    class ShaderCompilationType(Enum):
        RuntimeCompilation: QSGRendererInterface.ShaderCompilationType = ...
        OfflineCompilation: QSGRendererInterface.ShaderCompilationType = ...

    class ShaderCompilationTypes(object):
        ...

    class ShaderSourceType(Enum):
        ShaderSourceString: QSGRendererInterface.ShaderSourceType = ...
        ShaderSourceFile: QSGRendererInterface.ShaderSourceType = ...
        ShaderByteCode: QSGRendererInterface.ShaderSourceType = ...

    class ShaderSourceTypes(object):
        ...

    class ShaderType(Enum):
        UnknownShadingLanguage: QSGRendererInterface.ShaderType = ...
        GLSL: QSGRendererInterface.ShaderType = ...
        HLSL: QSGRendererInterface.ShaderType = ...
        RhiShader: QSGRendererInterface.ShaderType = ...

    def __init__(self) -> None:
        ...

    @overload
    def getResource(
        self,
        window: PySide6.QtQuick.QQuickWindow,
        resource: PySide6.QtQuick.QSGRendererInterface.Resource,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qsgrendererinterface.html#getResource

        **[virtual] void *QSGRendererInterface::getResource(QQuickWindow *
        window , QSGRendererInterface::Resource resource ) const**

        Queries a graphics **resource** in **window**. Returns null when the
        resource in question is not supported or not available.

        When successful, the returned pointer is either a direct pointer to an
        interface, or a pointer to an opaque handle that needs to be
        dereferenced first (for example, `VkDevice dev = *static_cast<VkDevice
        \\*>(result)`). The latter is necessary since such handles may have sizes
        different from a pointer.

        **Note:** The ownership of the returned pointer is never transferred to
        the caller.

        **Note:** This function must only be called on the render thread.
        """
        ...

    @overload
    def getResource(self, window: PySide6.QtQuick.QQuickWindow, resource: bytes) -> int:
        """
        https://doc.qt.io/qt-6/qsgrendererinterface.html#getResource-1

        **[virtual] void *QSGRendererInterface::getResource(QQuickWindow *
        window , const char * resource ) const**

        Queries a graphics resource. **resource** is a backend-specific key.
        This allows supporting any future resources that are not listed in the
        Resource enum.

        **Note:** The ownership of the returned pointer is never transferred to
        the caller.

        **Note:** This function must only be called on the render thread.
        """
        ...

    def graphicsApi(self) -> PySide6.QtQuick.QSGRendererInterface.GraphicsApi:
        """
        https://doc.qt.io/qt-6/qsgrendererinterface.html#graphicsApi

        **[pure virtual] QSGRendererInterface::GraphicsApi
        QSGRendererInterface::graphicsApi() const**

        Returns the graphics API that is in use by the Qt Quick scenegraph.

        **Note:** This function can be called on any thread.
        """
        ...

    @staticmethod
    def isApiRhiBased(api: PySide6.QtQuick.QSGRendererInterface.GraphicsApi) -> bool:
        """
        https://doc.qt.io/qt-6/qsgrendererinterface.html#isApiRhiBased

        **[static, since 5.14] bool
        QSGRendererInterface::isApiRhiBased(QSGRendererInterface::GraphicsApi
        api )**

        Returns true if **api** is based on a graphics abstraction layer (QRhi)
        instead of directly calling the native graphics API.

        **Note:** This function can be called on any thread.

        This function was introduced in Qt 5.14.
        """
        ...

    def shaderCompilationType(
        self,
    ) -> PySide6.QtQuick.QSGRendererInterface.ShaderCompilationTypes:
        """
        https://doc.qt.io/qt-6/qsgrendererinterface.html#shaderCompilationType

        **[pure virtual] QSGRendererInterface::ShaderCompilationTypes
        QSGRendererInterface::shaderCompilationType() const**

        Returns a bitmask of the shader compilation approaches supported by the
        Qt Quick backend the application is using.

        **Note:** This function can be called on any thread.

        **See also** **QtQuick::GraphicsInfo** .
        """
        ...

    def shaderSourceType(
        self,
    ) -> PySide6.QtQuick.QSGRendererInterface.ShaderSourceTypes:
        """
        https://doc.qt.io/qt-6/qsgrendererinterface.html#shaderSourceType

        **[pure virtual] QSGRendererInterface::ShaderSourceTypes
        QSGRendererInterface::shaderSourceType() const**

        Returns a bitmask of the supported ways of providing shader sources in
        **ShaderEffect**  items.

        **Note:** This function can be called on any thread.

        **See also** **QtQuick::GraphicsInfo** .
        """
        ...

    def shaderType(self) -> PySide6.QtQuick.QSGRendererInterface.ShaderType:
        """
        https://doc.qt.io/qt-6/qsgrendererinterface.html#shaderType

        **[pure virtual] QSGRendererInterface::ShaderType
        QSGRendererInterface::shaderType() const**

        Returns the shading language supported by the Qt Quick backend the
        application is using.

        **Note:** This function can be called on any thread.

        **See also** **QtQuick::GraphicsInfo** .
        """
        ...
