"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGRenderNode(PySide6.QtQuick.QSGNode):
    """
    https://doc.qt.io/qt-6/qsgrendernode.html

    **Detailed Description**
    """

    BoundedRectRendering: QSGRenderNode.RenderingFlag = ...
    DepthAwareRendering: QSGRenderNode.RenderingFlag = ...
    OpaqueRendering: QSGRenderNode.RenderingFlag = ...
    NoExternalRendering: QSGRenderNode.RenderingFlag = ...
    DepthState: QSGRenderNode.StateFlag = ...
    StencilState: QSGRenderNode.StateFlag = ...
    ScissorState: QSGRenderNode.StateFlag = ...
    ColorState: QSGRenderNode.StateFlag = ...
    BlendState: QSGRenderNode.StateFlag = ...
    CullState: QSGRenderNode.StateFlag = ...
    ViewportState: QSGRenderNode.StateFlag = ...
    RenderTargetState: QSGRenderNode.StateFlag = ...

    class RenderState(object):
        def __init__(self) -> None:
            ...

        def clipRegion(self) -> PySide6.QtGui.QRegion:
            ...

        def get(self, state: bytes) -> int:
            ...

        def projectionMatrix(self) -> PySide6.QtGui.QMatrix4x4:
            ...

        def scissorEnabled(self) -> bool:
            ...

        def scissorRect(self) -> PySide6.QtCore.QRect:
            ...

        def stencilEnabled(self) -> bool:
            ...

        def stencilValue(self) -> int:
            ...

    class RenderingFlag(Enum):
        BoundedRectRendering: QSGRenderNode.RenderingFlag = ...
        DepthAwareRendering: QSGRenderNode.RenderingFlag = ...
        OpaqueRendering: QSGRenderNode.RenderingFlag = ...
        NoExternalRendering: QSGRenderNode.RenderingFlag = ...

    class RenderingFlags(object):
        ...

    class StateFlag(Enum):
        DepthState: QSGRenderNode.StateFlag = ...
        StencilState: QSGRenderNode.StateFlag = ...
        ScissorState: QSGRenderNode.StateFlag = ...
        ColorState: QSGRenderNode.StateFlag = ...
        BlendState: QSGRenderNode.StateFlag = ...
        CullState: QSGRenderNode.StateFlag = ...
        ViewportState: QSGRenderNode.StateFlag = ...
        RenderTargetState: QSGRenderNode.StateFlag = ...

    class StateFlags(object):
        ...

    def __init__(self) -> None:
        ...

    def changedStates(self) -> PySide6.QtQuick.QSGRenderNode.StateFlags:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#changedStates

        **[virtual] QSGRenderNode::StateFlags QSGRenderNode::changedStates()
        const**

        When the underlying rendering API is OpenGL, this function should return
        a mask where each bit represents graphics states changed by the
        **render** () function:

        * **DepthState**  \\- depth write mask, depth test enabled, depth
        comparison function
          * **StencilState**  \\- stencil write masks,
        stencil test enabled, stencil operations, stencil comparison functions
        * **ScissorState**  \\- scissor enabled, scissor test enabled
          *
        **ColorState**  \\- clear color, color write mask
          * **BlendState**  \\-
        blend enabled, blend function
          * **CullState**  \\- front face, cull
        face enabled
          * **ViewportState**  \\- viewport
          *
        **RenderTargetState**  \\- render target

        With APIs other than OpenGL, the only relevant values are the ones that
        correspond to dynamic state changes recorded on the command list/buffer.
        For example, RSSetViewports, RSSetScissorRects, OMSetBlendState,
        OMSetDepthStencilState in case of D3D11, or vkCmdSetViewport,
        vkCmdSetScissor, vkCmdSetBlendConstants, vkCmdSetStencilRef in case of
        Vulkan, and only when such commands were added to the scenegraph's
        command list queried via the QSGRendererInterface::CommandList resource
        enum. States set in pipeline state objects do not need to be reported
        here. Similarly, draw call related settings (pipeline states, descriptor
        sets, vertex or index buffer bindings, root signature, descriptor heaps,
        etc.) are always set again by the scenegraph so **render** () can freely
        change them.

        **Note:****RenderTargetState**  is no longer supported with APIs like
        Vulkan. This is by nature. **render** () is invoked while the Qt Quick
        scenegraph's main command buffer is recording a renderpass, so there is
        no possibility of changing the target and starting another renderpass
        (on that command buffer at least). Therefore returning a value with
        **RenderTargetState**  set is not sensible.

        The software backend exposes its **QPainter**  and saves and restores
        before and after invoking **render** (). Therefore reporting any changed
        states from here is not necessary.

        The function is called by the renderer so it can reset the states after
        rendering this node. This makes the implementation of **render** ()
        simpler since it does not have to query and restore these states.

        The default implementation returns 0, meaning no relevant state was
        changed in **render** ().

        **Note:** This function may be called before **render** ().
        """
        ...

    def clipList(self) -> PySide6.QtQuick.QSGClipNode:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#clipList

        **const QSGClipNode *QSGRenderNode::clipList() const**

        Returns the current clip list.
        """
        ...

    def flags(self) -> PySide6.QtQuick.QSGRenderNode.RenderingFlags:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#flags

        **[virtual] QSGRenderNode::RenderingFlags QSGRenderNode::flags() const**

        Returns flags describing the behavior of this render node.

        The default implementation returns 0.

        **See also** **RenderingFlag**  and **rect** ().
        """
        ...

    def inheritedOpacity(self) -> float:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#inheritedOpacity

        **qreal QSGRenderNode::inheritedOpacity() const**

        Returns the current effective opacity.
        """
        ...

    def matrix(self) -> PySide6.QtGui.QMatrix4x4:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#matrix

        **const QMatrix4x4 *QSGRenderNode::matrix() const**

        Returns pointer to the current model-view matrix.
        """
        ...

    def prepare(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#prepare

        **[virtual, since 6.0] void QSGRenderNode::prepare()**

        Called from the frame preparation phase. There is a call to this
        function before each invocation of **render** ().

        Unlike **render** (), this function is called before the scenegraph
        starts recording the render pass for the current frame on the underlying
        command buffer. This is useful when doing rendering with graphics APIs,
        such as Vulkan, where copy type of operations will need to be recorded
        before the render pass.

        The default implementation is empty.

        This function was introduced in Qt 6.0.
        """
        ...

    def rect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#rect

        **[virtual] QRectF QSGRenderNode::rect() const**

        Returns the bounding rectangle in item coordinates for the area
        **render** () touches. The value is only in use when **flags** ()
        includes **BoundedRectRendering** , ignored otherwise.

        Reporting the rectangle in combination with **BoundedRectRendering**  is
        particularly important with the `software` backend because otherwise
        having a rendernode in the scene would trigger fullscreen updates,
        skipping all partial update optimizations.

        For rendernodes covering the entire area of a corresponding
        **QQuickItem**  the return value will be (0, 0, item->width(),
        item->height()).

        **Note:** Nodes are also free to render outside the boundaries specified
        by the item's width and height, since the scenegraph nodes are not
        bounded by the **QQuickItem**  geometry, as long as this is reported
        correctly from this function.

        **See also** **flags** ().
        """
        ...

    def releaseResources(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#releaseResources

        **[virtual] void QSGRenderNode::releaseResources()**

        This function is called when all custom graphics resources allocated by
        this node have to be freed immediately. In case the node does not
        directly allocate graphics resources (buffers, textures, render targets,
        fences, etc.) through the graphics API that is in use, there is nothing
        to do here.

        Failing to release all custom resources can lead to incorrect behavior
        in graphics device loss scenarios on some systems since subsequent
        reinitialization of the graphics system may fail.

        **Note:** Some scenegraph backends may choose not to call this function.
        Therefore it is expected that **QSGRenderNode**  implementations perform
        cleanup both in their destructor and in releaseResources().

        Unlike with the destructor, it is expected that **render** () can
        reinitialize all resources it needs when called after a call to
        releaseResources().

        With OpenGL, the scenegraph's OpenGL context will be current both when
        calling the destructor and this function.
        """
        ...

    def render(self, state: PySide6.QtQuick.QSGRenderNode.RenderState) -> None:
        """
        https://doc.qt.io/qt-6/qsgrendernode.html#render

        **[pure virtual] void QSGRenderNode::render(const
        QSGRenderNode::RenderState * state )**

        This function is called by the renderer and should paint this node with
        directly invoking commands in the graphics API (OpenGL, Direct3D, etc.)
        currently in use.

        The effective opacity can be retrieved with **inheritedOpacity** ().

        The projection matrix is available through **state** , while the model-
        view matrix can be fetched with **matrix** (). The combined matrix is
        then the projection matrix times the model-view matrix. The correct
        stacking of the items in the scene is ensured by the projection matrix.

        When using the provided matrices, the coordinate system for vertex data
        follows the usual **QQuickItem**  conventions: top-left is (0, 0),
        bottom-right is the corresponding **QQuickItem** 's width() and height()
        minus one. For example, assuming a two float (x-y) per vertex coordinate
        layout, a triangle covering half of the item can be specified as (width
        - 1, height - 1), (0, 0), (0, height - 1) using counter-clockwise
        direction.

        **Note:****QSGRenderNode**  is provided as a means to implement custom
        2D or 2.5D Qt Quick items. It is not intended for integrating true 3D
        content into the Qt Quick scene. That use case is better supported by
        **QQuickFramebufferObject** , **QQuickWindow::beforeRendering** (), or
        the equivalents of those for APIs other than OpenGL.

        **Note:****QSGRenderNode**  can perform significantly better than
        texture-based approaches (such as, **QQuickFramebufferObject** ),
        especially on systems where the fragment processing power is limited.
        This is because it avoids rendering to a texture and then drawing a
        textured quad. Rather, **QSGRenderNode**  allows recording draw calls in
        line with the scenegraph's other commands, avoiding an additional render
        target and the potentially expensive texturing and blending.

        Clip information is calculated before the function is called.
        Implementations wishing to take clipping into account can set up
        scissoring or stencil based on the information in **state**. The stencil
        buffer is filled with the necessary clip shapes, but it is up to the
        implementation to enable stencil testing.

        Some scenegraph backends, software in particular, use no scissor or
        stencil. There the clip region is provided as an ordinary **QRegion** .

        With the legacy, direct OpenGL based renderer, the following states are
        set on the render thread's context before this function is called:

        * glColorMask(true, true, true, true)
          * glDepthMask(false)
          *
        glDisable(GL_DEPTH_TEST)
          * glStencilFunc(GL_EQUAL, state.stencilValue,
        0xff); glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP) depending on clip
          *
        glScissor(state.scissorRect.x(), state.scissorRect.y(),
        state.scissorRect.width(), state.scissorRect.height()) depending on clip
        * glEnable(GL_BLEND)
          * glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA)
          *
        glDisable(GL_CULL_FACE)

        States that are not listed above, but are covered by **StateFlags** ,
        can have arbitrary values.

        **Note:** There is no state set with other graphics APIs, considering
        that many of them do not have a concept of the traditional OpenGL state
        machine. Rather, it is up to the implementation to create pipeline state
        objects with the desired blending, scissor, and stencil tests enabled.
        Note that this also includes OpenGL via the RHI. New **QSGRenderNode**
        implementations are recommended to set all scissor, stencil and blend
        state explicitly (as shown in the above list), even if they are
        targeting OpenGL.

        **changedStates** () should return which states this function changes.
        If a state is not covered by **StateFlags** , the state should be set to
        the default value according to the OpenGL specification. For other APIs,
        see the documentation for **changedStates** () for more information.

        **Note:** Depth writes are disabled when this function is called
        (glDepthMask(false) with OpenGL). Enabling depth writes can lead to
        unexpected results, depending on the scenegraph backend in use and the
        content in the scene, so exercise caution with this.

        For APIs other than OpenGL, it will likely be necessary to query certain
        API-specific resources (for example, the graphics device or the command
        list/buffer to add the commands to). This is done via
        **QSGRendererInterface** .

        Assume nothing about the pipelines and dynamic states bound on the
        command list/buffer when this function is called.

        With some graphics APIs it can be necessary to also connect to the
        **QQuickWindow::beforeRendering** () signal, because that is emitted
        before recording the beginning of a renderpass on the command buffer
        (vkCmdBeginRenderPass with Vulkan, or starting to encode via
        MTLRenderCommandEncoder in case of Metal). Recording copy operations
        cannot be done inside render() with such APIs. Rather, do it in the slot
        connected (with DirectConnection) to the beforeRendering signal.

        **See also** **QSGRendererInterface**  and
        **QQuickWindow::rendererInterface** ().
        """
        ...
