"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGMaterialShader(object):
    """
    https://doc.qt.io/qt-6/qsgmaterialshader.html

    **Detailed Description**

    QSGMaterialShader represents a combination of vertex and fragment shaders,
    data that define the graphics pipeline state changes, and logic that updates
    graphics resources, such as uniform buffers and textures.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    The **QSGMaterial**  and QSGMaterialShader form a tight relationship. For
    one scene graph (including nested graphs), there is one unique
    QSGMaterialShader instance that encapsulates the shaders and other data the
    scene graph uses to render an object with that material. Each
    **QSGGeometryNode**  can have a unique **QSGMaterial**  that defines how the
    graphics pipeline must be configured while drawing the node. An instance of
    QSGMaterialShader is never created explicitly by the user, it will be
    created on demand by the scene graph through **QSGMaterial::createShader**
    (). The scene graph creates an instance of QSGMaterialShader by calling the
    **QSGMaterial::createShader** () method, ensuring that there is only one
    instance of each shader implementation.

    In Qt 5, QSGMaterialShader was tied to OpenGL. It was built directly on
    QOpenGLShaderProgram and had functions like `updateState()` that could issue
    arbitrary OpenGL commands. This is no longer the case in Qt 6.
    QSGMaterialShader is not strictly data-oriented, meaning it provides data
    (shaders and the desired pipeline state changes) together with logic that
    updates data in a uniform buffer. Graphics API access is not provided. This
    means that a QSGMaterialShader cannot make OpenGL, Vulkan, Metal, or Direct
    3D calls on its own. Together with the unified shader management, this
    allows a QSGMaterialShader to be written once, and be functional with any of
    the supported graphics APIs at run time.

    The shaders set by calling the protected **setShaderFileName** () function
    control what material does with the vertex data from the geometry, and how
    the fragments are shaded. A QSGMaterialShader will typically set a vertex
    and a fragment shader during construction. Changing the shaders afterwards
    may not lead to the desired effect and must be avoided.

    In Qt 6, the default approach is to ship `.qsb` files with the application,
    typically embedded via the resource system, and referenced when calling
    **setShaderFileName** (). The `.qsb` files are generated offline, or at
    latest at application build time, from Vulkan-style GLSL source code using
    the `qsb` tool from the Qt Shader Tools module.

    There are three virtuals that can be overridden. These provide the data, or
    the logic to generate the data, for uniform buffers, textures, and pipeline
    state changes.

    **updateUniformData** () is the function that is most commonly reimplemented
    in subclasses. This function is expected to update the contents of a
    **QByteArray**  that will then be exposed to the shaders as a uniform
    buffer. Any QSGMaterialShader that has a uniform block in its vertex or
    fragment shader must reimplement **updateUniformData** ().

    **updateSampledImage** () is relevant when the shader code samples textures.
    The function will be invoked for each sampler (or combined image sampler, in
    APIs where relevant), giving it the option to specify which **QSGTexture**
    should be exposed to the shader.

    The shader pipeline state changes are less often used. One use case is
    materials that wish to use a specific blend mode. The relevant function is
    **updateGraphicsPipelineState** (). This function is not called unless the
    QSGMaterialShader has opted in by setting the flag
    **UpdatesGraphicsPipelineState** . The task of the function is to update the
    **GraphicsPipelineState**  struct instance that is passed to it with the
    desired changes. Currently only blending and culling-related features are
    available, other states cannot be controlled by materials.

    A minimal example, that also includes texture support, could be the
    following. Here we assume that Material is the **QSGMaterial**  that creates
    an instance of Shader in its **createShader** (), and that it holds a
    **QSGTexture**  we want to sample in the fragment shader. The vertex shader
    relies only on the modelview-projection matrix.

    class Shader : public **QSGMaterialShader**
        {
        public:
    Shader()
            {
                setShaderFileName(VertexStage,
    QLatin1String(":/materialshader.vert.qsb"));
    setShaderFileName(FragmentStage,
    QLatin1String(":/materialshader.frag.qsb"));
            }

            bool
    updateUniformData(RenderState &state, **QSGMaterial**  *, **QSGMaterial**
    *)
            {
                bool changed = false;
                **QByteArray**
    *buf = state.uniformData();
                if (state.isMatrixDirty()) {
    const QMatrix4x4 m = state.combinedMatrix();
    memcpy(buf->data(), m.constData(), 64);
                    changed = true;
    }
                return changed;
            }

            void
    updateSampledImage(RenderState &, int binding, **QSGTexture**  **texture,
    **QSGMaterial**  *newMaterial, **QSGMaterial**  *)
            {
    Material *mat = static_cast<Material *>(newMaterial);
                if
    (binding == 1)
                    *texture = mat->texture();
            }
        };

    The Vulkan-style GLSL source code for the shaders could look like the
    following. These are expected to be preprocessed offline using the `qsb`
    tool, which generates the `.qsb` files referenced in the Shader()
    constructor.

    #version 440
        layout(location = 0) in vec4 aVertex;
        layout(location =
    1) in vec2 aTexCoord;
        layout(location = 0) out vec2 vTexCoord;
    layout(std140, binding = 0) uniform buf {
            mat4 qt_Matrix;
        }
    ubuf;
        out gl_PerVertex { vec4 gl_Position; };
        void main() {
    gl_Position = ubuf.qt_Matrix * aVertex;
            vTexCoord = aTexCoord;
        }

    #version 440
        layout(location = 0) in vec2 vTexCoord;
        layout(location
    = 0) out vec4 fragColor;
        layout(binding = 1) uniform sampler2D srcTex;
    void main() {
            vec4 c = texture(srcTex, vTexCoord);
            fragColor
    = vec4(c.rgb * 0.5, 1.0);
        }

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **See also** **QSGMaterial** , **Scene Graph - Custom Material** , **Scene
    Graph - Two Texture Providers** , and **Scene Graph - Graph** .
    """

    UpdatesGraphicsPipelineState: QSGMaterialShader.Flag = ...
    VertexStage: QSGMaterialShader.Stage = ...
    FragmentStage: QSGMaterialShader.Stage = ...

    class Flag(Enum):
        UpdatesGraphicsPipelineState: QSGMaterialShader.Flag = ...

    class Flags(object):
        ...

    class RenderState(object):
        DirtyMatrix: QSGMaterialShader.RenderState.DirtyState = ...
        DirtyOpacity: QSGMaterialShader.RenderState.DirtyState = ...
        DirtyCachedMaterialData: QSGMaterialShader.RenderState.DirtyState = ...
        DirtyAll: QSGMaterialShader.RenderState.DirtyState = ...

        class DirtyState(Enum):
            DirtyMatrix: QSGMaterialShader.RenderState.DirtyState = ...
            DirtyOpacity: QSGMaterialShader.RenderState.DirtyState = ...
            DirtyCachedMaterialData: QSGMaterialShader.RenderState.DirtyState = ...
            DirtyAll: QSGMaterialShader.RenderState.DirtyState = ...

        class DirtyStates(object):
            ...

        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, RenderState: PySide6.QtQuick.QSGMaterialShader.RenderState
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def combinedMatrix(self) -> PySide6.QtGui.QMatrix4x4:
            ...

        def determinant(self) -> float:
            ...

        def devicePixelRatio(self) -> float:
            ...

        def deviceRect(self) -> PySide6.QtCore.QRect:
            ...

        def dirtyStates(
            self,
        ) -> PySide6.QtQuick.QSGMaterialShader.RenderState.DirtyStates:
            ...

        def isMatrixDirty(self) -> bool:
            ...

        def isOpacityDirty(self) -> bool:
            ...

        def modelViewMatrix(self) -> PySide6.QtGui.QMatrix4x4:
            ...

        def opacity(self) -> float:
            ...

        def projectionMatrix(self) -> PySide6.QtGui.QMatrix4x4:
            ...

        def uniformData(self) -> PySide6.QtCore.QByteArray:
            ...

        def viewportRect(self) -> PySide6.QtCore.QRect:
            ...

    class Stage(Enum):
        VertexStage: QSGMaterialShader.Stage = ...
        FragmentStage: QSGMaterialShader.Stage = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgmaterialshader.html#QSGMaterialShader

        **QSGMaterialShader::QSGMaterialShader()**

        Constructs a new QSGMaterialShader.
        """
        ...

    def flags(self) -> PySide6.QtQuick.QSGMaterialShader.Flags:
        """
        https://doc.qt.io/qt-6/qsgmaterialshader.html#flags

        **QSGMaterialShader::Flags QSGMaterialShader::flags() const**

        Returns the currently set flags for this material shader.

        **See also** **setFlags** ().
        """
        ...

    def setFlag(
        self, flags: PySide6.QtQuick.QSGMaterialShader.Flags, on: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgmaterialshader.html#setFlag

        **void QSGMaterialShader::setFlag(QSGMaterialShader::Flags flags , bool
        on = true)**

        Sets the **flags** on this material shader if **on** is true; otherwise
        clears the specified flags.
        """
        ...

    def setFlags(self, flags: PySide6.QtQuick.QSGMaterialShader.Flags) -> None:
        """
        https://doc.qt.io/qt-6/qsgmaterialshader.html#setFlags

        **void QSGMaterialShader::setFlags(QSGMaterialShader::Flags flags )**

        Sets the **flags** for this material shader.

        **See also** **flags** ().
        """
        ...

    def setShaderFileName(
        self, stage: PySide6.QtQuick.QSGMaterialShader.Stage, filename: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgmaterialshader.html#setShaderFileName

        **[protected] void
        QSGMaterialShader::setShaderFileName(QSGMaterialShader::Stage stage ,
        const QString & filename )**

        Sets the **filename** for the shader for the specified **stage**.

        The file is expected to contain a serialized QShader.
        """
        ...

    def updateUniformData(
        self,
        state: PySide6.QtQuick.QSGMaterialShader.RenderState,
        newMaterial: PySide6.QtQuick.QSGMaterial,
        oldMaterial: PySide6.QtQuick.QSGMaterial,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsgmaterialshader.html#updateUniformData

        **[virtual] bool
        QSGMaterialShader::updateUniformData(QSGMaterialShader::RenderState &
        state , QSGMaterial * newMaterial , QSGMaterial * oldMaterial )**

        This function is called by the scene graph to get the contents of the
        shader program's uniform buffer updated. The implementation is not
        expected to perform any real graphics operations, it is merely
        responsible for copying data to the **QByteArray**  returned from
        **RenderState::uniformData** (). The scene graph takes care of making
        that buffer visible in the shaders.

        The current rendering **state** is passed from the scene graph. If the
        state indicates that any relevant state is dirty, the implementation
        must update the appropriate region in the buffer data that is accessible
        via **RenderState::uniformData** (). When a state, such as, matrix or
        opacity, is not dirty, there is no need to touch the corresponding
        region since the data is persistent.

        The return value must be `true` whenever any change was made to the
        uniform data.

        The subclass specific state, such as the color of a flat color material,
        should be extracted from **newMaterial** to update the relevant regions
        in the buffer accordingly.

        **oldMaterial** can be used to minimize buffer changes (which are
        typically memcpy calls) when updating material states. When
        **oldMaterial** is null, this shader was just activated.
        """
        ...
