"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGGeometry(object):
    """
    https://doc.qt.io/qt-6/qsggeometry.html

    **Detailed Description**

    The QSGGeometry class stores the geometry of the primitives rendered with
    the scene graph. It contains vertex data and optionally index data. The mode
    used to draw the geometry, also called primitive topology, is specified with
    **setDrawingMode** ().

    Vertices can be as simple as points defined by x and y values or can be more
    complex where each vertex contains a normal, texture coordinates and a 3D
    position. The **QSGGeometry::AttributeSet**  is used to describe how the
    vertex data is built up. The attribute set can only be specified on
    construction. The QSGGeometry class provides a few convenience attributes
    and attribute sets by default. The **defaultAttributes_Point2D** () function
    returns an attribute set to be used in normal solid color rectangles, while
    the **defaultAttributes_TexturedPoint2D**  function returns attributes to be
    used for textured 2D geometry. The vertex data is internally stored as a
    `void *` and is accessible with the **vertexData** () function. Convenience
    accessors for the common attribute sets are available with
    **vertexDataAsPoint2D** () and **vertexDataAsTexturedPoint2D** (). Vertex
    data is allocated by passing a vertex count to the constructor or by calling
    **allocate** () later.

    The QSGGeometry can optionally contain indices of either unsigned 32-bit,
    unsigned 16-bit, or unsigned 8-bit integers. The index type must be
    specified during construction and cannot be changed.

    Below is a snippet illustrating how a geometry composed of position and
    color vertices can be built.

    struct MyPoint2D {
            float x;
            float y;
            float r;
    float g;
            float b;
            float a;

            void set(float x_,
    float y_, float r_, float g_, float b_, float a_) {
                x = x_;
    y = y_;
                r = r_;
                g = g_;
                b = b_;
    a = a_;
            }
        };

        **QSGGeometry** ::Attribute
    MyPoint2D_Attributes[] = {
            **QSGGeometry** ::Attribute::create(0, 2,
    FloatType, true),
            **QSGGeometry** ::Attribute::create(1, 4,
    FloatType, false)
        };

        **QSGGeometry** ::AttributeSet
    MyPoint2D_AttributeSet = {
            2,
            sizeof(MyPoint2D),
    MyPoint2D_Attributes
        };

        ...

        geometry = new
    **QSGGeometry** (MyPoint2D_AttributeSet, 2);
    geometry->setDrawingMode(DrawLines);

        MyPoint2D *vertices =
    static_cast<MyPoint2D *>(geometry->vertexData());
        vertices[0].set(0, 0,
    1, 0, 0, 1);
        vertices[1].set(width(), height(), 0, 0, 1, 1);

    The QSGGeometry is a software buffer and client-side in terms of accelerated
    rendering, as the buffers used in 2D graphics typically consist of many
    small buffers that change every frame and do not benefit from being uploaded
    to graphics memory. However, the QSGGeometry supports hinting to the
    renderer that a buffer should be uploaded using the **setVertexDataPattern**
    () and **setIndexDataPattern** () functions. Whether this hint is respected
    or not is implementation specific.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **See also** **QSGGeometryNode**  and **Scene Graph - Custom Geometry** .
    """

    UnknownAttribute: QSGGeometry.AttributeType = ...
    PositionAttribute: QSGGeometry.AttributeType = ...
    ColorAttribute: QSGGeometry.AttributeType = ...
    TexCoordAttribute: QSGGeometry.AttributeType = ...
    TexCoord1Attribute: QSGGeometry.AttributeType = ...
    TexCoord2Attribute: QSGGeometry.AttributeType = ...
    AlwaysUploadPattern: QSGGeometry.DataPattern = ...
    StreamPattern: QSGGeometry.DataPattern = ...
    DynamicPattern: QSGGeometry.DataPattern = ...
    StaticPattern: QSGGeometry.DataPattern = ...
    DrawPoints: QSGGeometry.DrawingMode = ...
    DrawLines: QSGGeometry.DrawingMode = ...
    DrawLineLoop: QSGGeometry.DrawingMode = ...
    DrawLineStrip: QSGGeometry.DrawingMode = ...
    DrawTriangles: QSGGeometry.DrawingMode = ...
    DrawTriangleStrip: QSGGeometry.DrawingMode = ...
    DrawTriangleFan: QSGGeometry.DrawingMode = ...
    ByteType: QSGGeometry.Type = ...
    UnsignedByteType: QSGGeometry.Type = ...
    ShortType: QSGGeometry.Type = ...
    UnsignedShortType: QSGGeometry.Type = ...
    IntType: QSGGeometry.Type = ...
    UnsignedIntType: QSGGeometry.Type = ...
    FloatType: QSGGeometry.Type = ...
    Bytes2Type: QSGGeometry.Type = ...
    Bytes3Type: QSGGeometry.Type = ...
    Bytes4Type: QSGGeometry.Type = ...
    DoubleType: QSGGeometry.Type = ...

    class Attribute(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, Attribute: PySide6.QtQuick.QSGGeometry.Attribute) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        @staticmethod
        def create(
            pos: int, tupleSize: int, primitiveType: int, isPosition: bool = ...
        ) -> PySide6.QtQuick.QSGGeometry.Attribute:
            ...

        @staticmethod
        def createWithAttributeType(
            pos: int,
            tupleSize: int,
            primitiveType: int,
            attributeType: PySide6.QtQuick.QSGGeometry.AttributeType,
        ) -> PySide6.QtQuick.QSGGeometry.Attribute:
            ...

    class AttributeSet(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, AttributeSet: PySide6.QtQuick.QSGGeometry.AttributeSet
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class AttributeType(Enum):
        UnknownAttribute: QSGGeometry.AttributeType = ...
        PositionAttribute: QSGGeometry.AttributeType = ...
        ColorAttribute: QSGGeometry.AttributeType = ...
        TexCoordAttribute: QSGGeometry.AttributeType = ...
        TexCoord1Attribute: QSGGeometry.AttributeType = ...
        TexCoord2Attribute: QSGGeometry.AttributeType = ...

    class ColoredPoint2D(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, ColoredPoint2D: PySide6.QtQuick.QSGGeometry.ColoredPoint2D
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def set(self, nx: float, ny: float, nr: int, ng: int, nb: int, na: int) -> None:
            ...

    class DataPattern(Enum):
        AlwaysUploadPattern: QSGGeometry.DataPattern = ...
        StreamPattern: QSGGeometry.DataPattern = ...
        DynamicPattern: QSGGeometry.DataPattern = ...
        StaticPattern: QSGGeometry.DataPattern = ...

    class DrawingMode(Enum):
        DrawPoints: QSGGeometry.DrawingMode = ...
        DrawLines: QSGGeometry.DrawingMode = ...
        DrawLineLoop: QSGGeometry.DrawingMode = ...
        DrawLineStrip: QSGGeometry.DrawingMode = ...
        DrawTriangles: QSGGeometry.DrawingMode = ...
        DrawTriangleStrip: QSGGeometry.DrawingMode = ...
        DrawTriangleFan: QSGGeometry.DrawingMode = ...

    class Point2D(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(self, Point2D: PySide6.QtQuick.QSGGeometry.Point2D) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def set(self, nx: float, ny: float) -> None:
            ...

    class TexturedPoint2D(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, TexturedPoint2D: PySide6.QtQuick.QSGGeometry.TexturedPoint2D
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def set(self, nx: float, ny: float, ntx: float, nty: float) -> None:
            ...

    class Type(Enum):
        ByteType: QSGGeometry.Type = ...
        UnsignedByteType: QSGGeometry.Type = ...
        ShortType: QSGGeometry.Type = ...
        UnsignedShortType: QSGGeometry.Type = ...
        IntType: QSGGeometry.Type = ...
        UnsignedIntType: QSGGeometry.Type = ...
        FloatType: QSGGeometry.Type = ...
        Bytes2Type: QSGGeometry.Type = ...
        Bytes3Type: QSGGeometry.Type = ...
        Bytes4Type: QSGGeometry.Type = ...
        DoubleType: QSGGeometry.Type = ...

    def __init__(
        self,
        attribs: PySide6.QtQuick.QSGGeometry.AttributeSet,
        vertexCount: int,
        indexCount: int = ...,
        indexType: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#QSGGeometry

        **QSGGeometry::QSGGeometry(const QSGGeometry::AttributeSet & attributes
        , int vertexCount , int indexCount = 0, int indexType =
        UnsignedShortType)**

        Constructs a geometry object based on **attributes**.

        The object allocate space for **vertexCount** vertices based on the
        accumulated size in **attributes** and for **indexCount**.

        The **indexType** can be **UnsignedShortType**  or `UnsignedIntType`.
        Support for the latter depends on the graphics API implementation used
        at run time, and may not always be available.

        Geometry objects are constructed by default with **DrawTriangleStrip**
        as the drawing mode.

        The attribute structure is assumed to be POD and the geometry object
        assumes this will not go away. There is no memory management involved.
        """
        ...

    def allocate(self, vertexCount: int, indexCount: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#allocate

        **void QSGGeometry::allocate(int vertexCount , int indexCount = 0)**

        Resizes the vertex and index data of this geometry object to fit
        **vertexCount** vertices and **indexCount** indices.

        Vertex and index data will be invalidated after this call and the caller
        must mark the associated geometry node as dirty, by calling
        node->markDirty(**QSGNode::DirtyGeometry** ) to ensure that the renderer
        has a chance to update internal buffers.
        """
        ...

    def attributeCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#attributeCount

        **int QSGGeometry::attributeCount() const**

        Returns the number of attributes in the attrbute set used by this
        geometry.
        """
        ...

    def attributes(self) -> PySide6.QtQuick.QSGGeometry.Attribute:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#attributes

        **const QSGGeometry::Attribute *QSGGeometry::attributes() const**

        Returns an array with the attributes of this geometry. The size of the
        array is given with **attributeCount** ().
        """
        ...

    @staticmethod
    def defaultAttributes_ColoredPoint2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#defaultAttributes_ColoredPoint2D

        **[static] const QSGGeometry::AttributeSet
        &QSGGeometry::defaultAttributes_ColoredPoint2D()**

        Convenience function which returns attributes to be used for per vertex
        colored 2D drawing.
        """
        ...

    @staticmethod
    def defaultAttributes_Point2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#defaultAttributes_Point2D

        **[static] const QSGGeometry::AttributeSet
        &QSGGeometry::defaultAttributes_Point2D()**

        Convenience function which returns attributes to be used for 2D solid
        color drawing.
        """
        ...

    @staticmethod
    def defaultAttributes_TexturedPoint2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#defaultAttributes_TexturedPoint2
        D

        **[static] const QSGGeometry::AttributeSet
        &QSGGeometry::defaultAttributes_TexturedPoint2D()**

        Convenience function which returns attributes to be used for textured 2D
        drawing.
        """
        ...

    def drawingMode(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#drawingMode

        **unsigned int QSGGeometry::drawingMode() const**

        Returns the drawing mode of this geometry.

        The default value is **DrawTriangleStrip** .

        **See also** **setDrawingMode** ().
        """
        ...

    def indexCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#indexCount

        **int QSGGeometry::indexCount() const**

        Returns the number of indices in this geometry object.
        """
        ...

    def indexData(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#indexData

        **void *QSGGeometry::indexData()**

        Returns a pointer to the raw index data of this geometry object.

        **See also** **indexDataAsUShort** () and **indexDataAsUInt** ().
        """
        ...

    def indexDataAsUInt(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#indexDataAsUInt

        **uint *QSGGeometry::indexDataAsUInt()**

        Convenience function to access the index data as a mutable array of
        32-bit unsigned integers.
        """
        ...

    def indexDataAsUShort(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#indexDataAsUShort

        **quint16 *QSGGeometry::indexDataAsUShort()**

        Convenience function to access the index data as a mutable array of
        16-bit unsigned integers.
        """
        ...

    def indexDataPattern(self) -> PySide6.QtQuick.QSGGeometry.DataPattern:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#indexDataPattern

        **QSGGeometry::DataPattern QSGGeometry::indexDataPattern() const**

        Returns the usage pattern for indices in this geometry. The default
        pattern is **AlwaysUploadPattern** .

        **See also** **setIndexDataPattern** ().
        """
        ...

    def indexType(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#indexType

        **int QSGGeometry::indexType() const**

        Returns the primitive type used for indices in this geometry object.
        """
        ...

    def lineWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#lineWidth

        **float QSGGeometry::lineWidth() const**

        Gets the current line or point width or to be used for this geometry.
        This property only applies to line width when the **drawingMode**  is
        **DrawLines** , DarwLineStrip, or **DrawLineLoop** . When supported, it
        also applies to point size when the **drawingMode**  is **DrawPoints** .

        The default value is `1.0`

        **Note:** Support for point and line drawing may be limited at run time,
        depending on the platform and graphics API. For example, some APIs do
        not support point sprites and so setting a size other than 1 is not
        possible.

        **Note:** The width of `1.0` is always supported.

        **See also** **setLineWidth** () and **drawingMode** ().
        """
        ...

    def markIndexDataDirty(self) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#markIndexDataDirty

        **void QSGGeometry::markIndexDataDirty()**

        Mark that the vertices in this geometry has changed and must be uploaded
        again.

        This function only has an effect when the usage pattern for vertices is
        StaticData and the renderer that renders this geometry uploads the
        geometry into Vertex Buffer Objects (VBOs).
        """
        ...

    def markVertexDataDirty(self) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#markVertexDataDirty

        **void QSGGeometry::markVertexDataDirty()**

        Mark that the vertices in this geometry has changed and must be uploaded
        again.

        This function only has an effect when the usage pattern for vertices is
        StaticData and the renderer that renders this geometry uploads the
        geometry into Vertex Buffer Objects (VBOs).
        """
        ...

    def setDrawingMode(self, mode: int) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#setDrawingMode

        **void QSGGeometry::setDrawingMode(unsigned int mode )**

        Sets the **mode** to be used for drawing this geometry.

        The default value is **QSGGeometry::DrawTriangleStrip** .

        **See also** **drawingMode** () and **DrawingMode** .
        """
        ...

    def setIndexDataPattern(self, p: PySide6.QtQuick.QSGGeometry.DataPattern) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#setIndexDataPattern

        **void QSGGeometry::setIndexDataPattern(QSGGeometry::DataPattern p )**

        Sets the usage pattern for indices to **p**.

        The default is **AlwaysUploadPattern** . When set to anything other than
        the default, the user must call **markIndexDataDirty** () after changing
        the index data, in addition to calling **QSGNode::markDirty** () with
        **QSGNode::DirtyGeometry** .

        **See also** **indexDataPattern** ().
        """
        ...

    def setLineWidth(self, w: float) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#setLineWidth

        **void QSGGeometry::setLineWidth(float width )**

        Sets the line or point width to be used for this geometry to **width**.
        This property only applies to line width when the **drawingMode**  is
        **DrawLines** , **DrawLineStrip** , or **DrawLineLoop** . When
        supported, it also applies to point size when the **drawingMode**  is
        **DrawPoints** .

        **Note:** Support for point and line drawing may be limited at run time,
        depending on the platform and graphics API. For example, some APIs do
        not support point sprites and so setting a size other than 1 is not
        possible.

        **Note:** The width of `1.0` is always supported.

        **See also** **lineWidth** () and **drawingMode** ().
        """
        ...

    def setVertexDataPattern(self, p: PySide6.QtQuick.QSGGeometry.DataPattern) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#setVertexDataPattern

        **void QSGGeometry::setVertexDataPattern(QSGGeometry::DataPattern p )**

        Sets the usage pattern for vertices to **p**.

        The default is **AlwaysUploadPattern** . When set to anything other than
        the default, the user must call **markVertexDataDirty** () after
        changing the vertex data, in addition to calling **QSGNode::markDirty**
        () with **QSGNode::DirtyGeometry** .

        **See also** **vertexDataPattern** ().
        """
        ...

    def sizeOfIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#sizeOfIndex

        **int QSGGeometry::sizeOfIndex() const**

        Returns the byte size of the index type.

        This value is either `2` when the index type is **UnsignedShortType** ,
        or `4` when the index type is **UnsignedIntType** .
        """
        ...

    def sizeOfVertex(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#sizeOfVertex

        **int QSGGeometry::sizeOfVertex() const**

        Returns the size in bytes of one vertex.

        This value comes from the attributes.
        """
        ...

    @staticmethod
    def updateColoredRectGeometry(
        g: PySide6.QtQuick.QSGGeometry,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#updateColoredRectGeometry

        **[static] void QSGGeometry::updateColoredRectGeometry(QSGGeometry * g ,
        const QRectF & rect )**

        Updates the geometry **g** with the coordinates in **rect**.

        The function assumes the geometry object contains a single triangle
        strip of **QSGGeometry::ColoredPoint2D**  vertices
        """
        ...

    @staticmethod
    def updateRectGeometry(
        g: PySide6.QtQuick.QSGGeometry,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#updateRectGeometry

        **[static] void QSGGeometry::updateRectGeometry(QSGGeometry * g , const
        QRectF & rect )**

        Updates the geometry **g** with the coordinates in **rect**.

        The function assumes the geometry object contains a single triangle
        strip of **QSGGeometry::Point2D**  vertices
        """
        ...

    @staticmethod
    def updateTexturedRectGeometry(
        g: PySide6.QtQuick.QSGGeometry,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
        sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#updateTexturedRectGeometry

        **[static] void QSGGeometry::updateTexturedRectGeometry(QSGGeometry * g
        , const QRectF & rect , const QRectF & textureRect )**

        Updates the geometry **g** with the coordinates in **rect** and texture
        coordinates from **textureRect**.

        **textureRect** should be in normalized coordinates.

        **g** is assumed to be a triangle strip of four vertices of type
        **QSGGeometry::TexturedPoint2D** .
        """
        ...

    def vertexCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#vertexCount

        **int QSGGeometry::vertexCount() const**

        Returns the number of vertices in this geometry object.
        """
        ...

    def vertexData(self) -> int:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#vertexData

        **void *QSGGeometry::vertexData()**

        Returns a pointer to the raw vertex data of this geometry object.

        **See also** **vertexDataAsPoint2D** () and
        **vertexDataAsTexturedPoint2D** ().
        """
        ...

    def vertexDataAsColoredPoint2D(self) -> PySide6.QtQuick.QSGGeometry.ColoredPoint2D:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#vertexDataAsColoredPoint2D

        **QSGGeometry::ColoredPoint2D
        *QSGGeometry::vertexDataAsColoredPoint2D()**

        Convenience function to access the vertex data as a mutable array of
        **QSGGeometry::ColoredPoint2D** .
        """
        ...

    def vertexDataAsPoint2D(self) -> PySide6.QtQuick.QSGGeometry.Point2D:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#vertexDataAsPoint2D

        **QSGGeometry::Point2D *QSGGeometry::vertexDataAsPoint2D()**

        Convenience function to access the vertex data as a mutable array of
        **QSGGeometry::Point2D** .
        """
        ...

    def vertexDataAsTexturedPoint2D(
        self,
    ) -> PySide6.QtQuick.QSGGeometry.TexturedPoint2D:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#vertexDataAsTexturedPoint2D

        **QSGGeometry::TexturedPoint2D
        *QSGGeometry::vertexDataAsTexturedPoint2D()**

        Convenience function to access the vertex data as a mutable array of
        **QSGGeometry::TexturedPoint2D** .
        """
        ...

    def vertexDataPattern(self) -> PySide6.QtQuick.QSGGeometry.DataPattern:
        """
        https://doc.qt.io/qt-6/qsggeometry.html#vertexDataPattern

        **QSGGeometry::DataPattern QSGGeometry::vertexDataPattern() const**

        Returns the usage pattern for vertices in this geometry. The default
        pattern is **AlwaysUploadPattern** .

        **See also** **setVertexDataPattern** ().
        """
        ...
