"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from typing import Any, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGFlatColorMaterial(PySide6.QtQuick.QSGMaterial):
    """
    https://doc.qt.io/qt-6/qsgflatcolormaterial.html

    **Detailed Description**

    **Warning:** This utility class is only functional when running with the
    default backend of the Qt Quick scenegraph.

    The flat color material will fill every pixel in a geometry using a solid
    color. The color can contain transparency.

    The geometry to be rendered with a flat color material requires vertices in
    attribute location 0 in the **QSGGeometry**  object to render correctly. The
    **QSGGeometry::defaultAttributes_Point2D** () returns an attribute set
    compatible with this material.

    The flat color material respects both current opacity and current matrix
    when updating its rendering state.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgflatcolormaterial.html#QSGFlatColorMaterial

        **QSGFlatColorMaterial::QSGFlatColorMaterial()**

        Constructs a new flat color material.

        The default color is white.
        """
        ...

    def color(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qsgflatcolormaterial.html#color

        **const QColor &QSGFlatColorMaterial::color() const**

        Returns this flat color material's color.

        The default color is white.

        **See also** **setColor** ().
        """
        ...

    def compare(self, other: PySide6.QtQuick.QSGMaterial) -> int:
        ...

    def createShader(
        self, renderMode: PySide6.QtQuick.QSGRendererInterface.RenderMode
    ) -> PySide6.QtQuick.QSGMaterialShader:
        ...

    def setColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgflatcolormaterial.html#setColor

        **void QSGFlatColorMaterial::setColor(const QColor & color )**

        Sets this flat color material's color to **color**.

        **See also** **color** ().
        """
        ...

    def type(self) -> PySide6.QtQuick.QSGMaterialType:
        ...
