"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGBasicGeometryNode(PySide6.QtQuick.QSGNode):
    """
    https://doc.qt.io/qt-6/qsgbasicgeometrynode.html

    **Detailed Description**

    The QSGBasicGeometryNode class should not be used by itself. It is only
    encapsulates shared functionality between the **QSGGeometryNode**  and
    **QSGClipNode**  classes.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    def __init__(self, type: PySide6.QtQuick.QSGNode.NodeType) -> None:
        ...

    def clipList(self) -> PySide6.QtQuick.QSGClipNode:
        ...

    def geometry(self) -> PySide6.QtQuick.QSGGeometry:
        """
        https://doc.qt.io/qt-6/qsgbasicgeometrynode.html#geometry

        **const QSGGeometry *QSGBasicGeometryNode::geometry() const**

        Returns this node's geometry.

        The geometry is null by default.

        **See also** **setGeometry** ().
        """
        ...

    def matrix(self) -> PySide6.QtGui.QMatrix4x4:
        ...

    def setGeometry(self, geometry: PySide6.QtQuick.QSGGeometry) -> None:
        """
        https://doc.qt.io/qt-6/qsgbasicgeometrynode.html#setGeometry

        **void QSGBasicGeometryNode::setGeometry(QSGGeometry * geometry )**

        Sets the geometry of this node to **geometry**.

        If the node has the flag **QSGNode::OwnsGeometry**  set, it will also
        delete the geometry object it is pointing to. This flag is not set by
        default.

        If the geometry is changed without calling setGeometry() again, the user
        must also mark the geometry as dirty using **QSGNode::markDirty** ().

        **See also** **geometry** () and **markDirty** ().
        """
        ...

    def setRendererClipList(self, c: PySide6.QtQuick.QSGClipNode) -> None:
        ...

    def setRendererMatrix(
        self, m: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]
    ) -> None:
        ...
