"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QQuickTextureFactory(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qquicktexturefactory.html

    **Detailed Description**

    The purpose of the texture factory is to provide a placeholder for a image
    data that can be converted into an OpenGL texture.

    Creating a texture directly is not possible as there is rarely an OpenGL
    context available in the thread that is responsible for loading the image
    data.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qquicktexturefactory.html#QQuickTextureFactory

        **QQuickTextureFactory::QQuickTextureFactory()**

        Constructs a texture factory. Since QQuickTextureFactory is abstract, it
        cannot be instantiated directly.
        """
        ...

    def createTexture(
        self, window: PySide6.QtQuick.QQuickWindow
    ) -> PySide6.QtQuick.QSGTexture:
        """
        https://doc.qt.io/qt-6/qquicktexturefactory.html#createTexture

        **[pure virtual] QSGTexture
        *QQuickTextureFactory::createTexture(QQuickWindow * window ) const**

        This function is called on the scene graph rendering thread to create a
        **QSGTexture**  instance from the factory. **window** provides the
        context which this texture is created in.

        QML will internally cache the returned texture as needed. Each call to
        this function should return a unique instance.

        The OpenGL context used for rendering is bound when this function is
        called.
        """
        ...

    def image(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qquicktexturefactory.html#image

        **[virtual] QImage QQuickTextureFactory::image() const**

        Returns an image version of this texture.

        The lifespan of the returned image is unknown, so the implementation
        should return a self contained **QImage** , not make use of the
        **QImage** (uchar *, ...) constructor.

        This function is not commonly used and is expected to be slow.
        """
        ...

    def textureByteCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qquicktexturefactory.html#textureByteCount

        **[pure virtual] int QQuickTextureFactory::textureByteCount() const**

        Returns the number of bytes of memory the texture consumes.
        """
        ...

    @staticmethod
    def textureFactoryForImage(
        image: Union[PySide6.QtGui.QImage, str]
    ) -> PySide6.QtQuick.QQuickTextureFactory:
        """
        https://doc.qt.io/qt-6/qquicktexturefactory.html#textureFactoryForImage

        **[static, since 5.6] QQuickTextureFactory
        *QQuickTextureFactory::textureFactoryForImage(const QImage & image )**

        Returns a **QQuickTextureFactory**  holding the given **image**.

        This is typically used as a helper in
        **QQuickImageResponse::textureFactory** .

        This function was introduced in Qt 5.6.
        """
        ...

    def textureSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qquicktexturefactory.html#textureSize

        **[pure virtual] QSize QQuickTextureFactory::textureSize() const**

        Returns the size of the texture. This function will be called from
        arbitrary threads and should not rely on an OpenGL context bound.
        """
        ...
