"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QQuickRenderTarget(object):
    """
    https://doc.qt.io/qt-6/qquickrendertarget.html

    **Detailed Description**

    **See also** **QQuickWindow::setRenderTarget** () and
    **QQuickGraphicsDevice** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendertarget.html#QQuickRenderTarget

        **QQuickRenderTarget::QQuickRenderTarget()**

        Constructs a default QQuickRenderTarget that does not reference any
        native objects.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtQuick.QQuickRenderTarget) -> None:
        """
        https://doc.qt.io/qt-6/qquickrendertarget.html#QQuickRenderTarget

        **QQuickRenderTarget::QQuickRenderTarget()**

        Constructs a default QQuickRenderTarget that does not reference any
        native objects.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def fromD3D11Texture(
        texture: int, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ...
    ) -> PySide6.QtQuick.QQuickRenderTarget:
        """
        https://doc.qt.io/qt-6/qquickrendertarget.html#fromD3D11Texture

        **[static] QQuickRenderTarget QQuickRenderTarget::fromD3D11Texture(void
        * texture , const QSize & pixelSize , int sampleCount = 1)**

        Returns a new **QQuickRenderTarget**  referencing an D3D11 texture
        object specified by **texture**.

        **pixelSize** specifies the size of the image, in pixels. Currently only
        2D textures are supported.

        **sampleCount** specific the number of samples. 0 or 1 means no
        multisampling, while a value like 4 or 8 states that the native object
        is a multisample texture.

        **Note:** the resulting **QQuickRenderTarget**  does not own any native
        resources, it merely contains references and the associated metadata of
        the size and sample count. It is the caller's responsibility to ensure
        that the native resource exists as long as necessary.

        **See also** **QQuickWindow::setRenderTarget** () and
        **QQuickRenderControl** .
        """
        ...

    @staticmethod
    def fromOpenGLRenderBuffer(
        renderbufferId: int, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ...
    ) -> PySide6.QtQuick.QQuickRenderTarget:
        """
        https://doc.qt.io/qt-6/qquickrendertarget.html#fromOpenGLRenderBuffer

        **[static, since 6.2] QQuickRenderTarget
        QQuickRenderTarget::fromOpenGLRenderBuffer(uint renderbufferId , const
        QSize & pixelSize , int sampleCount = 1)**

        Returns a new **QQuickRenderTarget**  referencing an OpenGL renderbuffer
        object specified by **renderbufferId**.

        The renderbuffer will be used as the color attachment for the internal
        framebuffer object. This function is provided to allow targeting
        renderbuffers that are created by the application with some external
        buffer underneath, such as an EGLImageKHR. Once the application has
        called **glEGLImageTargetRenderbufferStorageOES** , the renderbuffer can
        be passed to this function.

        **pixelSize** specifies the size of the image, in pixels.

        **sampleCount** specific the number of samples. 0 or 1 means no
        multisampling, while a value like 4 or 8 states that the native object
        is a multisample renderbuffer.

        **Note:** the resulting **QQuickRenderTarget**  does not own any native
        resources, it merely contains references and the associated metadata of
        the size and sample count. It is the caller's responsibility to ensure
        that the native resource exists as long as necessary.

        This function was introduced in Qt 6.2.

        **See also** **QQuickWindow::setRenderTarget** () and
        **QQuickRenderControl** .
        """
        ...

    @staticmethod
    def fromOpenGLTexture(
        textureId: int, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ...
    ) -> PySide6.QtQuick.QQuickRenderTarget:
        """
        https://doc.qt.io/qt-6/qquickrendertarget.html#fromOpenGLTexture

        **[static] QQuickRenderTarget QQuickRenderTarget::fromOpenGLTexture(uint
        textureId , const QSize & pixelSize , int sampleCount = 1)**

        Returns a new **QQuickRenderTarget**  referencing an OpenGL texture
        object specified by **textureId**.

        **pixelSize** specifies the size of the image, in pixels. Currently only
        2D textures are supported.

        **sampleCount** specific the number of samples. 0 or 1 means no
        multisampling, while a value like 4 or 8 states that the native object
        is a multisample texture.

        **Note:** the resulting **QQuickRenderTarget**  does not own any native
        resources, it merely contains references and the associated metadata of
        the size and sample count. It is the caller's responsibility to ensure
        that the native resource exists as long as necessary.

        **See also** **QQuickWindow::setRenderTarget** () and
        **QQuickRenderControl** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquickrendertarget.html#isNull

        **bool QQuickRenderTarget::isNull() const**

        Returns true if this **QQuickRenderTarget**  is default constructed,
        referencing no native objects.
        """
        ...
