"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QQuickGraphicsDevice(object):
    """
    https://doc.qt.io/qt-6/qquickgraphicsdevice.html

    **Detailed Description**

    **See also** **QQuickWindow::setGraphicsDevice** () and
    **QQuickRenderTarget** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qquickgraphicsdevice.html#QQuickGraphicsDevice

        **QQuickGraphicsDevice::QQuickGraphicsDevice()**

        Constructs a default QQuickGraphicsDevice that does not reference any
        native objects.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtQuick.QQuickGraphicsDevice) -> None:
        """
        https://doc.qt.io/qt-6/qquickgraphicsdevice.html#QQuickGraphicsDevice

        **QQuickGraphicsDevice::QQuickGraphicsDevice()**

        Constructs a default QQuickGraphicsDevice that does not reference any
        native objects.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def fromAdapter(
        adapterLuidLow: int, adapterLuidHigh: int, featureLevel: int = ...
    ) -> PySide6.QtQuick.QQuickGraphicsDevice:
        """
        https://doc.qt.io/qt-6/qquickgraphicsdevice.html#fromAdapter

        **[static] QQuickGraphicsDevice
        QQuickGraphicsDevice::fromAdapter(quint32 adapterLuidLow , qint32
        adapterLuidHigh , int featureLevel = 0)**

        Returns a new **QQuickGraphicsDevice**  describing a DXGI adapter and
        D3D feature level.

        This factory function is suitable for Direct3D 11, particularly in
        combination with OpenXR. **adapterLuidLow** and **adapterLuidHigh**
        together specify a LUID, while a featureLevel specifies a
        `D3D_FEATURE_LEVEL_` value. **featureLevel** can be set to 0 if it is
        not intended to be specified, in which case the scene graph's defaults
        will be used.
        """
        ...

    @staticmethod
    def fromDeviceAndContext(
        device: int, context: int
    ) -> PySide6.QtQuick.QQuickGraphicsDevice:
        """
        https://doc.qt.io/qt-6/qquickgraphicsdevice.html#fromDeviceAndContext

        **[static] QQuickGraphicsDevice
        QQuickGraphicsDevice::fromDeviceAndContext(void * device , void *
        context )**

        Returns a new **QQuickGraphicsDevice**  referencing a native device and
        context object.

        This factory function is suitable for Direct3D 11. **device** is
        expected to be a `ID3D11Device*`, **context** is expected to be a
        `ID3D11DeviceContext*`.

        **Note:** the resulting **QQuickGraphicsDevice**  does not own any
        native resources, it merely contains references. It is the caller's
        responsibility to ensure that the native resource exists as long as
        necessary.
        """
        ...

    @staticmethod
    def fromOpenGLContext(
        context: PySide6.QtGui.QOpenGLContext,
    ) -> PySide6.QtQuick.QQuickGraphicsDevice:
        """
        https://doc.qt.io/qt-6/qquickgraphicsdevice.html#fromOpenGLContext

        **[static] QQuickGraphicsDevice
        QQuickGraphicsDevice::fromOpenGLContext(QOpenGLContext * context )**

        Returns a new **QQuickGraphicsDevice**  referencing an existing OpenGL
        **context**.

        This factory function is suitable for OpenGL.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquickgraphicsdevice.html#isNull

        **bool QQuickGraphicsDevice::isNull() const**

        Returns true if this is a default constructed graphics device that does
        not reference any native objects.
        """
        ...
