"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQml, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtQml

bytes = str


class QQmlListReference(object):
    """
    https://doc.qt.io/qt-6/qqmllistreference.html

    **Detailed Description**

    QQmlListReference allows C++ programs to read from, and assign values to a
    QML list property in a simple and type-safe way. A QQmlListReference can be
    created by passing an object and property name or through a **QQmlProperty**
    instance. These two are equivalent:

    **QQmlListReference**  ref1(object, "children");

        **QQmlProperty**
    ref2(object, "children");
        **QQmlListReference**  ref2 =
    qvariant_cast<**QQmlListReference** >(ref2.read());

    Not all QML list properties support all operations. A set of methods,
    **canAppend** (), **canAt** (), **canClear** () and **canCount** () allow
    programs to query whether an operation is supported on a given property.

    QML list properties are type-safe. Only **QObject** 's that derive from the
    correct base class can be assigned to the list. The **listElementType** ()
    method can be used to query the **QMetaObject**  of the **QObject**  type
    supported. Attempting to add objects of the incorrect type to a list
    property will fail.

    Like with normal lists, when accessing a list element by index, it is the
    callers responsibility to ensure that it does not request an out of range
    element using the **count** () method before calling **at** ().
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference

        **QQmlListReference::QQmlListReference()**

        Constructs an invalid instance.
        """
        ...

    @overload
    def __init__(
        self,
        arg__1: PySide6.QtCore.QObject,
        property: bytes,
        arg__3: Optional[PySide6.QtQml.QQmlEngine] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference-1

        **[since 6.1] QQmlListReference::QQmlListReference(const QVariant &
        variant , QQmlEngine * engine = nullptr)**

        Constructs a QQmlListReference from a **QVariant**  **variant**
        containing a **QQmlListProperty** . If **variant** does not contain a
        list property, an invalid QQmlListReference is created. If the object
        owning the list property is destroyed after the reference is
        constructed, it will automatically become invalid. That is, it is safe
        to hold QQmlListReference instances even after the object is deleted.

        The **engine** is required to look up the element type, which may be a
        dynamically created QML type. If it's omitted, only pre-registered types
        are available. The element type is needed when inserting values into the
        list and when the value meta type is explicitly retrieved.

        This function was introduced in Qt 6.1.
        """
        ...

    @overload
    def __init__(self, arg__1: Union[PySide6.QtQml.QQmlListReference, Any]) -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference-2

        **QQmlListReference::QQmlListReference(QObject * object , const char *
        property , QQmlEngine * engine = nullptr)**

        Constructs a QQmlListReference for **object** 's **property**. If
        **property** is not a list property, an invalid QQmlListReference is
        created. If **object** is destroyed after the reference is constructed,
        it will automatically become invalid. That is, it is safe to hold
        QQmlListReference instances even after **object** is deleted.

        The **engine** is required to look up the element type, which may be a
        dynamically created QML type. If it's omitted, only pre-registered types
        are available. The element type is needed when inserting values into the
        list and when the value meta type is explicitly retrieved.
        """
        ...

    @overload
    def __init__(
        self, variant: Any, engine: Optional[PySide6.QtQml.QQmlEngine] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#QQmlListReference

        **QQmlListReference::QQmlListReference()**

        Constructs an invalid instance.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def append(self, arg__1: PySide6.QtCore.QObject) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#append

        **bool QQmlListReference::append(QObject * object ) const**

        Appends **object** to the list. Returns true if the operation succeeded,
        otherwise false.

        **See also** **canAppend** ().
        """
        ...

    def at(self, arg__1: int) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#at

        **QObject *QQmlListReference::at(qsizetype index ) const**

        Returns the list element at **index** , or 0 if the operation failed.

        **See also** **canAt** ().
        """
        ...

    def canAppend(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canAppend

        **bool QQmlListReference::canAppend() const**

        Returns true if the list property can be appended to, otherwise false.
        Returns false if the reference is invalid.

        **See also** **append** ().
        """
        ...

    def canAt(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canAt

        **bool QQmlListReference::canAt() const**

        Returns true if the list property can queried by index, otherwise false.
        Returns false if the reference is invalid.

        **See also** **at** ().
        """
        ...

    def canClear(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canClear

        **bool QQmlListReference::canClear() const**

        Returns true if the list property can be cleared, otherwise false.
        Returns false if the reference is invalid.

        **See also** **clear** ().
        """
        ...

    def canCount(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canCount

        **bool QQmlListReference::canCount() const**

        Returns true if the list property can be queried for its element count,
        otherwise false. Returns false if the reference is invalid.

        **See also** **count** ().
        """
        ...

    def canRemoveLast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canRemoveLast

        **bool QQmlListReference::canRemoveLast() const**

        Returns true if the last item can be removed from the list property,
        otherwise false. Returns false if the reference is invalid.

        **See also** **removeLast** ().
        """
        ...

    def canReplace(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#canReplace

        **bool QQmlListReference::canReplace() const**

        Returns true if items in the list property can be replaced, otherwise
        false. Returns false if the reference is invalid.

        **See also** **replace** ().
        """
        ...

    def clear(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#clear

        **bool QQmlListReference::clear() const**

        Clears the list. Returns true if the operation succeeded, otherwise
        false.

        **See also** **canClear** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#count

        **qsizetype QQmlListReference::count() const**

        Returns the number of objects in the list, or 0 if the operation failed.
        """
        ...

    def isManipulable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#isManipulable

        **bool QQmlListReference::isManipulable() const**

        Return true if **at** (), **count** (), **append** (), and either
        **clear** () or **removeLast** () are implemented, so you can manipulate
        the list.

        Mind that **replace** () and **removeLast** () can be emulated by
        stashing all items and rebuilding the list using **clear** () and
        **append** (). Therefore, they are not required for the list to be
        manipulable. Furthermore, **clear** () can be emulated using
        **removeLast** ().

        **See also** **isReadable** (), **at** (), **count** (), **append** (),
        **clear** (), **replace** (), and **removeLast** ().
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#isReadable

        **bool QQmlListReference::isReadable() const**

        Return true if **at** () and **count** () are implemented, so you can
        access the elements.

        **See also** **isManipulable** (), **at** (), and **count** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#isValid

        **bool QQmlListReference::isValid() const**

        Returns true if the instance refers to a valid list property, otherwise
        false.
        """
        ...

    def listElementType(self) -> PySide6.QtCore.QMetaObject:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#listElementType

        **const QMetaObject *QQmlListReference::listElementType() const**

        Returns the **QMetaObject**  for the elements stored in the list
        property, or `nullptr` if the reference is invalid.

        The **QMetaObject**  can be used ahead of time to determine whether a
        given instance can be added to a list. If you didn't pass an engine on
        construction this may return nullptr.
        """
        ...

    def object(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#object

        **QObject *QQmlListReference::object() const**

        Returns the list property's object. Returns `nullptr` if the reference
        is invalid.
        """
        ...

    def removeLast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#removeLast

        **bool QQmlListReference::removeLast() const**

        Removes the last item in the list. Returns true if the operation
        succeeded, otherwise false.

        **See also** **canRemoveLast** ().
        """
        ...

    def replace(self, arg__1: int, arg__2: PySide6.QtCore.QObject) -> bool:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#replace

        **bool QQmlListReference::replace(qsizetype index , QObject * object )
        const**

        Replaces the item at **index** in the list with **object**. Returns true
        if the operation succeeded, otherwise false.

        **See also** **canReplace** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qqmllistreference.html#size

        **[since 6.2] qsizetype QQmlListReference::size() const**

        Returns the number of objects in the list, or 0 if the operation failed.

        This function was introduced in Qt 6.2.
        """
        ...
