"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQml, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, List
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtQml

bytes = str


class QQmlIncubator(object):
    """
    https://doc.qt.io/qt-6/qqmlincubator.html

    **Detailed Description**

    Creating QML objects - like delegates in a view, or a new page in an
    application - can take a noticeable amount of time, especially on resource
    constrained mobile devices. When an application uses
    **QQmlComponent::create** () directly, the QML object instance is created
    synchronously which, depending on the complexity of the object, can cause
    noticeable pauses or stutters in the application.

    The use of QQmlIncubator gives more control over the creation of a QML
    object, including allowing it to be created asynchronously using application
    idle time. The following example shows a simple use of QQmlIncubator.

    QQmlIncubator incubator;
        component->create(incubator);

        while
    (!incubator.isReady()) {
            **QCoreApplication**
    ::processEvents(**QEventLoop** ::AllEvents, 50);
        }

        **QObject**
    *object = incubator.object();

    Asynchronous incubators are controlled by a **QQmlIncubationController**
    that is set on the **QQmlEngine** , which lets the engine know when the
    application is idle and incubating objects should be processed. If an
    incubation controller is not set on the **QQmlEngine** , QQmlIncubator
    creates objects synchronously regardless of the specified **IncubationMode**
    .

    QQmlIncubator supports three incubation modes:

    * Synchronous The creation occurs synchronously. That is, once the
    **QQmlComponent::create** () call returns, the incubator will already be in
    either the Error or Ready state. A synchronous incubator has no real
    advantage compared to using the synchronous creation methods on
    **QQmlComponent**  directly, but it may simplify an application's
    implementation to use the same API for both synchronous and asynchronous
    creations.
      * Asynchronous (default) The creation occurs asynchronously,
    assuming a QQmlIncubatorController is set on the **QQmlEngine** .

    The
    incubator will remain in the Loading state until either the creation is
    complete or an error occurs. The **statusChanged** () callback can be used
    to be notified of status changes.

    Applications should use the Asynchronous
    incubation mode to create objects that are not needed immediately. For
    example, the **ListView**  type uses Asynchronous incubation to create
    objects that are slightly off screen while the list is being scrolled. If,
    during asynchronous creation, the object is needed immediately the
    **QQmlIncubator::forceCompletion** () method can be called to complete the
    creation process synchronously.

      * **AsynchronousIfNested**  The creation
    will occur asynchronously if part of a nested asynchronous creation, or
    synchronously if not.

    In most scenarios where a QML component wants the
    appearance of a synchronous instantiation, it should use this mode.

    This
    mode is best explained with an example. When the **ListView**  type is first
    created, it needs to populate itself with an initial set of delegates to
    show. If the **ListView**  was 400 pixels high, and each delegate was 100
    pixels high, it would need to create four initial delegate instances. If the
    **ListView**  used the Asynchronous incubation mode, the **ListView**  would
    always be created empty and then, sometime later, the four initial items
    would appear.

    Conversely, if the **ListView**  was to use the Synchronous
    incubation mode it would behave correctly but it may introduce stutters into
    the application. As QML would have to stop and instantiate the **ListView**
    's delegates synchronously, if the **ListView**  was part of a QML component
    that was being instantiated asynchronously this would undo much of the
    benefit of asynchronous instantiation.

    The **AsynchronousIfNested**  mode
    reconciles this problem. By using **AsynchronousIfNested** , the
    **ListView**  delegates are instantiated asynchronously if the **ListView**
    itself is already part of an asynchronous instantiation, and synchronously
    otherwise. In the case of a nested asynchronous instantiation, the outer
    asynchronous instantiation will not complete until after all the nested
    instantiations have also completed. This ensures that by the time the outer
    asynchronous instantitation completes, inner items like **ListView**  have
    already completed loading their initial delegates.

    It is almost always
    incorrect to use the Synchronous incubation mode - elements or components
    that want the appearance of synchronous instantiation, but without the
    downsides of introducing freezes or stutters into the application, should
    use the **AsynchronousIfNested**  incubation mode.
    """

    Asynchronous: QQmlIncubator.IncubationMode = ...
    AsynchronousIfNested: QQmlIncubator.IncubationMode = ...
    Synchronous: QQmlIncubator.IncubationMode = ...
    Null: QQmlIncubator.Status = ...
    Ready: QQmlIncubator.Status = ...
    Loading: QQmlIncubator.Status = ...
    Error: QQmlIncubator.Status = ...

    class IncubationMode(Enum):
        Asynchronous: QQmlIncubator.IncubationMode = ...
        AsynchronousIfNested: QQmlIncubator.IncubationMode = ...
        Synchronous: QQmlIncubator.IncubationMode = ...

    class Status(Enum):
        Null: QQmlIncubator.Status = ...
        Ready: QQmlIncubator.Status = ...
        Loading: QQmlIncubator.Status = ...
        Error: QQmlIncubator.Status = ...

    def __init__(
        self, arg__1: PySide6.QtQml.QQmlIncubator.IncubationMode = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#QQmlIncubator-1

        **QQmlIncubator::QQmlIncubator(QQmlIncubator::IncubationMode mode =
        Asynchronous)**

        Create a new incubator with the specified **mode**
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#clear

        **void QQmlIncubator::clear()**

        Clears the incubator. Any in-progress incubation is aborted. If the
        incubator is in the Ready state, the created object is **not** deleted.
        """
        ...

    def errors(self) -> List[PySide6.QtQml.QQmlError]:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#errors

        **QList<QQmlError> QQmlIncubator::errors() const**

        Return the list of errors encountered while incubating the object.
        """
        ...

    def forceCompletion(self) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#forceCompletion

        **void QQmlIncubator::forceCompletion()**

        Force any in-progress incubation to finish synchronously. Once this call
        returns, the incubator will not be in the Loading state.
        """
        ...

    def incubationMode(self) -> PySide6.QtQml.QQmlIncubator.IncubationMode:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#incubationMode

        **QQmlIncubator::IncubationMode QQmlIncubator::incubationMode() const**

        Return the incubation mode passed to the **QQmlIncubator**  constructor.
        """
        ...

    def isError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#isError

        **bool QQmlIncubator::isError() const**

        Returns true if the incubator's **status** () is Error.
        """
        ...

    def isLoading(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#isLoading

        **bool QQmlIncubator::isLoading() const**

        Returns true if the incubator's **status** () is Loading.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#isNull

        **bool QQmlIncubator::isNull() const**

        Returns true if the incubator's **status** () is Null.
        """
        ...

    def isReady(self) -> bool:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#isReady

        **bool QQmlIncubator::isReady() const**

        Returns true if the incubator's **status** () is Ready.
        """
        ...

    def object(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#object

        **QObject *QQmlIncubator::object() const**

        Return the incubated object if the status is Ready, otherwise 0.
        """
        ...

    def setInitialProperties(self, initialProperties: Dict[str, Any]) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#setInitialProperties

        **[since 5.15] void QQmlIncubator::setInitialProperties(const
        QVariantMap & initialProperties )**

        Stores a mapping from property names to initial values, contained in
        **initialProperties** , with which the incubated component will be
        initialized.

        This function was introduced in Qt 5.15.

        **See also** **QQmlComponent::setInitialProperties** .
        """
        ...

    def setInitialState(self, arg__1: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#setInitialState

        **[virtual protected] void QQmlIncubator::setInitialState(QObject *
        object )**

        Called after the **object** is first created, but before property
        bindings are evaluated and, if applicable,
        **QQmlParserStatus::componentComplete** () is called. This is equivalent
        to the point between **QQmlComponent::beginCreate** () and
        **QQmlComponent::completeCreate** (), and can be used to assign initial
        values to the object's properties.

        The default implementation does nothing.
        """
        ...

    def status(self) -> PySide6.QtQml.QQmlIncubator.Status:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#status

        **QQmlIncubator::Status QQmlIncubator::status() const**

        Return the current status of the incubator.
        """
        ...

    def statusChanged(self, arg__1: PySide6.QtQml.QQmlIncubator.Status) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubator.html#statusChanged

        **[virtual protected] void
        QQmlIncubator::statusChanged(QQmlIncubator::Status status )**

        Called when the status of the incubator changes. **status** is the new
        status.

        The default implementation does nothing.
        """
        ...
