"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQml, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtQml

bytes = str


class QQmlIncubationController(object):
    """
    https://doc.qt.io/qt-6/qqmlincubationcontroller.html

    **Detailed Description**

    In order to behave asynchronously and not introduce stutters or freezes in
    an application, the process of creating objects a QQmlIncubators must be
    driven only during the application's idle time. QQmlIncubationController
    allows the application to control exactly when, how often and for how long
    this processing occurs.

    A QQmlIncubationController derived instance should be created and set on a
    **QQmlEngine**  by calling the **QQmlEngine::setIncubationController** ()
    method. Processing is then controlled by calling the
    **QQmlIncubationController::incubateFor** () or
    **QQmlIncubationController::incubateWhile** () methods as dictated by the
    application's requirements.

    For example, this is an example of a incubation controller that will
    incubate for a maximum of 5 milliseconds out of every 16 milliseconds.

    class PeriodicIncubationController : public **QObject** ,
    public QQmlIncubationController
        {
        public:
    PeriodicIncubationController() {
                startTimer(16);
            }
    protected:
            void timerEvent(**QTimerEvent**  *) override {
    incubateFor(5);
            }
        };

    Although the previous example would work, it is not optimal. Real world
    incubation controllers should try and maximize the amount of idle time they
    consume - rather than a static amount like 5 milliseconds - while not
    disturbing the application.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubationcontroller.html#QQmlIncubationContr
        oller-1

        **QQmlIncubationController::QQmlIncubationController()**

        Create a new incubation controller.
        """
        ...

    def engine(self) -> PySide6.QtQml.QQmlEngine:
        """
        https://doc.qt.io/qt-6/qqmlincubationcontroller.html#engine

        **QQmlEngine *QQmlIncubationController::engine() const**

        Return the **QQmlEngine**  this incubation controller is set on, or 0 if
        it has not been set on any engine.
        """
        ...

    def incubateFor(self, msecs: int) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubationcontroller.html#incubateFor

        **void QQmlIncubationController::incubateFor(int msecs )**

        Incubate objects for **msecs** , or until there are no more objects to
        incubate.
        """
        ...

    def incubateWhile(self, flag: PySide6.QtQml.VolatileBool, msecs: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubationcontroller.html#incubateWhile

        **[since 5.15] void
        QQmlIncubationController::incubateWhile(std::atomic<bool> * flag , int
        msecs = 0)**

        Incubate objects while the atomic bool pointed to by **flag** is true,
        or until there are no more objects to incubate, or up to **msecs** if
        **msecs** is not zero.

        Generally this method is used in conjunction with a thread or a UNIX
        signal that sets the bool pointed to by **flag** to false when it wants
        incubation to be interrupted.

        **Note:** **flag** is read using acquire memory ordering.

        This function was introduced in Qt 5.15.
        """
        ...

    def incubatingObjectCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qqmlincubationcontroller.html#incubatingObjectCou
        nt

        **int QQmlIncubationController::incubatingObjectCount() const**

        Return the number of objects currently incubating.
        """
        ...

    def incubatingObjectCountChanged(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qqmlincubationcontroller.html#incubatingObjectCou
        ntChanged

        **[virtual protected] void
        QQmlIncubationController::incubatingObjectCountChanged(int
        incubatingObjectCount )**

        Called when the number of incubating objects changes.
        **incubatingObjectCount** is the new number of incubating objects.

        The default implementation does nothing.
        """
        ...
