"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQml, except for defaults which are replaced by "...".
"""
from typing import Optional, Sequence
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtQml

bytes = str


class QQmlFileSelector(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qqmlfileselector.html

    **Detailed Description**

    QQmlFileSelector will automatically apply a **QFileSelector**  to qml file
    and asset paths.

    It is used as follows:

    **QQmlEngine**  engine;
        **QQmlFileSelector** * selector = new
    **QQmlFileSelector** (&engine);

    Then you can swap out files like so:

    main.qml
        Component.qml
        asset.png
        +unix/Component.qml
    +mac/asset.png

    In this example, main.qml will normally use Component.qml for the Component
    type. However on a unix platform, the unix selector will be present and the
    +unix/Component.qml version will be used instead. Note that this acts like
    swapping out Component.qml with +unix/Component.qml, so when using
    Component.qml you should not need to alter any paths based on which version
    was selected.

    For example, to pass the "asset.png" file path around you would refer to it
    just as "asset.png" in all of main.qml, Component.qml, and
    +linux/Component.qml. It will be replaced with +mac/asset.png on Mac
    platforms in all cases.

    For a list of available selectors, see `QFileSelector`.

    Your platform may also provide additional selectors for you to use. As
    specified by **QFileSelector** , directories used for selection must start
    with a '+' character, so you will not accidentally trigger this feature
    unless you have directories with such names inside your project.

    If a new QQmlFileSelector is set on the engine, the old one will be
    replaced.
    """

    def __init__(
        self,
        engine: PySide6.QtQml.QQmlEngine,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qqmlfileselector.html#QQmlFileSelector

        **QQmlFileSelector::QQmlFileSelector(QQmlEngine * engine , QObject *
        parent = nullptr)**

        Creates a new QQmlFileSelector with parent object **parent** , which
        includes its own **QFileSelector** . **engine** is the **QQmlEngine**
        you wish to apply file selectors to. It will also take ownership of the
        QQmlFileSelector.
        """
        ...

    @staticmethod
    def get(arg__1: PySide6.QtQml.QQmlEngine) -> PySide6.QtQml.QQmlFileSelector:
        ...

    def selector(self) -> PySide6.QtCore.QFileSelector:
        """
        https://doc.qt.io/qt-6/qqmlfileselector.html#selector

        **[since 5.7] QFileSelector *QQmlFileSelector::selector() const**

        Returns the **QFileSelector**  instance used by the **QQmlFileSelector**
        .

        This function was introduced in Qt 5.7.

        **See also** **setSelector** ().
        """
        ...

    def setExtraSelectors(self, strings: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qqmlfileselector.html#setExtraSelectors

        **void QQmlFileSelector::setExtraSelectors(const QStringList & strings
        )**

        Adds extra selectors contained in **strings** to the current
        **QFileSelector**  being used. Use this when extra selectors are all you
        need to avoid having to create your own **QFileSelector**  instance.
        """
        ...

    def setSelector(self, selector: PySide6.QtCore.QFileSelector) -> None:
        """
        https://doc.qt.io/qt-6/qqmlfileselector.html#setSelector

        **void QQmlFileSelector::setSelector(QFileSelector * selector )**

        Sets the **QFileSelector**  instance for use by the **QQmlFileSelector**
        to **selector**. **QQmlFileSelector**  does not take ownership of the
        new **QFileSelector** . To reset **QQmlFileSelector**  to use its
        internal **QFileSelector**  instance, call setSelector(`nullptr`).

        **See also** **selector** ().
        """
        ...
