"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQml, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtQml

bytes = str


class QJSPrimitiveValue(object):
    """
    https://doc.qt.io/qt-6/qjsprimitivevalue.html

    **Detailed Description**

    QJSPrimitiveValue supports most of the primitive types defined in the
    **ECMA-262**  standard, in particular Undefined, Boolean, Number, and
    String. Additionally, you can store a JavaScript null in a QJSPrimitiveValue
    and as a special case of Number, you can store an integer value.

    All those values are stored immediately, without interacting with the
    JavaScript heap. Therefore, you can pass QJSPrimitiveValues between
    different JavaScript engines. In contrast to **QJSManagedValue** , there is
    also no danger in destroying a QJSPrimitiveValue from a different thread
    than it was created in. On the flip side, QJSPrimitiveValue does not hold a
    reference to any JavaScript engine.

    QJSPrimitiveValue implements the JavaScript arithmetic and comparison
    operators on the supported types in JavaScript semantics. Types are coerced
    like the JavaScript engine would coerce them if the operators were written
    in a JavaScript expression.

    The JavaScript Symbol type is not supported as it is of very limited utility
    regarding arithmetic and comparison operators, the main purpose of
    QJSPrimitiveValue. In particular, it causes an exception whenever you try to
    coerce it to a number or a string, and we cannot throw exceptions without a
    JavaScript Engine.
    """

    Undefined: QJSPrimitiveValue.Type = ...
    Null: QJSPrimitiveValue.Type = ...
    Boolean: QJSPrimitiveValue.Type = ...
    Integer: QJSPrimitiveValue.Type = ...
    Double: QJSPrimitiveValue.Type = ...
    String: QJSPrimitiveValue.Type = ...

    class Type(Enum):
        Undefined: QJSPrimitiveValue.Type = ...
        Null: QJSPrimitiveValue.Type = ...
        Boolean: QJSPrimitiveValue.Type = ...
        Integer: QJSPrimitiveValue.Type = ...
        Double: QJSPrimitiveValue.Type = ...
        String: QJSPrimitiveValue.Type = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#QJSPrimitiveValue

        **QJSPrimitiveValue::QJSPrimitiveValue()**

        Creates a QJSPrimitiveValue of type Undefined.
        """
        ...

    @overload
    def __init__(self, string: str) -> None:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#QJSPrimitiveValue-1

        **QJSPrimitiveValue::QJSPrimitiveValue(QJSPrimitiveUndefined undefined
        )**

        Creates a QJSPrimitiveValue of value **undefined** and type Undefined.
        """
        ...

    @overload
    def __init__(self, value: bool) -> None:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#QJSPrimitiveValue-2

        **QJSPrimitiveValue::QJSPrimitiveValue(QJSPrimitiveNull null )**

        Creates a QJSPrimitiveValue of value **null** and type Null.
        """
        ...

    @overload
    def __init__(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#QJSPrimitiveValue-3

        **QJSPrimitiveValue::QJSPrimitiveValue(bool value )**

        Creates a QJSPrimitiveValue of value **value** and type Boolean.
        """
        ...

    @overload
    def __init__(self, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#QJSPrimitiveValue-4

        **QJSPrimitiveValue::QJSPrimitiveValue(int value )**

        Creates a QJSPrimitiveValue of value **value** and type Integer.
        """
        ...

    @overload
    def __init__(self, variant: Any) -> None:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#QJSPrimitiveValue-5

        **QJSPrimitiveValue::QJSPrimitiveValue(double value )**

        Creates a QJSPrimitiveValue of value **value** and type Double.
        """
        ...

    def __add__(
        self, rhs: Union[PySide6.QtQml.QJSPrimitiveValue, str, float, int]
    ) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, arg__1: int) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    def __isub__(self, arg__1: int) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    def __mod__(
        self, rhs: Union[PySide6.QtQml.QJSPrimitiveValue, str, float, int]
    ) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    def __mul__(
        self, rhs: Union[PySide6.QtQml.QJSPrimitiveValue, str, float, int]
    ) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    def __neg__(self) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    def __pos__(self) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    def __sub__(
        self, rhs: Union[PySide6.QtQml.QJSPrimitiveValue, str, float, int]
    ) -> PySide6.QtQml.QJSPrimitiveValue:
        ...

    def equals(
        self, other: Union[PySide6.QtQml.QJSPrimitiveValue, str, float, int]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#equals

        **bool QJSPrimitiveValue::equals(const QJSPrimitiveValue & other )
        const**

        Performs the JavaScript '==' operation on this **QJSPrimitiveValue**
        and **other** , and returns the result.
        """
        ...

    def strictlyEquals(
        self, other: Union[PySide6.QtQml.QJSPrimitiveValue, str, float, int]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#strictlyEquals

        **bool QJSPrimitiveValue::strictlyEquals(const QJSPrimitiveValue & other
        ) const**

        Performs the JavaScript '===' operation on this **QJSPrimitiveValue**
        and **other** , and returns the result.
        """
        ...

    def toBoolean(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#toBoolean

        **bool QJSPrimitiveValue::toBoolean() const**

        Returns the value coerced a boolean by JavaScript rules.
        """
        ...

    def toDouble(self) -> float:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#toDouble

        **double QJSPrimitiveValue::toDouble() const**

        Returns the value coerced to a JavaScript Number by JavaScript rules.
        """
        ...

    def toInteger(self) -> int:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#toInteger

        **int QJSPrimitiveValue::toInteger() const**

        Returns the value coerced to an integral 32bit number by the rules
        JavaScript would apply when preparing it for a bit shift operation.
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#toString

        **QString QJSPrimitiveValue::toString() const**

        Returns the value coerced to a JavaScript String by JavaScript rules.
        """
        ...

    def toVariant(self) -> Any:
        ...

    def type(self) -> PySide6.QtQml.QJSPrimitiveValue.Type:
        """
        https://doc.qt.io/qt-6/qjsprimitivevalue.html#type

        **QJSPrimitiveValue::Type QJSPrimitiveValue::type() const**

        Returns the type of the **QJSPrimitiveValue** .
        """
        ...
