"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPrintSupport, except for defaults which are replaced by "...".
"""
from typing import List, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport

bytes = str


class QPrinterInfo(object):
    """
    https://doc.qt.io/qt-6/qprinterinfo.html

    **Detailed Description**

    Use the static functions to generate a list of QPrinterInfo objects. Each
    QPrinterInfo object in the list represents a single printer and can be
    queried for name, supported paper sizes, and whether or not it is the
    default printer.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#QPrinterInfo

        **QPrinterInfo::QPrinterInfo()**

        Constructs an empty QPrinterInfo object.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtPrintSupport.QPrinterInfo) -> None:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#QPrinterInfo-1

        **QPrinterInfo::QPrinterInfo(const QPrinterInfo & other )**

        Constructs a copy of **other**.
        """
        ...

    @overload
    def __init__(self, printer: PySide6.QtPrintSupport.QPrinter) -> None:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#QPrinterInfo-2

        **QPrinterInfo::QPrinterInfo(const QPrinter & printer )**

        Constructs a QPrinterInfo object from **printer**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def availablePrinterNames() -> List[str]:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#availablePrinterNames

        **[static, since 5.3] QStringList
        QPrinterInfo::availablePrinterNames()**

        Returns a list of all the available Printer Names on this system.

        It is recommended to use this instead of **availablePrinters** () as it
        will be faster on most systems.

        Note that the list may become outdated if changes are made on the local
        system or remote print server. Only instantiate required
        **QPrinterInfo**  instances when needed, and always check for validity
        before calling.

        This function was introduced in Qt 5.3.
        """
        ...

    @staticmethod
    def availablePrinters() -> List[PySide6.QtPrintSupport.QPrinterInfo]:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#availablePrinters

        **[static] QList<QPrinterInfo> QPrinterInfo::availablePrinters()**

        Returns a list of **QPrinterInfo**  objects for all the available
        printers on this system.

        It is NOT recommended to use this as creating each printer instance may
        take a long time, especially if there are remote networked printers, and
        retained instances may become outdated if changes are made on the local
        system or remote print server. Use **availablePrinterNames** () instead
        and only instantiate printer instances as you need them.
        """
        ...

    def defaultColorMode(self) -> PySide6.QtPrintSupport.QPrinter.ColorMode:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#defaultColorMode

        **[since 5.13] QPrinter::ColorMode QPrinterInfo::defaultColorMode()
        const**

        Returns the default color mode of this printer.

        This function was introduced in Qt 5.13.
        """
        ...

    def defaultDuplexMode(self) -> PySide6.QtPrintSupport.QPrinter.DuplexMode:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#defaultDuplexMode

        **[since 5.4] QPrinter::DuplexMode QPrinterInfo::defaultDuplexMode()
        const**

        Returns the default duplex mode of this printer.

        This function was introduced in Qt 5.4.
        """
        ...

    def defaultPageSize(self) -> PySide6.QtGui.QPageSize:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#defaultPageSize

        **[since 5.3] QPageSize QPrinterInfo::defaultPageSize() const**

        Returns the current default Page Size for this printer.

        This function was introduced in Qt 5.3.
        """
        ...

    @staticmethod
    def defaultPrinter() -> PySide6.QtPrintSupport.QPrinterInfo:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#defaultPrinter

        **[static] QPrinterInfo QPrinterInfo::defaultPrinter()**

        Returns the default printer on the system.

        The return value should be checked using **isNull** () before being
        used, in case there is no default printer.

        On some systems it is possible for there to be available printers but
        none of them set to be the default printer.

        **See also** **isNull** (), **isDefault** (), and **availablePrinters**
        ().
        """
        ...

    @staticmethod
    def defaultPrinterName() -> str:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#defaultPrinterName

        **[static, since 5.3] QString QPrinterInfo::defaultPrinterName()**

        Returns the current default printer name.

        This function was introduced in Qt 5.3.
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#description

        **[since 5.0] QString QPrinterInfo::description() const**

        Returns the human-readable description of the printer.

        This function was introduced in Qt 5.0.

        **See also** **QPrinterInfo::printerName** ().
        """
        ...

    def isDefault(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#isDefault

        **bool QPrinterInfo::isDefault() const**

        Returns whether this printer is currently the default printer.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#isNull

        **bool QPrinterInfo::isNull() const**

        Returns whether this **QPrinterInfo**  object holds a printer
        definition.

        An empty **QPrinterInfo**  object could result for example from calling
        **defaultPrinter** () when there are no printers on the system.
        """
        ...

    def isRemote(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#isRemote

        **[since 5.3] bool QPrinterInfo::isRemote() const**

        Returns whether this printer is a remote network printer.

        This function was introduced in Qt 5.3.
        """
        ...

    def location(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#location

        **[since 5.0] QString QPrinterInfo::location() const**

        Returns the human-readable location of the printer.

        This function was introduced in Qt 5.0.
        """
        ...

    def makeAndModel(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#makeAndModel

        **[since 5.0] QString QPrinterInfo::makeAndModel() const**

        Returns the human-readable make and model of the printer.

        This function was introduced in Qt 5.0.
        """
        ...

    def maximumPhysicalPageSize(self) -> PySide6.QtGui.QPageSize:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#maximumPhysicalPageSize

        **[since 5.3] QPageSize QPrinterInfo::maximumPhysicalPageSize() const**

        Returns the maximum physical page size supported by this printer.

        This function was introduced in Qt 5.3.

        **See also** **minimumPhysicalPageSize** ().
        """
        ...

    def minimumPhysicalPageSize(self) -> PySide6.QtGui.QPageSize:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#minimumPhysicalPageSize

        **[since 5.3] QPageSize QPrinterInfo::minimumPhysicalPageSize() const**

        Returns the minimum physical page size supported by this printer.

        This function was introduced in Qt 5.3.

        **See also** **maximumPhysicalPageSize** ().
        """
        ...

    @staticmethod
    def printerInfo(printerName: str) -> PySide6.QtPrintSupport.QPrinterInfo:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#printerInfo

        **[static, since 5.0] QPrinterInfo QPrinterInfo::printerInfo(const
        QString & printerName )**

        Returns the printer **printerName**.

        The return value should be checked using **isNull** () before being
        used, in case the named printer does not exist.

        This function was introduced in Qt 5.0.

        **See also** **isNull** ().
        """
        ...

    def printerName(self) -> str:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#printerName

        **QString QPrinterInfo::printerName() const**

        Returns the name of the printer.

        This is a unique id to identify the printer and may not be human-
        readable.

        **See also** **QPrinterInfo::description** () and
        **QPrinter::setPrinterName** ().
        """
        ...

    def state(self) -> PySide6.QtPrintSupport.QPrinter.PrinterState:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#state

        **[since 5.3] QPrinter::PrinterState QPrinterInfo::state() const**

        Returns the current state of this printer.

        This state may not always be accurate, depending on the platform,
        printer driver, or printer itself.

        This function was introduced in Qt 5.3.
        """
        ...

    def supportedColorModes(self) -> List[PySide6.QtPrintSupport.QPrinter.ColorMode]:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#supportedColorModes

        **[since 5.13] QList<QPrinter::ColorMode>
        QPrinterInfo::supportedColorModes() const**

        Returns the supported color modes of this printer.

        This function was introduced in Qt 5.13.
        """
        ...

    def supportedDuplexModes(self) -> List[PySide6.QtPrintSupport.QPrinter.DuplexMode]:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#supportedDuplexModes

        **[since 5.4] QList<QPrinter::DuplexMode>
        QPrinterInfo::supportedDuplexModes() const**

        Returns a list of duplex modes supported by this printer.

        This function was introduced in Qt 5.4.
        """
        ...

    def supportedPageSizes(self) -> List[PySide6.QtGui.QPageSize]:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#supportedPageSizes

        **[since 5.3] QList<QPageSize> QPrinterInfo::supportedPageSizes()
        const**

        Returns a list of Page Sizes supported by this printer.

        This function was introduced in Qt 5.3.
        """
        ...

    def supportedResolutions(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#supportedResolutions

        **[since 5.3] QList<int> QPrinterInfo::supportedResolutions() const**

        Returns a list of resolutions supported by this printer.

        This function was introduced in Qt 5.3.
        """
        ...

    def supportsCustomPageSizes(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprinterinfo.html#supportsCustomPageSizes

        **[since 5.3] bool QPrinterInfo::supportsCustomPageSizes() const**

        Returns whether this printer supports custom page sizes.

        This function was introduced in Qt 5.3.
        """
        ...
