"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPrintSupport, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport

bytes = str


class QPrintPreviewWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qprintpreviewwidget.html

    **Detailed Description**

    **QPrintPreviewDialog**  uses a QPrintPreviewWidget internally, and the
    purpose of QPrintPreviewWidget is to make it possible to embed the preview
    into other widgets. It also makes it possible to build a different user
    interface around it than the default one provided with
    **QPrintPreviewDialog** .

    Using QPrintPreviewWidget is straightforward:

    1. Create the QPrintPreviewWidget

    Construct the QPrintPreviewWidget either
    by passing in an existing **QPrinter**  object, or have QPrintPreviewWidget
    create a default constructed **QPrinter**  object for you.

      2. Connect the
    **paintRequested** () signal to a slot.

    When the widget needs to generate a
    set of preview pages, a **paintRequested** () signal will be emitted from
    the widget. Connect a slot to this signal, and draw onto the **QPrinter**
    passed in as a signal parameter. Call **QPrinter::newPage** (), to start a
    new page in the preview.

    **See also** **QPrinter** , **QPrintDialog** , **QPageSetupDialog** , and
    **QPrintPreviewDialog** .
    """

    SinglePageView: QPrintPreviewWidget.ViewMode = ...
    FacingPagesView: QPrintPreviewWidget.ViewMode = ...
    AllPagesView: QPrintPreviewWidget.ViewMode = ...
    CustomZoom: QPrintPreviewWidget.ZoomMode = ...
    FitToWidth: QPrintPreviewWidget.ZoomMode = ...
    FitInView: QPrintPreviewWidget.ZoomMode = ...

    class ViewMode(Enum):
        SinglePageView: QPrintPreviewWidget.ViewMode = ...
        FacingPagesView: QPrintPreviewWidget.ViewMode = ...
        AllPagesView: QPrintPreviewWidget.ViewMode = ...

    class ZoomMode(Enum):
        CustomZoom: QPrintPreviewWidget.ZoomMode = ...
        FitToWidth: QPrintPreviewWidget.ZoomMode = ...
        FitInView: QPrintPreviewWidget.ZoomMode = ...

    @overload
    def __init__(
        self,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
        flags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#QPrintPreviewWidget

        **QPrintPreviewWidget::QPrintPreviewWidget(QPrinter * printer , QWidget
        * parent = nullptr, Qt::WindowFlags flags = Qt::WindowFlags())**

        Constructs a QPrintPreviewWidget based on **printer** and with
        **parent** as the parent widget. The widget flags **flags** are passed
        on to the **QWidget**  constructor.

        **See also** **QWidget::setWindowFlags** ().
        """
        ...

    @overload
    def __init__(
        self,
        printer: PySide6.QtPrintSupport.QPrinter,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
        flags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#QPrintPreviewWidget-1

        **QPrintPreviewWidget::QPrintPreviewWidget(QWidget * parent = nullptr,
        Qt::WindowFlags flags = Qt::WindowFlags())**

        This is an overloaded function.

        This will cause QPrintPreviewWidget to create an internal, default
        constructed **QPrinter**  object, which will be used to generate the
        preview.
        """
        ...

    def currentPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#currentPage

        **int QPrintPreviewWidget::currentPage() const**

        Returns the currently viewed page in the preview.

        **See also** **setCurrentPage** ().
        """
        ...

    def fitInView(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#fitInView

        **[slot] void QPrintPreviewWidget::fitInView()**

        This is a convenience function and is the same as calling
        `setZoomMode(QPrintPreviewWidget::FitInView)`.
        """
        ...

    def fitToWidth(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#fitToWidth

        **[slot] void QPrintPreviewWidget::fitToWidth()**

        This is a convenience function and is the same as calling
        `setZoomMode(QPrintPreviewWidget::FitToWidth)`.
        """
        ...

    def orientation(self) -> PySide6.QtGui.QPageLayout.Orientation:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#orientation

        **QPageLayout::Orientation QPrintPreviewWidget::orientation() const**

        Returns the current orientation of the preview. This value is obtained
        from the **QPrinter**  object associated with the preview.

        **See also** **setOrientation** ().
        """
        ...

    def pageCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#pageCount

        **int QPrintPreviewWidget::pageCount() const**

        Returns the number of pages in the preview.
        """
        ...

    def print_(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#print

        **[slot] void QPrintPreviewWidget::print()**

        Prints the preview to the printer associated with the preview.
        """
        ...

    def setAllPagesViewMode(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setAllPagesViewMode

        **[slot] void QPrintPreviewWidget::setAllPagesViewMode()**

        This is a convenience function and is the same as calling
        `setViewMode(QPrintPreviewWidget::AllPagesView)`.
        """
        ...

    def setCurrentPage(self, pageNumber: int) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setCurrentPage

        **[slot] void QPrintPreviewWidget::setCurrentPage(int page )**

        Sets the current page in the preview. This will cause the view to skip
        to the beginning of **page**.

        **See also** **currentPage** ().
        """
        ...

    def setFacingPagesViewMode(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setFacingPagesViewMode

        **[slot] void QPrintPreviewWidget::setFacingPagesViewMode()**

        This is a convenience function and is the same as calling
        `setViewMode(QPrintPreviewWidget::FacingPagesView)`.
        """
        ...

    def setLandscapeOrientation(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setLandscapeOrientation

        **[slot] void QPrintPreviewWidget::setLandscapeOrientation()**

        This is a convenience function and is the same as calling
        `setOrientation(QPageLayout::Landscape)`.
        """
        ...

    def setOrientation(
        self, orientation: PySide6.QtGui.QPageLayout.Orientation
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setOrientation

        **[slot] void
        QPrintPreviewWidget::setOrientation(QPageLayout::Orientation orientation
        )**

        Sets the current orientation to **orientation**. This value will be set
        on the **QPrinter**  object associated with the preview.

        **See also** **orientation** ().
        """
        ...

    def setPortraitOrientation(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setPortraitOrientation

        **[slot] void QPrintPreviewWidget::setPortraitOrientation()**

        This is a convenience function and is the same as calling
        `setOrientation(QPageLayout::Portrait)`.
        """
        ...

    def setSinglePageViewMode(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setSinglePageViewMode

        **[slot] void QPrintPreviewWidget::setSinglePageViewMode()**

        This is a convenience function and is the same as calling
        `setViewMode(QPrintPreviewWidget::SinglePageView)`.
        """
        ...

    def setViewMode(
        self, viewMode: PySide6.QtPrintSupport.QPrintPreviewWidget.ViewMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setViewMode

        **[slot] void
        QPrintPreviewWidget::setViewMode(QPrintPreviewWidget::ViewMode mode )**

        Sets the view mode to **mode**. The default view mode is
        **SinglePageView** .

        **See also** **viewMode** ().
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setVisible

        **[override virtual] void QPrintPreviewWidget::setVisible(bool visible
        )**
        """
        ...

    def setZoomFactor(self, zoomFactor: float) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setZoomFactor

        **[slot] void QPrintPreviewWidget::setZoomFactor(qreal factor )**

        Sets the zoom factor of the view to **factor**. For example, a value of
        1.0 indicates an unscaled view, which is approximately the size the view
        will have on paper. A value of 0.5 will halve the size of the view,
        while a value of 2.0 will double the size of the view.

        **See also** **zoomFactor** ().
        """
        ...

    def setZoomMode(
        self, zoomMode: PySide6.QtPrintSupport.QPrintPreviewWidget.ZoomMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#setZoomMode

        **[slot] void
        QPrintPreviewWidget::setZoomMode(QPrintPreviewWidget::ZoomMode zoomMode
        )**

        Sets the zoom mode to **zoomMode**. The default zoom mode is
        **FitInView** .

        **See also** **zoomMode** (), **viewMode** (), and **setViewMode** ().
        """
        ...

    def updatePreview(self) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#updatePreview

        **[slot] void QPrintPreviewWidget::updatePreview()**

        This function updates the preview, which causes the **paintRequested**
        () signal to be emitted.
        """
        ...

    def viewMode(self) -> PySide6.QtPrintSupport.QPrintPreviewWidget.ViewMode:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#viewMode

        **QPrintPreviewWidget::ViewMode QPrintPreviewWidget::viewMode() const**

        Returns the current view mode. The default view mode is
        **SinglePageView** .

        **See also** **setViewMode** ().
        """
        ...

    def zoomFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#zoomFactor

        **qreal QPrintPreviewWidget::zoomFactor() const**

        Returns the zoom factor of the view.

        **See also** **setZoomFactor** ().
        """
        ...

    def zoomIn(self, zoom: float = ...) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#zoomIn

        **[slot] void QPrintPreviewWidget::zoomIn(qreal factor = 1.1)**

        Zooms the current view in by **factor**. The default value for
        **factor** is 1.1, which means the view will be scaled up by 10%.
        """
        ...

    def zoomMode(self) -> PySide6.QtPrintSupport.QPrintPreviewWidget.ZoomMode:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#zoomMode

        **QPrintPreviewWidget::ZoomMode QPrintPreviewWidget::zoomMode() const**

        Returns the current zoom mode.

        **See also** **setZoomMode** (), **viewMode** (), and **setViewMode**
        ().
        """
        ...

    def zoomOut(self, zoom: float = ...) -> None:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#zoomOut

        **[slot] void QPrintPreviewWidget::zoomOut(qreal factor = 1.1)**

        Zooms the current view out by **factor**. The default value for
        **factor** is 1.1, which means the view will be scaled down by 10%.
        """
        ...

    @property
    def paintRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#paintRequested

        **[signal] void QPrintPreviewWidget::paintRequested(QPrinter * printer
        )**

        This signal is emitted when the preview widget needs to generate a set
        of preview pages. **printer** is the printer associated with this
        preview widget.
        """
        ...

    @property
    def previewChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprintpreviewwidget.html#previewChanged

        **[signal] void QPrintPreviewWidget::previewChanged()**

        This signal is emitted whenever the preview widget has changed some
        internal state, such as the orientation.
        """
        ...
