"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPrintSupport, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport

bytes = str


class QPrintDialog(PySide6.QtPrintSupport.QAbstractPrintDialog):
    """
    https://doc.qt.io/qt-6/qprintdialog.html

    **Detailed Description**

    The dialog allows users to change document-related settings, such as the
    paper size and orientation, type of print (color or grayscale), range of
    pages, and number of copies to print.

    Controls are also provided to enable users to choose from the printers
    available, including any configured network printers.

    Typically, QPrintDialog objects are constructed with a **QPrinter**  object,
    and executed using the **exec** () function.

    **QPrintDialog**  printDialog(printer, parent);
        if (printDialog.exec()
    == **QDialog** ::Accepted) {
            // print ...
        }

    If the dialog is accepted by the user, the **QPrinter**  object is correctly
    configured for printing.

    ![](images/plastique-printdialog.png)![](images/plastique-printdialog-
    properties.png)

    The printer dialog (shown above in Plastique style) enables access to common
    printing properties. On X11 platforms that use the CUPS printing system, the
    settings for each available printer can be modified via the dialog's
    **Properties** push button.

    On Windows and macOS, the native print dialog is used, which means that some
    **QWidget**  and **QDialog**  properties set on the dialog won't be
    respected. The native print dialog on macOS does not support setting printer
    options, i.e. **setOptions** () and **setOption** () have no effect.

    In Qt 4.4, it was possible to use the static functions to show a sheet on
    macOS. This is no longer supported in Qt 4.5. If you want this
    functionality, use **QPrintDialog::open** ().

    **See also** **QPageSetupDialog**  and **QPrinter** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#QPrintDialog

        **QPrintDialog::QPrintDialog(QPrinter * printer , QWidget * parent =
        nullptr)**

        Constructs a new modal printer dialog for the given **printer** with the
        given **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        printer: PySide6.QtPrintSupport.QPrinter,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#QPrintDialog-1

        **QPrintDialog::QPrintDialog(QWidget * parent = nullptr)**

        Constructs a print dialog with the given **parent**.
        """
        ...

    def done(self, result: int) -> None:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#done

        **[override virtual] void QPrintDialog::done(int result )**

        Reimplements: **QDialog::done** (int r).

        Closes the dialog and sets its result code to **result**. If this dialog
        is shown with **exec** (), done() causes the local event loop to finish,
        and **exec** () to return **result**.

        **Note:** This function does not apply to the Native Print Dialog on the
        Mac macOS and Windows platforms, because the dialog is required to be
        modal and only the user can close it.

        **See also** **QDialog::done** ().
        """
        ...

    def exec(self) -> int:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#exec

        **[override virtual] int QPrintDialog::exec()**

        Reimplements: **QDialog::exec** ().
        """
        ...

    def exec_(self) -> int:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#exec

        **[override virtual] int QPrintDialog::exec()**

        Reimplements: **QDialog::exec** ().
        """
        ...

    def open(self, receiver: PySide6.QtCore.QObject, member: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#open

        **void QPrintDialog::open(QObject * receiver , const char * member )**

        This is an overloaded function.

        Opens the dialog and connects its **accepted** () signal to the slot
        specified by **receiver** and **member**.

        The signal will be disconnected from the slot when the dialog is closed.
        """
        ...

    def options(self) -> PySide6.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#options-prop

        **options : PrintDialogOptions**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        Options should be set before showing the dialog. Setting them while the
        dialog is visible is not guaranteed to have an immediate effect on the
        dialog (depending on the option and on the platform).

        **Access functions:**

        QAbstractPrintDialog::PrintDialogOptions **options** () const
        void
        **setOptions** (QAbstractPrintDialog::PrintDialogOptions **options** )

        **See also** **setOption** () and **testOption** ().

        **Member Function Documentation**
        """
        ...

    def setOption(
        self,
        option: PySide6.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption,
        on: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#setOption

        **void QPrintDialog::setOption(QAbstractPrintDialog::PrintDialogOption
        option , bool on = true)**

        Sets the given **option** to be enabled if **on** is true; otherwise,
        clears the given **option**.

        **See also** **options**  and **testOption** ().
        """
        ...

    def setOptions(
        self, options: PySide6.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#options-prop

        **options : PrintDialogOptions**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        Options should be set before showing the dialog. Setting them while the
        dialog is visible is not guaranteed to have an immediate effect on the
        dialog (depending on the option and on the platform).

        **Access functions:**

        QAbstractPrintDialog::PrintDialogOptions **options** () const
        void
        **setOptions** (QAbstractPrintDialog::PrintDialogOptions **options** )

        **See also** **setOption** () and **testOption** ().

        **Member Function Documentation**
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#setVisible

        **[override virtual] void QPrintDialog::setVisible(bool visible )**

        Reimplements: **QDialog::setVisible** (bool visible).
        """
        ...

    def testOption(
        self, option: PySide6.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#testOption

        **bool QPrintDialog::testOption(QAbstractPrintDialog::PrintDialogOption
        option ) const**

        Returns `true` if the given **option** is enabled; otherwise, returns
        false.

        **See also** **options**  and **setOption** ().
        """
        ...

    @property
    def accepted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qprintdialog.html#accepted

        **[signal] void QPrintDialog::accepted(QPrinter * printer )**

        This signal is emitted when the user accepts the values set in the print
        dialog. The **printer** parameter includes the printer that the settings
        were applied to.
        """
        ...
