"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPrintSupport, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Sequence
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport

bytes = str


class QAbstractPrintDialog(PySide6.QtWidgets.QDialog):
    """
    https://doc.qt.io/qt-6/qabstractprintdialog.html

    **Detailed Description**

    This class implements getter and setter functions that are used to customize
    settings shown in print dialogs, but it is not used directly. Use
    **QPrintDialog**  to display a print dialog in your application.

    **See also** **QPrintDialog**  and **QPrinter** .
    """

    PrintToFile: QAbstractPrintDialog.PrintDialogOption = ...
    PrintSelection: QAbstractPrintDialog.PrintDialogOption = ...
    PrintPageRange: QAbstractPrintDialog.PrintDialogOption = ...
    PrintShowPageSize: QAbstractPrintDialog.PrintDialogOption = ...
    PrintCollateCopies: QAbstractPrintDialog.PrintDialogOption = ...
    PrintCurrentPage: QAbstractPrintDialog.PrintDialogOption = ...
    AllPages: QAbstractPrintDialog.PrintRange = ...
    Selection: QAbstractPrintDialog.PrintRange = ...
    PageRange: QAbstractPrintDialog.PrintRange = ...
    CurrentPage: QAbstractPrintDialog.PrintRange = ...

    class PrintDialogOption(Enum):
        PrintToFile: QAbstractPrintDialog.PrintDialogOption = ...
        PrintSelection: QAbstractPrintDialog.PrintDialogOption = ...
        PrintPageRange: QAbstractPrintDialog.PrintDialogOption = ...
        PrintShowPageSize: QAbstractPrintDialog.PrintDialogOption = ...
        PrintCollateCopies: QAbstractPrintDialog.PrintDialogOption = ...
        PrintCurrentPage: QAbstractPrintDialog.PrintDialogOption = ...

    class PrintDialogOptions(object):
        ...

    class PrintRange(Enum):
        AllPages: QAbstractPrintDialog.PrintRange = ...
        Selection: QAbstractPrintDialog.PrintRange = ...
        PageRange: QAbstractPrintDialog.PrintRange = ...
        CurrentPage: QAbstractPrintDialog.PrintRange = ...

    def __init__(
        self,
        printer: PySide6.QtPrintSupport.QPrinter,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#QAbstractPrintDialog

        **QAbstractPrintDialog::QAbstractPrintDialog(QPrinter * printer ,
        QWidget * parent = nullptr)**

        Constructs an abstract print dialog for **printer** with **parent** as
        parent widget.
        """
        ...

    def fromPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#fromPage

        **int QAbstractPrintDialog::fromPage() const**

        Returns the first page to be printed By default, this value is set to 0.
        """
        ...

    def maxPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#maxPage

        **int QAbstractPrintDialog::maxPage() const**

        Returns the maximum page in the page range. As of Qt 4.4, this function
        returns INT_MAX by default. Previous versions returned 1 by default.
        """
        ...

    def minPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#minPage

        **int QAbstractPrintDialog::minPage() const**

        Returns the minimum page in the page range. By default, this value is
        set to 1.
        """
        ...

    def printRange(self) -> PySide6.QtPrintSupport.QAbstractPrintDialog.PrintRange:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#printRange

        **QAbstractPrintDialog::PrintRange QAbstractPrintDialog::printRange()
        const**

        Returns the print range.

        **See also** **setPrintRange** ().
        """
        ...

    def printer(self) -> PySide6.QtPrintSupport.QPrinter:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#printer

        **QPrinter *QAbstractPrintDialog::printer() const**

        Returns the printer that this printer dialog operates on.
        """
        ...

    def setFromTo(self, fromPage: int, toPage: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#setFromTo

        **void QAbstractPrintDialog::setFromTo(int from , int to )**

        Sets the range in the print dialog to be from **from** to **to**.
        """
        ...

    def setMinMax(self, min: int, max: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#setMinMax

        **void QAbstractPrintDialog::setMinMax(int min , int max )**

        Sets the page range in this dialog to be from **min** to **max**. This
        also enables the **PrintPageRange**  option.
        """
        ...

    def setOptionTabs(self, tabs: Sequence[PySide6.QtWidgets.QWidget]) -> None:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#setOptionTabs

        **void QAbstractPrintDialog::setOptionTabs(const QList<QWidget *> & tabs
        )**

        Set a list of widgets as **tabs** to be shown on the print dialog, if
        supported.

        Currently this option is only supported on X11.

        Setting the option tabs will transfer their ownership to the print
        dialog.
        """
        ...

    def setPrintRange(
        self, range: PySide6.QtPrintSupport.QAbstractPrintDialog.PrintRange
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#setPrintRange

        **void
        QAbstractPrintDialog::setPrintRange(QAbstractPrintDialog::PrintRange
        range )**

        Sets the print range option in to be **range**.

        **See also** **printRange** ().
        """
        ...

    def toPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractprintdialog.html#toPage

        **int QAbstractPrintDialog::toPage() const**

        Returns the last page to be printed. By default, this value is set to 0.
        """
        ...
