"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPositioning, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, List, overload
import PySide6.QtCore
import PySide6.QtPositioning

bytes = str


class QGeoSatelliteInfoSource(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qgeosatelliteinfosource.html

    **Detailed Description**

    The static function **QGeoSatelliteInfoSource::createDefaultSource** ()
    creates a default satellite data source that is appropriate for the
    platform, if one is available. Otherwise, available
    **QGeoPositionInfoSourceFactory**  plugins will be checked for one that has
    a satellite data source available.

    Call **startUpdates** () and **stopUpdates** () to start and stop regular
    updates, or **requestUpdate** () to request a single update. When an update
    is available, **satellitesInViewUpdated** () and/or
    **satellitesInUseUpdated** () will be emitted.

    If regular satellite updates are required, **setUpdateInterval** () can be
    used to specify how often these updates should be emitted. If no interval is
    specified, updates are simply provided whenever they are available. For
    example:

    // Emit updates every 10 seconds if available
        QGeoSatelliteInfoSource
    *source = QGeoSatelliteInfoSource::createDefaultSource(0);
        if (source)
    source->setUpdateInterval(10000);

    To remove an update interval that was previously set, call
    **setUpdateInterval** () with a value of 0.

    **Note:** The satellite source may have a minimum value requirement for
    update intervals, as returned by **minimumUpdateInterval** ().

    **Note:** To use this class from Android service, see **Qt Positioning on
    Android** .
    """

    UnknownSourceError: QGeoSatelliteInfoSource.Error = ...
    AccessError: QGeoSatelliteInfoSource.Error = ...
    ClosedError: QGeoSatelliteInfoSource.Error = ...
    NoError: QGeoSatelliteInfoSource.Error = ...
    UpdateTimeoutError: QGeoSatelliteInfoSource.Error = ...

    class Error(Enum):
        UnknownSourceError: QGeoSatelliteInfoSource.Error = ...
        AccessError: QGeoSatelliteInfoSource.Error = ...
        ClosedError: QGeoSatelliteInfoSource.Error = ...
        NoError: QGeoSatelliteInfoSource.Error = ...
        UpdateTimeoutError: QGeoSatelliteInfoSource.Error = ...

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    @staticmethod
    def availableSources() -> List[str]:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#availableSources

        **[static] QStringList QGeoSatelliteInfoSource::availableSources()**

        Returns a list of available source plugins, including the default system
        backend if one is available.
        """
        ...

    def backendProperty(self, name: str) -> Any:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#backendProperty

        **[virtual, since 6.2] QVariant
        QGeoSatelliteInfoSource::backendProperty(const QString & name ) const**

        Returns the value of the backend-specific property named **name** , if
        present. Otherwise the returned value will be invalid.

        This function was introduced in Qt 6.2.

        **See also** **setBackendProperty** .
        """
        ...

    @overload
    @staticmethod
    def createDefaultSource(
        parameters: Dict[str, Any], parent: PySide6.QtCore.QObject
    ) -> PySide6.QtPositioning.QGeoSatelliteInfoSource:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#createDefaultSource

        **[static] QGeoSatelliteInfoSource
        *QGeoSatelliteInfoSource::createDefaultSource(QObject * parent )**

        Creates and returns a source with the specified **parent** that reads
        from the system's default source of satellite update information, or the
        highest priority available plugin.

        Returns `nullptr` if the system has no default satellite source, no
        valid plugins could be found or the user does not have the permission to
        access the satellite data.
        """
        ...

    @overload
    @staticmethod
    def createDefaultSource(
        parent: PySide6.QtCore.QObject,
    ) -> PySide6.QtPositioning.QGeoSatelliteInfoSource:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#createDefaultSource-
        1

        **[static, since Qt 5.14] QGeoSatelliteInfoSource
        *QGeoSatelliteInfoSource::createDefaultSource(const QVariantMap &
        parameters , QObject * parent )**

        Creates and returns a satellite source with the given **parent** that
        reads from the system's default sources of satellite data, or the plugin
        with the highest available priority.

        Returns `nullptr` if the system has no default satellite source, no
        valid plugins could be found or the user does not have the permission to
        access the satellite information.

        This method passes **parameters** to the factory to configure the
        source.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    @staticmethod
    def createSource(
        sourceName: str, parameters: Dict[str, Any], parent: PySide6.QtCore.QObject
    ) -> PySide6.QtPositioning.QGeoSatelliteInfoSource:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#createSource

        **[static] QGeoSatelliteInfoSource
        *QGeoSatelliteInfoSource::createSource(const QString & sourceName ,
        QObject * parent )**

        Creates and returns a source with the given **parent** , by loading the
        plugin named **sourceName**.

        Returns `nullptr` if the plugin cannot be found.
        """
        ...

    @overload
    @staticmethod
    def createSource(
        sourceName: str, parent: PySide6.QtCore.QObject
    ) -> PySide6.QtPositioning.QGeoSatelliteInfoSource:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#createSource-1

        **[static, since Qt 5.14] QGeoSatelliteInfoSource
        *QGeoSatelliteInfoSource::createSource(const QString & sourceName ,
        const QVariantMap & parameters , QObject * parent )**

        Creates and returns a satellite source with the given **parent** , by
        loading the plugin named **sourceName**.

        Returns `nullptr` if the plugin cannot be found.

        This method passes **parameters** to the factory to configure the
        source.

        This function was introduced in Qt 5.14.
        """
        ...

    def error(self) -> PySide6.QtPositioning.QGeoSatelliteInfoSource.Error:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#error

        **[pure virtual] QGeoSatelliteInfoSource::Error
        QGeoSatelliteInfoSource::error() const**

        Returns the last error that occurred.

        **Note:** Since Qt6 the last error is always reset when calling
        **startUpdates** () or **requestUpdate** ().
        """
        ...

    def minimumUpdateInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#minimumUpdateInterva
        l-prop

        **[read-only] minimumUpdateInterval : const int**

        This property holds the minimum time (in milliseconds) required to
        retrieve a satellite update.

        This is the minimum value accepted by **setUpdateInterval** () and
        **requestUpdate** ().

        **Access functions:**

        virtual int **minimumUpdateInterval** () const = 0
        """
        ...

    def requestUpdate(self, timeout: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#requestUpdate

        **[pure virtual slot] void QGeoSatelliteInfoSource::requestUpdate(int
        timeout = 0)**

        Attempts to get the current satellite information and emit
        **satellitesInViewUpdated** () and **satellitesInUseUpdated** () with
        this information. If the current satellite information cannot be found
        within the given **timeout** (in milliseconds) or if **timeout** is less
        than the value returned by **minimumUpdateInterval** (), an
        **errorOccurred** () signal with **UpdateTimeoutError**  is emitted.

        If the timeout is zero, the timeout defaults to a reasonable timeout
        period as appropriate for the source.

        This does nothing if another update request is in progress. However it
        can be called even if **startUpdates** () has already been called and
        regular updates are in progress.

        **Note:** Since Qt6 this method always resets the last error to
        **NoError**  before requesting the satellite information.

        **Note:** To understand how to use this method from an Android service,
        see **Qt Positioning on Android** .
        """
        ...

    def setBackendProperty(self, name: str, value: Any) -> bool:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#setBackendProperty

        **[virtual, since 6.2] bool
        QGeoSatelliteInfoSource::setBackendProperty(const QString & name , const
        QVariant & value )**

        Sets the backend-specific property named **name** to **value**. Returns
        `true` on success, `false` otherwise. Backend-specific properties can be
        used to configure the satellite info subsystem behavior at runtime.

        This function was introduced in Qt 6.2.

        **See also** **backendProperty** .
        """
        ...

    def setUpdateInterval(self, msec: int) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#updateInterval-prop

        **[bindable] updateInterval : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the requested interval in milliseconds between each
        update.

        If the update interval is not set (or is set to 0) the source will
        provide updates as often as necessary.

        If the update interval is set, the source will provide updates at an
        interval as close to the requested interval as possible. If the
        requested interval is less than the **minimumUpdateInterval** (), the
        minimum interval is used instead.

        Changes to the update interval will happen as soon as is practical,
        however the time the change takes may vary between implementations.
        Whether or not the elapsed time from the previous interval is counted as
        part of the new interval is also implementation dependent.

        The default value for this property is 0.

        **Note:** Subclass implementations must call the base implementation of
        setUpdateInterval() so that updateInterval() returns the correct value.

        **Member Function Documentation**
        """
        ...

    def sourceName(self) -> str:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#sourceName

        **QString QGeoSatelliteInfoSource::sourceName() const**

        Returns the unique name of the satellite source implementation in use.

        This is the same name that can be passed to **createSource** () in order
        to create a new instance of a particular satellite source
        implementation.
        """
        ...

    def startUpdates(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#startUpdates

        **[pure virtual slot] void QGeoSatelliteInfoSource::startUpdates()**

        Starts emitting updates at regular intervals. The updates will be
        provided whenever new satellite information becomes available.

        If satellite information cannot be retrieved or some other form of
        timeout has occurred the **satellitesInViewUpdated** () and
        **satellitesInUseUpdated** () signals may be emitted with empty
        parameter lists.

        **Note:** Since Qt6 this method always resets the last error to
        **NoError**  before starting the updates.

        **Note:** To understand how to use this method from an Android service,
        see **Qt Positioning on Android** .

        **See also** **satellitesInViewUpdated** () and
        **satellitesInUseUpdated** ().
        """
        ...

    def stopUpdates(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#stopUpdates

        **[pure virtual slot] void QGeoSatelliteInfoSource::stopUpdates()**

        Stops emitting updates at regular intervals.
        """
        ...

    def updateInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#updateInterval-prop

        **[bindable] updateInterval : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the requested interval in milliseconds between each
        update.

        If the update interval is not set (or is set to 0) the source will
        provide updates as often as necessary.

        If the update interval is set, the source will provide updates at an
        interval as close to the requested interval as possible. If the
        requested interval is less than the **minimumUpdateInterval** (), the
        minimum interval is used instead.

        Changes to the update interval will happen as soon as is practical,
        however the time the change takes may vary between implementations.
        Whether or not the elapsed time from the previous interval is counted as
        part of the new interval is also implementation dependent.

        The default value for this property is 0.

        **Note:** Subclass implementations must call the base implementation of
        setUpdateInterval() so that updateInterval() returns the correct value.

        **Member Function Documentation**
        """
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#errorOccurred

        **[signal] void
        QGeoSatelliteInfoSource::errorOccurred(QGeoSatelliteInfoSource::Error
        satelliteError )**

        This signal is emitted after an error occurred. The **satelliteError**
        parameter describes the type of error that occurred.
        """
        ...

    @property
    def satellitesInUseUpdated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#satellitesInUseUpdat
        ed

        **[signal] void QGeoSatelliteInfoSource::satellitesInUseUpdated(const
        QList<QGeoSatelliteInfo> & satellites )**

        If **startUpdates** () or **requestUpdate** () is called, this signal is
        emitted when an update is available on the number of satellites that are
        currently in use.

        These are the satellites that are used to get a "fix" - that is, those
        used to determine the current position.

        The **satellites** parameter holds the satellites currently in use.
        """
        ...

    @property
    def satellitesInViewUpdated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfosource.html#satellitesInViewUpda
        ted

        **[signal] void QGeoSatelliteInfoSource::satellitesInViewUpdated(const
        QList<QGeoSatelliteInfo> & satellites )**

        If **startUpdates** () or **requestUpdate** () is called, this signal is
        emitted when an update is available on the satellites that are currently
        in view.

        The **satellites** parameter holds the satellites currently in view.
        """
        ...
