"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPositioning, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtPositioning

bytes = str


class QGeoSatelliteInfo(object):
    """
    https://doc.qt.io/qt-6/qgeosatelliteinfo.html

    **Detailed Description**

    **See also** **QGeoSatelliteInfoSource** .
    """

    Elevation: QGeoSatelliteInfo.Attribute = ...
    Azimuth: QGeoSatelliteInfo.Attribute = ...
    Undefined: QGeoSatelliteInfo.SatelliteSystem = ...
    GPS: QGeoSatelliteInfo.SatelliteSystem = ...
    GLONASS: QGeoSatelliteInfo.SatelliteSystem = ...
    GALILEO: QGeoSatelliteInfo.SatelliteSystem = ...
    BEIDOU: QGeoSatelliteInfo.SatelliteSystem = ...
    QZSS: QGeoSatelliteInfo.SatelliteSystem = ...
    Multiple: QGeoSatelliteInfo.SatelliteSystem = ...
    CustomType: QGeoSatelliteInfo.SatelliteSystem = ...

    class Attribute(Enum):
        Elevation: QGeoSatelliteInfo.Attribute = ...
        Azimuth: QGeoSatelliteInfo.Attribute = ...

    class SatelliteSystem(Enum):
        Undefined: QGeoSatelliteInfo.SatelliteSystem = ...
        GPS: QGeoSatelliteInfo.SatelliteSystem = ...
        GLONASS: QGeoSatelliteInfo.SatelliteSystem = ...
        GALILEO: QGeoSatelliteInfo.SatelliteSystem = ...
        BEIDOU: QGeoSatelliteInfo.SatelliteSystem = ...
        QZSS: QGeoSatelliteInfo.SatelliteSystem = ...
        Multiple: QGeoSatelliteInfo.SatelliteSystem = ...
        CustomType: QGeoSatelliteInfo.SatelliteSystem = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#QGeoSatelliteInfo

        **QGeoSatelliteInfo::QGeoSatelliteInfo()**

        Creates a satellite information object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtPositioning.QGeoSatelliteInfo) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#QGeoSatelliteInfo-1

        **QGeoSatelliteInfo::QGeoSatelliteInfo(const QGeoSatelliteInfo & other
        )**

        Creates a satellite information object with the values of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def attribute(
        self, attribute: PySide6.QtPositioning.QGeoSatelliteInfo.Attribute
    ) -> float:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#attribute

        **qreal QGeoSatelliteInfo::attribute(QGeoSatelliteInfo::Attribute
        attribute ) const**

        Returns the value of the specified **attribute** as a qreal value.

        Returns -1 if the value has not been set.

        **See also** **hasAttribute** () and **setAttribute** ().
        """
        ...

    def hasAttribute(
        self, attribute: PySide6.QtPositioning.QGeoSatelliteInfo.Attribute
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#hasAttribute

        **bool QGeoSatelliteInfo::hasAttribute(QGeoSatelliteInfo::Attribute
        attribute ) const**

        Returns true if the specified **attribute** is present in this update.
        """
        ...

    def removeAttribute(
        self, attribute: PySide6.QtPositioning.QGeoSatelliteInfo.Attribute
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#removeAttribute

        **void QGeoSatelliteInfo::removeAttribute(QGeoSatelliteInfo::Attribute
        attribute )**

        Removes the specified **attribute** and its value.
        """
        ...

    def satelliteIdentifier(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#satelliteIdentifier

        **int QGeoSatelliteInfo::satelliteIdentifier() const**

        Returns the satellite identifier number.

        The satellite identifier number can be used to identify a satellite
        within the satellite system.

        The actual value may vary, depending on the platform and the selected
        backend.

        For example, if **nmea** plugin is used, the satellite identifier for
        GPS satellite system represents the PRN (Pseudo-random noise) number,
        and the satellite identifier for GLONASS satellite system represents the
        slot number.

        For NMEA-based backends the satellite identifier can be used to
        determine the satellite system type if it is not available from other
        sources. You can refer to **satellite IDs list**  to check the ID ranges
        for different satellite systems.

        **Note:** Depending on the platform and the selected backend, the
        satellite identifier ranges for different satellite systems may
        intersect. To uniquely identify a satellite, a combination of
        satelliteIndetifier() and **satelliteSystem** () must be used.

        **See also** **setSatelliteIdentifier** () and **satelliteSystem** ().
        """
        ...

    def satelliteSystem(
        self,
    ) -> PySide6.QtPositioning.QGeoSatelliteInfo.SatelliteSystem:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#satelliteSystem

        **QGeoSatelliteInfo::SatelliteSystem
        QGeoSatelliteInfo::satelliteSystem() const**

        Returns the Satellite System (GPS, GLONASS, ...)

        **Note:** This value can be used together with **satelliteIdentifier**
        () to uniquely identify a satellite.

        **See also** **setSatelliteSystem** () and **satelliteIdentifier** ().
        """
        ...

    def setAttribute(
        self, attribute: PySide6.QtPositioning.QGeoSatelliteInfo.Attribute, value: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setAttribute

        **void QGeoSatelliteInfo::setAttribute(QGeoSatelliteInfo::Attribute
        attribute , qreal value )**

        Sets the value for **attribute** to **value**.

        **See also** **attribute** ().
        """
        ...

    def setSatelliteIdentifier(self, satId: int) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setSatelliteIdentifier

        **void QGeoSatelliteInfo::setSatelliteIdentifier(int satId )**

        Sets the satellite identifier number to **satId**.

        The satellite identifier number can be used to identify a satellite
        within the satellite system.

        The actual value may vary, depending on the platform and the selected
        backend.

        For example, if **nmea** plugin is used, the satellite identifier for
        GPS satellite system represents the PRN (Pseudo-random noise) number,
        and the satellite identifier for GLONASS satellite system represents the
        slot number.

        **See also** **satelliteIdentifier** ().
        """
        ...

    def setSatelliteSystem(
        self, system: PySide6.QtPositioning.QGeoSatelliteInfo.SatelliteSystem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setSatelliteSystem

        **void
        QGeoSatelliteInfo::setSatelliteSystem(QGeoSatelliteInfo::SatelliteSystem
        system )**

        Sets the Satellite System (GPS, GLONASS, ...) to **system**.

        **See also** **satelliteSystem** ().
        """
        ...

    def setSignalStrength(self, signalStrength: int) -> None:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#setSignalStrength

        **void QGeoSatelliteInfo::setSignalStrength(int signalStrength )**

        Sets the signal strength to **signalStrength** , in decibels.

        **See also** **signalStrength** ().
        """
        ...

    def signalStrength(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeosatelliteinfo.html#signalStrength

        **int QGeoSatelliteInfo::signalStrength() const**

        Returns the signal strength, or -1 if the value has not been set.

        **See also** **setSignalStrength** ().
        """
        ...

    def swap(self, other: PySide6.QtPositioning.QGeoSatelliteInfo) -> None:
        ...
