"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPositioning, except for defaults which are replaced by "...".
"""
from typing import Any, List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtPositioning

bytes = str


class QGeoPath(PySide6.QtPositioning.QGeoShape):
    """
    https://doc.qt.io/qt-6/qgeopath.html

    **Detailed Description**

    The path is defined by an ordered list of **QGeoCoordinate**  objects.

    Each two adjacent elements in the path are intended to be connected together
    by the shortest line segment of constant bearing passing through both
    elements. This type of connection can cross the dateline in the longitudinal
    direction, but never crosses the poles.

    This is relevant for the calculation of the bounding box returned by
    **QGeoShape::boundingGeoRectangle** () for this shape, which will have the
    latitude of the top left corner set to the maximum latitude in the path
    point set. Similarly, the latitude of the bottom right corner will be the
    minimum latitude in the path point set.

    This class is a **Q_GADGET** . It can be **directly used from C++ and QML**
    .

    A QGeoPath is both invalid and empty if it contains no coordinate.

    **Note:** A default constructed QGeoPath is both invalid and empty as it
    does not contain any coordinates.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#QGeoPath

        **QGeoPath::QGeoPath()**

        Constructs a new, empty geo path.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtPositioning.QGeoShape) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#QGeoPath-1

        **QGeoPath::QGeoPath(const QList<QGeoCoordinate> & path , const qreal &
        width = 0.0)**

        Constructs a new geo path from a list of coordinates ( **path** and
        **width** ).
        """
        ...

    @overload
    def __init__(
        self,
        other: Union[
            PySide6.QtPositioning.QGeoShape,
            Sequence[PySide6.QtPositioning.QGeoCoordinate],
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#QGeoPath-2

        **QGeoPath::QGeoPath(const QGeoPath & other )**

        Constructs a new geo path from the contents of **other**.
        """
        ...

    @overload
    def __init__(
        self, path: Sequence[PySide6.QtPositioning.QGeoCoordinate], width: float = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#QGeoPath-3

        **QGeoPath::QGeoPath(const QGeoShape & other )**

        Constructs a new geo path from the contents of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def addCoordinate(self, coordinate: PySide6.QtPositioning.QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#addCoordinate

        **[invokable] void QGeoPath::addCoordinate(const QGeoCoordinate &
        coordinate )**

        Appends **coordinate** to the path.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def clearPath(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#clearPath

        **[since 5.12] void QGeoPath::clearPath()**

        Clears the path.

        This function was introduced in Qt 5.12.
        """
        ...

    def containsCoordinate(
        self, coordinate: PySide6.QtPositioning.QGeoCoordinate
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgeopath.html#containsCoordinate

        **[invokable] bool QGeoPath::containsCoordinate(const QGeoCoordinate &
        coordinate ) const**

        Returns true if the path contains **coordinate** as one of the elements.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def coordinateAt(self, index: int) -> PySide6.QtPositioning.QGeoCoordinate:
        """
        https://doc.qt.io/qt-6/qgeopath.html#coordinateAt

        **[invokable] QGeoCoordinate QGeoPath::coordinateAt(qsizetype index )
        const**

        Returns the coordinate at **index** .

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def insertCoordinate(
        self, index: int, coordinate: PySide6.QtPositioning.QGeoCoordinate
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#insertCoordinate

        **[invokable] void QGeoPath::insertCoordinate(qsizetype index , const
        QGeoCoordinate & coordinate )**

        Inserts **coordinate** at the specified **index**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def length(self, indexFrom: int = ..., indexTo: int = ...) -> float:
        """
        https://doc.qt.io/qt-6/qgeopath.html#length

        **[invokable] double QGeoPath::length(qsizetype indexFrom = 0, qsizetype
        indexTo = -1) const**

        Returns the length of the path, in meters, from the element
        **indexFrom** to the element **indexTo**. The length is intended to be
        the sum of the shortest distances for each pair of adjacent points.

        If **indexTo** is -1 (the default value), the length will be including
        the distance between last coordinate and the first (closed loop). To
        retrieve the length for the path, use 0 for **indexFrom** and
        **QGeoPath::size** () - 1 for **indexTo**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def path(self) -> List[PySide6.QtPositioning.QGeoCoordinate]:
        """
        https://doc.qt.io/qt-6/qgeopath.html#path

        **const QList<QGeoCoordinate> &QGeoPath::path() const**

        Returns all the elements of the path.

        **See also** **setPath** ().
        """
        ...

    @overload
    def removeCoordinate(
        self, coordinate: PySide6.QtPositioning.QGeoCoordinate
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#removeCoordinate

        **[invokable] void QGeoPath::removeCoordinate(const QGeoCoordinate &
        coordinate )**

        Removes the last occurrence of **coordinate** from the path.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @overload
    def removeCoordinate(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#removeCoordinate-1

        **[invokable] void QGeoPath::removeCoordinate(qsizetype index )**

        Removes element at position **index** from the path.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def replaceCoordinate(
        self, index: int, coordinate: PySide6.QtPositioning.QGeoCoordinate
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#replaceCoordinate

        **[invokable] void QGeoPath::replaceCoordinate(qsizetype index , const
        QGeoCoordinate & coordinate )**

        Replaces the path element at the specified **index** with
        **coordinate**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def setPath(self, path: Sequence[PySide6.QtPositioning.QGeoCoordinate]) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#setPath

        **void QGeoPath::setPath(const QList<QGeoCoordinate> & path )**

        Sets all the elements of the **path**.

        **See also** **path** ().
        """
        ...

    def setVariantPath(self, path: Sequence[Any]) -> None:
        ...

    def setWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#width

        **qreal QGeoPath::width() const**

        Returns the width of the path, in meters. This information is used in
        the **contains**  method. The default value is 0.

        **Note:** Getter function for property **width** .

        **See also** **setWidth** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qgeopath.html#size

        **[invokable, since 5.10] qsizetype QGeoPath::size() const**

        Returns the number of elements in the path.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.10.
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qgeopath.html#toString

        **[invokable] QString QGeoPath::toString() const**

        Returns the geo path properties as a string.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None:
        """
        https://doc.qt.io/qt-6/qgeopath.html#translate

        **[invokable] void QGeoPath::translate(double degreesLatitude , double
        degreesLongitude )**

        Translates this geo path by **degreesLatitude** northwards and
        **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def translated(
        self, degreesLatitude: float, degreesLongitude: float
    ) -> PySide6.QtPositioning.QGeoPath:
        """
        https://doc.qt.io/qt-6/qgeopath.html#translated

        **[invokable] QGeoPath QGeoPath::translated(double degreesLatitude ,
        double degreesLongitude ) const**

        Returns a copy of this geo path translated by **degreesLatitude**
        northwards and **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **translate** ().
        """
        ...

    def variantPath(self) -> List[Any]:
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-6/qgeopath.html#width-prop

        **width : qreal**

        This property holds the width of the path in meters.

        **Access functions:**

        qreal ****width** ** () const
        void **setWidth** (const qreal &
        **width** )

        **Member Function Documentation**
        """
        ...
