"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGL, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL

bytes = str


class QOpenGLShader(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qopenglshader.html

    **Detailed Description**

    This class supports shaders written in the OpenGL Shading Language (GLSL)
    and in the OpenGL/ES Shading Language (GLSL/ES).

    QOpenGLShader and **QOpenGLShaderProgram**  shelter the programmer from the
    details of compiling and linking vertex and fragment shaders.

    **See also** **QOpenGLShaderProgram** .
    """

    Vertex: QOpenGLShader.ShaderTypeBit = ...
    Fragment: QOpenGLShader.ShaderTypeBit = ...
    Geometry: QOpenGLShader.ShaderTypeBit = ...
    TessellationControl: QOpenGLShader.ShaderTypeBit = ...
    TessellationEvaluation: QOpenGLShader.ShaderTypeBit = ...
    Compute: QOpenGLShader.ShaderTypeBit = ...

    class ShaderType(object):
        ...

    class ShaderTypeBit(Enum):
        Vertex: QOpenGLShader.ShaderTypeBit = ...
        Fragment: QOpenGLShader.ShaderTypeBit = ...
        Geometry: QOpenGLShader.ShaderTypeBit = ...
        TessellationControl: QOpenGLShader.ShaderTypeBit = ...
        TessellationEvaluation: QOpenGLShader.ShaderTypeBit = ...
        Compute: QOpenGLShader.ShaderTypeBit = ...

    def __init__(
        self,
        type: PySide6.QtOpenGL.QOpenGLShader.ShaderType,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#QOpenGLShader

        **QOpenGLShader::QOpenGLShader(QOpenGLShader::ShaderType type , QObject
        * parent = nullptr)**

        Constructs a new QOpenGLShader object of the specified **type** and
        attaches it to **parent**. If shader programs are not supported,
        **QOpenGLShaderProgram::hasOpenGLShaderPrograms** () will return false.

        This constructor is normally followed by a call to **compileSourceCode**
        () or **compileSourceFile** ().

        The shader will be associated with the current **QOpenGLContext** .

        **See also** **compileSourceCode** () and **compileSourceFile** ().
        """
        ...

    @overload
    def compileSourceCode(self, source: str) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#compileSourceCode

        **bool QOpenGLShader::compileSourceCode(const char * source )**

        Sets the **source** code for this shader and compiles it. Returns `true`
        if the source was successfully compiled, false otherwise.

        **See also** **compileSourceFile** ().
        """
        ...

    @overload
    def compileSourceCode(self, source: bytes) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#compileSourceCode-1

        **bool QOpenGLShader::compileSourceCode(const QByteArray & source )**

        This is an overloaded function.

        Sets the **source** code for this shader and compiles it. Returns `true`
        if the source was successfully compiled, false otherwise.

        **See also** **compileSourceFile** ().
        """
        ...

    @overload
    def compileSourceCode(
        self, source: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#compileSourceCode-2

        **bool QOpenGLShader::compileSourceCode(const QString & source )**

        This is an overloaded function.

        Sets the **source** code for this shader and compiles it. Returns `true`
        if the source was successfully compiled, false otherwise.

        **See also** **compileSourceFile** ().
        """
        ...

    def compileSourceFile(self, fileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#compileSourceFile

        **bool QOpenGLShader::compileSourceFile(const QString & fileName )**

        Sets the source code for this shader to the contents of **fileName** and
        compiles it. Returns `true` if the file could be opened and the source
        compiled, false otherwise.

        **See also** **compileSourceCode** ().
        """
        ...

    @staticmethod
    def hasOpenGLShaders(
        type: PySide6.QtOpenGL.QOpenGLShader.ShaderType,
        context: Optional[PySide6.QtGui.QOpenGLContext] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#hasOpenGLShaders

        **[static] bool
        QOpenGLShader::hasOpenGLShaders(QOpenGLShader::ShaderType type ,
        QOpenGLContext * context = nullptr)**

        Returns `true` if shader programs of type **type** are supported on this
        system; false otherwise.

        The **context** is used to resolve the GLSL extensions. If **context**
        is `nullptr`, then **QOpenGLContext::currentContext** () is used.
        """
        ...

    def isCompiled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#isCompiled

        **bool QOpenGLShader::isCompiled() const**

        Returns `true` if this shader has been compiled; false otherwise.

        **See also** **compileSourceCode** () and **compileSourceFile** ().
        """
        ...

    def log(self) -> str:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#log

        **QString QOpenGLShader::log() const**

        Returns the errors and warnings that occurred during the last compile.

        **See also** **compileSourceCode** () and **compileSourceFile** ().
        """
        ...

    def shaderId(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#shaderId

        **GLuint QOpenGLShader::shaderId() const**

        Returns the OpenGL identifier associated with this shader.

        **See also** **QOpenGLShaderProgram::programId** ().
        """
        ...

    def shaderType(self) -> PySide6.QtOpenGL.QOpenGLShader.ShaderType:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#shaderType

        **QOpenGLShader::ShaderType QOpenGLShader::shaderType() const**

        Returns the type of this shader.
        """
        ...

    def sourceCode(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qopenglshader.html#sourceCode

        **QByteArray QOpenGLShader::sourceCode() const**

        Returns the source code for this shader.

        **See also** **compileSourceCode** ().
        """
        ...
