"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGL, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL

bytes = str


class QOpenGLDebugMessage(object):
    """
    https://doc.qt.io/qt-6/qopengldebugmessage.html

    **Detailed Description**

    Debug messages are usually created by the OpenGL server and then read by
    OpenGL clients (either from the OpenGL internal debug log, or logged in
    real-time). A debug message has a textual representation, a vendor-specific
    numeric id, a source, a type and a severity.

    It's also possible for applications or third-party libraries and toolkits to
    create and insert messages in the debug log. In order to do so, you can use
    the **createApplicationMessage** () or the **createThirdPartyMessage** ()
    static functions.

    **See also** **QOpenGLDebugLogger** .
    """

    AnySeverity: QOpenGLDebugMessage.Severity = ...
    InvalidSeverity: QOpenGLDebugMessage.Severity = ...
    HighSeverity: QOpenGLDebugMessage.Severity = ...
    MediumSeverity: QOpenGLDebugMessage.Severity = ...
    LowSeverity: QOpenGLDebugMessage.Severity = ...
    LastSeverity: QOpenGLDebugMessage.Severity = ...
    NotificationSeverity: QOpenGLDebugMessage.Severity = ...
    AnySource: QOpenGLDebugMessage.Source = ...
    InvalidSource: QOpenGLDebugMessage.Source = ...
    APISource: QOpenGLDebugMessage.Source = ...
    WindowSystemSource: QOpenGLDebugMessage.Source = ...
    ShaderCompilerSource: QOpenGLDebugMessage.Source = ...
    ThirdPartySource: QOpenGLDebugMessage.Source = ...
    ApplicationSource: QOpenGLDebugMessage.Source = ...
    LastSource: QOpenGLDebugMessage.Source = ...
    OtherSource: QOpenGLDebugMessage.Source = ...
    AnyType: QOpenGLDebugMessage.Type = ...
    InvalidType: QOpenGLDebugMessage.Type = ...
    ErrorType: QOpenGLDebugMessage.Type = ...
    DeprecatedBehaviorType: QOpenGLDebugMessage.Type = ...
    UndefinedBehaviorType: QOpenGLDebugMessage.Type = ...
    PortabilityType: QOpenGLDebugMessage.Type = ...
    PerformanceType: QOpenGLDebugMessage.Type = ...
    OtherType: QOpenGLDebugMessage.Type = ...
    MarkerType: QOpenGLDebugMessage.Type = ...
    GroupPushType: QOpenGLDebugMessage.Type = ...
    GroupPopType: QOpenGLDebugMessage.Type = ...
    LastType: QOpenGLDebugMessage.Type = ...

    class Severities(object):
        ...

    class Severity(Enum):
        AnySeverity: QOpenGLDebugMessage.Severity = ...
        InvalidSeverity: QOpenGLDebugMessage.Severity = ...
        HighSeverity: QOpenGLDebugMessage.Severity = ...
        MediumSeverity: QOpenGLDebugMessage.Severity = ...
        LowSeverity: QOpenGLDebugMessage.Severity = ...
        LastSeverity: QOpenGLDebugMessage.Severity = ...
        NotificationSeverity: QOpenGLDebugMessage.Severity = ...

    class Source(Enum):
        AnySource: QOpenGLDebugMessage.Source = ...
        InvalidSource: QOpenGLDebugMessage.Source = ...
        APISource: QOpenGLDebugMessage.Source = ...
        WindowSystemSource: QOpenGLDebugMessage.Source = ...
        ShaderCompilerSource: QOpenGLDebugMessage.Source = ...
        ThirdPartySource: QOpenGLDebugMessage.Source = ...
        ApplicationSource: QOpenGLDebugMessage.Source = ...
        LastSource: QOpenGLDebugMessage.Source = ...
        OtherSource: QOpenGLDebugMessage.Source = ...

    class Sources(object):
        ...

    class Type(Enum):
        AnyType: QOpenGLDebugMessage.Type = ...
        InvalidType: QOpenGLDebugMessage.Type = ...
        ErrorType: QOpenGLDebugMessage.Type = ...
        DeprecatedBehaviorType: QOpenGLDebugMessage.Type = ...
        UndefinedBehaviorType: QOpenGLDebugMessage.Type = ...
        PortabilityType: QOpenGLDebugMessage.Type = ...
        PerformanceType: QOpenGLDebugMessage.Type = ...
        OtherType: QOpenGLDebugMessage.Type = ...
        MarkerType: QOpenGLDebugMessage.Type = ...
        GroupPushType: QOpenGLDebugMessage.Type = ...
        GroupPopType: QOpenGLDebugMessage.Type = ...
        LastType: QOpenGLDebugMessage.Type = ...

    class Types(object):
        ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#QOpenGLDebugMessage

        **QOpenGLDebugMessage::QOpenGLDebugMessage()**

        Constructs a debug message with an empty message string, id set to 0,
        source set to **InvalidSource** , type set to **InvalidType** , and
        severity set to **InvalidSeverity** .

        **Note:** This constructor should not be used to create a debug message;
        instead, use the **createApplicationMessage** () or the
        **createThirdPartyMessage** () static functions.

        **See also** **createApplicationMessage** () and
        **createThirdPartyMessage** ().
        """
        ...

    @overload
    def __init__(self, debugMessage: PySide6.QtOpenGL.QOpenGLDebugMessage) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#QOpenGLDebugMessage-1

        **QOpenGLDebugMessage::QOpenGLDebugMessage(const QOpenGLDebugMessage &
        debugMessage )**

        Constructs a debug message as a copy of **debugMessage**.

        **See also** **operator=** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def createApplicationMessage(
        text: str,
        id: int = ...,
        severity: PySide6.QtOpenGL.QOpenGLDebugMessage.Severity = ...,
        type: PySide6.QtOpenGL.QOpenGLDebugMessage.Type = ...,
    ) -> PySide6.QtOpenGL.QOpenGLDebugMessage:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#createApplicationMessage

        **[static] QOpenGLDebugMessage
        QOpenGLDebugMessage::createApplicationMessage(const QString & text ,
        GLuint id = 0, QOpenGLDebugMessage::Severity severity =
        NotificationSeverity, QOpenGLDebugMessage::Type type = OtherType)**

        Constructs and returns a debug message with **text** as its text, **id**
        as id, **severity** as severity, and **type** as type. The message
        source will be set to **ApplicationSource** .

        **See also** **QOpenGLDebugLogger::logMessage** () and
        **createThirdPartyMessage** ().
        """
        ...

    @staticmethod
    def createThirdPartyMessage(
        text: str,
        id: int = ...,
        severity: PySide6.QtOpenGL.QOpenGLDebugMessage.Severity = ...,
        type: PySide6.QtOpenGL.QOpenGLDebugMessage.Type = ...,
    ) -> PySide6.QtOpenGL.QOpenGLDebugMessage:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#createThirdPartyMessage

        **[static] QOpenGLDebugMessage
        QOpenGLDebugMessage::createThirdPartyMessage(const QString & text ,
        GLuint id = 0, QOpenGLDebugMessage::Severity severity =
        NotificationSeverity, QOpenGLDebugMessage::Type type = OtherType)**

        Constructs and returns a debug message with **text** as its text, **id**
        as id, **severity** as severity, and **type** as type. The message
        source will be set to **ThirdPartySource** .

        **See also** **QOpenGLDebugLogger::logMessage** () and
        **createApplicationMessage** ().
        """
        ...

    def id(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#id

        **GLuint QOpenGLDebugMessage::id() const**

        Returns the id of the debug message. Ids are generally vendor-specific.
        """
        ...

    def message(self) -> str:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#message

        **QString QOpenGLDebugMessage::message() const**

        Returns the textual message contained by this debug message.
        """
        ...

    def severity(self) -> PySide6.QtOpenGL.QOpenGLDebugMessage.Severity:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#severity

        **QOpenGLDebugMessage::Severity QOpenGLDebugMessage::severity() const**

        Returns the severity of the debug message.
        """
        ...

    def source(self) -> PySide6.QtOpenGL.QOpenGLDebugMessage.Source:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#source

        **QOpenGLDebugMessage::Source QOpenGLDebugMessage::source() const**

        Returns the source of the debug message.
        """
        ...

    def swap(self, other: PySide6.QtOpenGL.QOpenGLDebugMessage) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#swap

        **void QOpenGLDebugMessage::swap(QOpenGLDebugMessage & debugMessage )**

        Swaps the message **debugMessage** with this message. This operation is
        very fast and never fails.
        """
        ...

    def type(self) -> PySide6.QtOpenGL.QOpenGLDebugMessage.Type:
        """
        https://doc.qt.io/qt-6/qopengldebugmessage.html#type

        **QOpenGLDebugMessage::Type QOpenGLDebugMessage::type() const**

        Returns the type of the debug message.
        """
        ...
