"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetworkAuth, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, Union
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtNetworkAuth

bytes = str


class QAbstractOAuth(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstractoauth.html

    **Detailed Description**

    The class defines the basic interface of the OAuth authentication classes.
    By inheriting this class, you can create custom authentication methods for
    different web services.

    It also contains some functions to ease the process of implementing
    different authentication flows.
    """

    class ContentType(Enum):
        WwwFormUrlEncoded: QAbstractOAuth.ContentType = ...
        Json: QAbstractOAuth.ContentType = ...

    class Error(Enum):
        NoError: QAbstractOAuth.Error = ...
        NetworkError: QAbstractOAuth.Error = ...
        ServerError: QAbstractOAuth.Error = ...
        OAuthTokenNotFoundError: QAbstractOAuth.Error = ...
        OAuthTokenSecretNotFoundError: QAbstractOAuth.Error = ...
        OAuthCallbackNotVerified: QAbstractOAuth.Error = ...

    class Stage(Enum):
        RequestingTemporaryCredentials: QAbstractOAuth.Stage = ...
        RequestingAuthorization: QAbstractOAuth.Stage = ...
        RequestingAccessToken: QAbstractOAuth.Stage = ...
        RefreshingAccessToken: QAbstractOAuth.Stage = ...

    class Status(Enum):
        NotAuthenticated: QAbstractOAuth.Status = ...
        TemporaryCredentialsReceived: QAbstractOAuth.Status = ...
        Granted: QAbstractOAuth.Status = ...
        RefreshingToken: QAbstractOAuth.Status = ...

    def authorizationUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#authorizationUrl

        **QUrl QAbstractOAuth::authorizationUrl() const**

        Returns the authorization request URL.

        **Note:** Getter function for property authorizationUrl.

        **See also** **setAuthorizationUrl** ().
        """
        ...

    def callback(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#callback

        **[protected] QString QAbstractOAuth::callback() const**

        Returns the current callback string corresponding to the current reply
        handler. The returned string is the string sent to the server to specify
        the callback URI, or the word identifying the alternative method in
        headless devices.

        **See also** **replyHandler** () and **setReplyHandler** ().
        """
        ...

    def clientIdentifier(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#clientIdentifier

        **QString QAbstractOAuth::clientIdentifier() const**

        Returns the current client identifier used in the authentication
        process.

        **Note:** Getter function for property clientIdentifier.

        **See also** **setClientIdentifier** ().
        """
        ...

    def contentType(self) -> PySide6.QtNetworkAuth.QAbstractOAuth.ContentType:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#contentType

        **QAbstractOAuth::ContentType QAbstractOAuth::contentType() const**

        Returns the current Content-Type used in authenticated calls.

        **Note:** Getter function for property contentType.

        **See also** **setContentType** () and **post** ().
        """
        ...

    def deleteResource(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#deleteResource

        **[pure virtual invokable] QNetworkReply
        *QAbstractOAuth::deleteResource(const QUrl & url , const QVariantMap &
        parameters = QVariantMap())**

        Sends an authenticated DELETE request and returns a new
        **QNetworkReply** . The **url** and **parameters** are used to create
        the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: DELETE**

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def extraTokens(self) -> Dict[str, Any]:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#extraTokens

        **QVariantMap QAbstractOAuth::extraTokens() const**

        Returns the extra tokens received from the server during authentication.

        **Note:** Getter function for property extraTokens.

        **See also** **extraTokensChanged** ().
        """
        ...

    @staticmethod
    def generateRandomString(length: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#generateRandomString

        **[static protected] QByteArray
        QAbstractOAuth::generateRandomString(quint8 length )**

        Generates a random string which could be used as state or nonce. The
        parameter **length** determines the size of the generated string.

        **See also**  : **The OAuth 1.0 Protocol: Nonce and Timestamp** .
        """
        ...

    def get(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#get

        **[pure virtual invokable] QNetworkReply *QAbstractOAuth::get(const QUrl
        & url , const QVariantMap & parameters = QVariantMap())**

        Sends an authenticated GET request and returns a new **QNetworkReply** .
        The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: GET**

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def grant(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#grant

        **[pure virtual slot] void QAbstractOAuth::grant()**

        Override this function to implement the corresponding authentication
        flow in the subclasses. Client code calls this function to start the
        authentication workflow. This may require user interaction: for example,
        asking the user's authorization via a web browser. When the
        authentication succeeds, it should emit **granted** (); this gives
        notice that credentials are ready to be used in authenticated calls.
        """
        ...

    def head(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#head

        **[pure virtual invokable] QNetworkReply *QAbstractOAuth::head(const
        QUrl & url , const QVariantMap & parameters = QVariantMap())**

        Sends an authenticated HEAD request and returns a new **QNetworkReply**
        . The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: HEAD**

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def networkAccessManager(self) -> PySide6.QtNetwork.QNetworkAccessManager:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#networkAccessManager

        **QNetworkAccessManager *QAbstractOAuth::networkAccessManager() const**

        Returns the current network access manager used to send the requests to
        the server during authentication flows or to make authentication calls.

        **See also** **setNetworkAccessManager** () and
        **QNetworkAccessManager** .
        """
        ...

    def post(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#post

        **[pure virtual invokable] QNetworkReply *QAbstractOAuth::post(const
        QUrl & url , const QVariantMap & parameters = QVariantMap())**

        Sends an authenticated POST request and returns a new **QNetworkReply**
        . The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: POST**

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def prepareRequest(
        self,
        request: PySide6.QtNetwork.QNetworkRequest,
        verb: Union[PySide6.QtCore.QByteArray, bytes],
        body: Union[PySide6.QtCore.QByteArray, bytes] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#prepareRequest

        **[pure virtual, since 5.13] void
        QAbstractOAuth::prepareRequest(QNetworkRequest * request , const
        QByteArray & verb , const QByteArray & body = QByteArray())**

        Authorizes the given **request** by adding a header and **body** to it
        required for authenticated requests.

        The **verb** must be a valid HTTP verb and the same as the one that will
        be used to send the **request**.

        This function was introduced in Qt 5.13.
        """
        ...

    def put(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> PySide6.QtNetwork.QNetworkReply:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#put

        **[pure virtual invokable] QNetworkReply *QAbstractOAuth::put(const QUrl
        & url , const QVariantMap & parameters = QVariantMap())**

        Sends an authenticated PUT request and returns a new **QNetworkReply** .
        The **url** and **parameters** are used to create the request.

        **See also**  : **Hypertext Transfer Protocol -- HTTP/1.1: PUT**

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def replyHandler(self) -> PySide6.QtNetworkAuth.QAbstractOAuthReplyHandler:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#replyHandler

        **QAbstractOAuthReplyHandler *QAbstractOAuth::replyHandler() const**

        Returns the reply handler currently in use.

        **See also** **setReplyHandler** () and **QAbstractOAuthReplyHandler** .
        """
        ...

    def resourceOwnerAuthorization(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#resourceOwnerAuthorization

        **[virtual protected] void
        QAbstractOAuth::resourceOwnerAuthorization(const QUrl & url , const
        QMultiMap<QString, QVariant> & parameters )**

        Builds the resource owner authorization URL to be used in the web
        browser: **url** is used as the base URL and the query is created using
        **parameters**. When the URL is ready, the **authorizeWithBrowser** ()
        signal will be emitted with the generated URL.

        **See also** **authorizeWithBrowser** ().
        """
        ...

    def setAuthorizationUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#setAuthorizationUrl

        **void QAbstractOAuth::setAuthorizationUrl(const QUrl & url )**

        Sets the authorization request URL to **url**. This address will be used
        to allow the user to grant the application the ability to make
        authenticated calls on behalf of the user.

        **Note:** Setter function for property **authorizationUrl** .

        **See also** **authorizationUrl** ().
        """
        ...

    def setClientIdentifier(self, clientIdentifier: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#setClientIdentifier

        **void QAbstractOAuth::setClientIdentifier(const QString &
        clientIdentifier )**

        Sets the current client identifier to **clientIdentifier**.

        **Note:** Setter function for property **clientIdentifier** .

        **See also** **clientIdentifier** ().
        """
        ...

    def setContentType(
        self, contentType: PySide6.QtNetworkAuth.QAbstractOAuth.ContentType
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#setContentType

        **void QAbstractOAuth::setContentType(QAbstractOAuth::ContentType
        contentType )**

        Sets the current Content-Type to **contentType**.

        **Note:** Setter function for property **contentType** .

        **See also** **contentType** ().
        """
        ...

    def setNetworkAccessManager(
        self, networkAccessManager: PySide6.QtNetwork.QNetworkAccessManager
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#setNetworkAccessManager

        **void QAbstractOAuth::setNetworkAccessManager(QNetworkAccessManager *
        networkAccessManager )**

        Sets the network manager to **networkAccessManager**. **QAbstractOAuth**
        does not take ownership of **networkAccessManager**. If no custom
        network access manager is set, an internal network access manager is
        used. This network access manager will be used to make the request to
        the authentication server and the authenticated request to the web
        service.

        **See also** **networkAccessManager** () and **QNetworkAccessManager** .
        """
        ...

    def setReplyHandler(
        self, handler: PySide6.QtNetworkAuth.QAbstractOAuthReplyHandler
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#setReplyHandler

        **void QAbstractOAuth::setReplyHandler(QAbstractOAuthReplyHandler *
        handler )**

        Sets the current reply handler to **handler**.

        **Note:** Does not take ownership of **handler**.

        **See also** **replyHandler** ().
        """
        ...

    def setStatus(self, status: PySide6.QtNetworkAuth.QAbstractOAuth.Status) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#setStatus

        **[protected] void QAbstractOAuth::setStatus(QAbstractOAuth::Status
        status )**

        Sets the current status to **status**. This method is for use by classes
        based on **QAbstractOAuth** .

        **See also** **status** ().
        """
        ...

    def setToken(self, token: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#setToken

        **void QAbstractOAuth::setToken(const QString & token )**

        Sets the token used to sign authenticated requests to **token**.

        **Note:** Setter function for property **token** .

        **See also** **token** ().
        """
        ...

    def status(self) -> PySide6.QtNetworkAuth.QAbstractOAuth.Status:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#status

        **QAbstractOAuth::Status QAbstractOAuth::status() const**

        Returns the current authentication status.

        **Note:** Getter function for property status.

        **See also** **setStatus** () and **Status** .
        """
        ...

    def token(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#token

        **QString QAbstractOAuth::token() const**

        Returns the token used to sign the authenticated requests.

        **Note:** Getter function for property token.

        **See also** **setToken** ().
        """
        ...

    @property
    def authorizationUrlChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def authorizeWithBrowser(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#authorizeWithBrowser

        **[signal] void QAbstractOAuth::authorizeWithBrowser(const QUrl & url
        )**

        This signal is emitted when the **url** generated by
        **resourceOwnerAuthorization** () is ready to be used in the web browser
        to allow the application to impersonate the user.

        **See also** **resourceOwnerAuthorization** ().
        """
        ...

    @property
    def contentTypeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def extraTokensChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def granted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractoauth.html#granted

        **[signal] void QAbstractOAuth::granted()**

        This signal is emitted when the authorization flow finishes
        successfully.
        """
        ...

    @property
    def statusChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
