"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum

bytes = str


class QSsl(object):
    """
    https://doc.qt.io/qt-6/qssl.html

    **Detailed Description**
    """

    EmailEntry: QSsl.AlternativeNameEntryType = ...
    DnsEntry: QSsl.AlternativeNameEntryType = ...
    IpAddressEntry: QSsl.AlternativeNameEntryType = ...
    Pem: QSsl.EncodingFormat = ...
    Der: QSsl.EncodingFormat = ...
    Opaque: QSsl.KeyAlgorithm = ...
    Rsa: QSsl.KeyAlgorithm = ...
    Dsa: QSsl.KeyAlgorithm = ...
    Ec: QSsl.KeyAlgorithm = ...
    Dh: QSsl.KeyAlgorithm = ...
    PrivateKey: QSsl.KeyType = ...
    PublicKey: QSsl.KeyType = ...
    SslOptionDisableEmptyFragments: QSsl.SslOption = ...
    SslOptionDisableSessionTickets: QSsl.SslOption = ...
    SslOptionDisableCompression: QSsl.SslOption = ...
    SslOptionDisableServerNameIndication: QSsl.SslOption = ...
    SslOptionDisableLegacyRenegotiation: QSsl.SslOption = ...
    SslOptionDisableSessionSharing: QSsl.SslOption = ...
    SslOptionDisableSessionPersistence: QSsl.SslOption = ...
    SslOptionDisableServerCipherPreference: QSsl.SslOption = ...
    UnknownProtocol: QSsl.SslProtocol = ...
    TlsV1_0: QSsl.SslProtocol = ...
    TlsV1_1: QSsl.SslProtocol = ...
    TlsV1_2: QSsl.SslProtocol = ...
    AnyProtocol: QSsl.SslProtocol = ...
    SecureProtocols: QSsl.SslProtocol = ...
    TlsV1_0OrLater: QSsl.SslProtocol = ...
    TlsV1_1OrLater: QSsl.SslProtocol = ...
    TlsV1_2OrLater: QSsl.SslProtocol = ...
    DtlsV1_0: QSsl.SslProtocol = ...
    DtlsV1_0OrLater: QSsl.SslProtocol = ...
    DtlsV1_2: QSsl.SslProtocol = ...
    DtlsV1_2OrLater: QSsl.SslProtocol = ...
    TlsV1_3: QSsl.SslProtocol = ...
    TlsV1_3OrLater: QSsl.SslProtocol = ...

    class AlertLevel(Enum):
        Warning: QSsl.AlertLevel = ...
        Fatal: QSsl.AlertLevel = ...
        Unknown: QSsl.AlertLevel = ...

    class AlertType(Enum):
        CloseNotify: QSsl.AlertType = ...
        UnexpectedMessage: QSsl.AlertType = ...
        BadRecordMac: QSsl.AlertType = ...
        RecordOverflow: QSsl.AlertType = ...
        DecompressionFailure: QSsl.AlertType = ...
        HandshakeFailure: QSsl.AlertType = ...
        NoCertificate: QSsl.AlertType = ...
        BadCertificate: QSsl.AlertType = ...
        UnsupportedCertificate: QSsl.AlertType = ...
        CertificateRevoked: QSsl.AlertType = ...
        CertificateExpired: QSsl.AlertType = ...
        CertificateUnknown: QSsl.AlertType = ...
        IllegalParameter: QSsl.AlertType = ...
        UnknownCa: QSsl.AlertType = ...
        AccessDenied: QSsl.AlertType = ...
        DecodeError: QSsl.AlertType = ...
        DecryptError: QSsl.AlertType = ...
        ExportRestriction: QSsl.AlertType = ...
        ProtocolVersion: QSsl.AlertType = ...
        InsufficientSecurity: QSsl.AlertType = ...
        InternalError: QSsl.AlertType = ...
        InappropriateFallback: QSsl.AlertType = ...
        UserCancelled: QSsl.AlertType = ...
        NoRenegotiation: QSsl.AlertType = ...
        MissingExtension: QSsl.AlertType = ...
        UnsupportedExtension: QSsl.AlertType = ...
        CertificateUnobtainable: QSsl.AlertType = ...
        UnrecognizedName: QSsl.AlertType = ...
        BadCertificateStatusResponse: QSsl.AlertType = ...
        BadCertificateHashValue: QSsl.AlertType = ...
        UnknownPskIdentity: QSsl.AlertType = ...
        CertificateRequired: QSsl.AlertType = ...
        NoApplicationProtocol: QSsl.AlertType = ...
        UnknownAlertMessage: QSsl.AlertType = ...

    class AlternativeNameEntryType(Enum):
        EmailEntry: QSsl.AlternativeNameEntryType = ...
        DnsEntry: QSsl.AlternativeNameEntryType = ...
        IpAddressEntry: QSsl.AlternativeNameEntryType = ...

    class EncodingFormat(Enum):
        Pem: QSsl.EncodingFormat = ...
        Der: QSsl.EncodingFormat = ...

    class ImplementedClass(Enum):
        Key: QSsl.ImplementedClass = ...
        Certificate: QSsl.ImplementedClass = ...
        Socket: QSsl.ImplementedClass = ...
        DiffieHellman: QSsl.ImplementedClass = ...
        EllipticCurve: QSsl.ImplementedClass = ...
        Dtls: QSsl.ImplementedClass = ...
        DtlsCookie: QSsl.ImplementedClass = ...

    class KeyAlgorithm(Enum):
        Opaque: QSsl.KeyAlgorithm = ...
        Rsa: QSsl.KeyAlgorithm = ...
        Dsa: QSsl.KeyAlgorithm = ...
        Ec: QSsl.KeyAlgorithm = ...
        Dh: QSsl.KeyAlgorithm = ...

    class KeyType(Enum):
        PrivateKey: QSsl.KeyType = ...
        PublicKey: QSsl.KeyType = ...

    class SslOption(Enum):
        SslOptionDisableEmptyFragments: QSsl.SslOption = ...
        SslOptionDisableSessionTickets: QSsl.SslOption = ...
        SslOptionDisableCompression: QSsl.SslOption = ...
        SslOptionDisableServerNameIndication: QSsl.SslOption = ...
        SslOptionDisableLegacyRenegotiation: QSsl.SslOption = ...
        SslOptionDisableSessionSharing: QSsl.SslOption = ...
        SslOptionDisableSessionPersistence: QSsl.SslOption = ...
        SslOptionDisableServerCipherPreference: QSsl.SslOption = ...

    class SslOptions(object):
        ...

    class SslProtocol(Enum):
        UnknownProtocol: QSsl.SslProtocol = ...
        TlsV1_0: QSsl.SslProtocol = ...
        TlsV1_1: QSsl.SslProtocol = ...
        TlsV1_2: QSsl.SslProtocol = ...
        AnyProtocol: QSsl.SslProtocol = ...
        SecureProtocols: QSsl.SslProtocol = ...
        TlsV1_0OrLater: QSsl.SslProtocol = ...
        TlsV1_1OrLater: QSsl.SslProtocol = ...
        TlsV1_2OrLater: QSsl.SslProtocol = ...
        DtlsV1_0: QSsl.SslProtocol = ...
        DtlsV1_0OrLater: QSsl.SslProtocol = ...
        DtlsV1_2: QSsl.SslProtocol = ...
        DtlsV1_2OrLater: QSsl.SslProtocol = ...
        TlsV1_3: QSsl.SslProtocol = ...
        TlsV1_3OrLater: QSsl.SslProtocol = ...

    class SupportedFeature(Enum):
        CertificateVerification: QSsl.SupportedFeature = ...
        ClientSideAlpn: QSsl.SupportedFeature = ...
        ServerSideAlpn: QSsl.SupportedFeature = ...
        Ocsp: QSsl.SupportedFeature = ...
        Psk: QSsl.SupportedFeature = ...
        SessionTicket: QSsl.SupportedFeature = ...
        Alerts: QSsl.SupportedFeature = ...
