"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QOcspResponse(object):
    """
    https://doc.qt.io/qt-6/qocspresponse.html

    **Detailed Description**

    The QOcspResponse class represents the revocation status of a server's
    certificate, received by the client-side socket during the TLS handshake.
    **QSslSocket**  must be configured with OCSP stapling enabled.

    **See also** **QSslSocket** , **QSslSocket::ocspResponses** (),
    **certificateStatus** (), **revocationReason** (), **responder** (),
    **subject** (), **QOcspCertificateStatus** , **QOcspRevocationReason** ,
    **QSslConfiguration::setOcspStaplingEnabled** (),
    **QSslConfiguration::ocspStaplingEnabled** (), and
    **QSslConfiguration::peerCertificate** ().
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qocspresponse.html#QOcspResponse

        **[since 5.13] QOcspResponse::QOcspResponse()**

        Creates a new response with status **QOcspCertificateStatus::Unknown**
        and revocation reason **QOcspRevocationReason::None** .

        This function was introduced in Qt 5.13.

        **See also** **QOcspCertificateStatus** .
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtNetwork.QOcspResponse) -> None:
        """
        https://doc.qt.io/qt-6/qocspresponse.html#QOcspResponse-1

        **[since 5.13] QOcspResponse::QOcspResponse(const QOcspResponse & other
        )**

        Copy-constructs a QOcspResponse instance.

        This function was introduced in Qt 5.13.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def certificateStatus(self) -> PySide6.QtNetwork.QOcspCertificateStatus:
        """
        https://doc.qt.io/qt-6/qocspresponse.html#certificateStatus

        **[since 5.13] QOcspCertificateStatus QOcspResponse::certificateStatus()
        const**

        Returns the certificate status.

        This function was introduced in Qt 5.13.

        **See also** **QOcspCertificateStatus** .
        """
        ...

    def revocationReason(self) -> PySide6.QtNetwork.QOcspRevocationReason:
        """
        https://doc.qt.io/qt-6/qocspresponse.html#revocationReason

        **[since 5.13] QOcspRevocationReason QOcspResponse::revocationReason()
        const**

        Returns the reason for revocation.

        This function was introduced in Qt 5.13.
        """
        ...

    def subject(self) -> PySide6.QtNetwork.QSslCertificate:
        """
        https://doc.qt.io/qt-6/qocspresponse.html#subject

        **[since 5.13] QSslCertificate QOcspResponse::subject() const**

        This function returns a certificate, for which this response was issued.

        This function was introduced in Qt 5.13.
        """
        ...

    def swap(self, other: PySide6.QtNetwork.QOcspResponse) -> None:
        """
        https://doc.qt.io/qt-6/qocspresponse.html#swap

        **[since 5.13] void QOcspResponse::swap(QOcspResponse & other )**

        Swaps this response with **other**.

        This function was introduced in Qt 5.13.
        """
        ...
