"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, Sequence, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QNetworkReply(PySide6.QtCore.QIODevice):
    """
    https://doc.qt.io/qt-6/qnetworkreply.html

    **Detailed Description**

    The QNetworkReply class contains the data and meta data related to a request
    posted with **QNetworkAccessManager** . Like **QNetworkRequest** , it
    contains a URL and headers (both in parsed and raw form), some information
    about the reply's state and the contents of the reply itself.

    QNetworkReply is a sequential-access **QIODevice** , which means that once
    data is read from the object, it no longer kept by the device. It is
    therefore the application's responsibility to keep this data if it needs to.
    Whenever more data is received from the network and processed, the
    **readyRead** () signal is emitted.

    The **downloadProgress** () signal is also emitted when data is received,
    but the number of bytes contained in it may not represent the actual bytes
    received, if any transformation is done to the contents (for example,
    decompressing and removing the protocol overhead).

    Even though QNetworkReply is a **QIODevice**  connected to the contents of
    the reply, it also emits the **uploadProgress** () signal, which indicates
    the progress of the upload for operations that have such content.

    **Note:** Do not delete the object in the slot connected to the
    **errorOccurred** () or **finished** () signal. Use **deleteLater** ().

    **See also** **QNetworkRequest**  and **QNetworkAccessManager** .
    """

    NoError: QNetworkReply.NetworkError = ...
    ConnectionRefusedError: QNetworkReply.NetworkError = ...
    RemoteHostClosedError: QNetworkReply.NetworkError = ...
    HostNotFoundError: QNetworkReply.NetworkError = ...
    TimeoutError: QNetworkReply.NetworkError = ...
    OperationCanceledError: QNetworkReply.NetworkError = ...
    SslHandshakeFailedError: QNetworkReply.NetworkError = ...
    TemporaryNetworkFailureError: QNetworkReply.NetworkError = ...
    NetworkSessionFailedError: QNetworkReply.NetworkError = ...
    BackgroundRequestNotAllowedError: QNetworkReply.NetworkError = ...
    TooManyRedirectsError: QNetworkReply.NetworkError = ...
    InsecureRedirectError: QNetworkReply.NetworkError = ...
    UnknownNetworkError: QNetworkReply.NetworkError = ...
    ProxyConnectionRefusedError: QNetworkReply.NetworkError = ...
    ProxyConnectionClosedError: QNetworkReply.NetworkError = ...
    ProxyNotFoundError: QNetworkReply.NetworkError = ...
    ProxyTimeoutError: QNetworkReply.NetworkError = ...
    ProxyAuthenticationRequiredError: QNetworkReply.NetworkError = ...
    UnknownProxyError: QNetworkReply.NetworkError = ...
    ContentAccessDenied: QNetworkReply.NetworkError = ...
    ContentOperationNotPermittedError: QNetworkReply.NetworkError = ...
    ContentNotFoundError: QNetworkReply.NetworkError = ...
    AuthenticationRequiredError: QNetworkReply.NetworkError = ...
    ContentReSendError: QNetworkReply.NetworkError = ...
    ContentConflictError: QNetworkReply.NetworkError = ...
    ContentGoneError: QNetworkReply.NetworkError = ...
    UnknownContentError: QNetworkReply.NetworkError = ...
    ProtocolUnknownError: QNetworkReply.NetworkError = ...
    ProtocolInvalidOperationError: QNetworkReply.NetworkError = ...
    ProtocolFailure: QNetworkReply.NetworkError = ...
    InternalServerError: QNetworkReply.NetworkError = ...
    OperationNotImplementedError: QNetworkReply.NetworkError = ...
    ServiceUnavailableError: QNetworkReply.NetworkError = ...
    UnknownServerError: QNetworkReply.NetworkError = ...

    class NetworkError(Enum):
        NoError: QNetworkReply.NetworkError = ...
        ConnectionRefusedError: QNetworkReply.NetworkError = ...
        RemoteHostClosedError: QNetworkReply.NetworkError = ...
        HostNotFoundError: QNetworkReply.NetworkError = ...
        TimeoutError: QNetworkReply.NetworkError = ...
        OperationCanceledError: QNetworkReply.NetworkError = ...
        SslHandshakeFailedError: QNetworkReply.NetworkError = ...
        TemporaryNetworkFailureError: QNetworkReply.NetworkError = ...
        NetworkSessionFailedError: QNetworkReply.NetworkError = ...
        BackgroundRequestNotAllowedError: QNetworkReply.NetworkError = ...
        TooManyRedirectsError: QNetworkReply.NetworkError = ...
        InsecureRedirectError: QNetworkReply.NetworkError = ...
        UnknownNetworkError: QNetworkReply.NetworkError = ...
        ProxyConnectionRefusedError: QNetworkReply.NetworkError = ...
        ProxyConnectionClosedError: QNetworkReply.NetworkError = ...
        ProxyNotFoundError: QNetworkReply.NetworkError = ...
        ProxyTimeoutError: QNetworkReply.NetworkError = ...
        ProxyAuthenticationRequiredError: QNetworkReply.NetworkError = ...
        UnknownProxyError: QNetworkReply.NetworkError = ...
        ContentAccessDenied: QNetworkReply.NetworkError = ...
        ContentOperationNotPermittedError: QNetworkReply.NetworkError = ...
        ContentNotFoundError: QNetworkReply.NetworkError = ...
        AuthenticationRequiredError: QNetworkReply.NetworkError = ...
        ContentReSendError: QNetworkReply.NetworkError = ...
        ContentConflictError: QNetworkReply.NetworkError = ...
        ContentGoneError: QNetworkReply.NetworkError = ...
        UnknownContentError: QNetworkReply.NetworkError = ...
        ProtocolUnknownError: QNetworkReply.NetworkError = ...
        ProtocolInvalidOperationError: QNetworkReply.NetworkError = ...
        ProtocolFailure: QNetworkReply.NetworkError = ...
        InternalServerError: QNetworkReply.NetworkError = ...
        OperationNotImplementedError: QNetworkReply.NetworkError = ...
        ServiceUnavailableError: QNetworkReply.NetworkError = ...
        UnknownServerError: QNetworkReply.NetworkError = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#QNetworkReply

        **[protected] QNetworkReply::QNetworkReply(QObject * parent = nullptr)**

        Creates a QNetworkReply object with parent **parent**.

        You cannot directly instantiate QNetworkReply objects. Use
        **QNetworkAccessManager**  functions to do that.
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#abort

        **[pure virtual slot] void QNetworkReply::abort()**

        Aborts the operation immediately and close down any network connections
        still open. Uploads still in progress are also aborted.

        The **finished** () signal will also be emitted.

        **See also** **close** () and **finished** ().
        """
        ...

    def attribute(self, code: PySide6.QtNetwork.QNetworkRequest.Attribute) -> Any:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#attribute

        **QVariant QNetworkReply::attribute(QNetworkRequest::Attribute code )
        const**

        Returns the attribute associated with the code **code**. If the
        attribute has not been set, it returns an invalid **QVariant**  (type
        **QMetaType::UnknownType** ).

        You can expect the default values listed in
        **QNetworkRequest::Attribute**  to be applied to the values returned by
        this function.

        **See also** **setAttribute** () and **QNetworkRequest::Attribute** .
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#close

        **[override virtual] void QNetworkReply::close()**

        Reimplements: **QIODevice::close** ().

        Closes this device for reading. Unread data is discarded, but the
        network resources are not discarded until they are finished. In
        particular, if any upload is in progress, it will continue until it is
        done.

        The **finished** () signal is emitted when all operations are over and
        the network resources are freed.

        **See also** **abort** () and **finished** ().
        """
        ...

    def error(self) -> PySide6.QtNetwork.QNetworkReply.NetworkError:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#error

        **QNetworkReply::NetworkError QNetworkReply::error() const**

        Returns the error that was found during the processing of this request.
        If no error was found, returns **NoError** .

        **See also** **setError** ().
        """
        ...

    def hasRawHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#hasRawHeader

        **bool QNetworkReply::hasRawHeader(const QByteArray & headerName )
        const**

        Returns `true` if the raw header of name **headerName** was sent by the
        remote server

        **See also** **rawHeader** ().
        """
        ...

    def header(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders) -> Any:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#header

        **QVariant QNetworkReply::header(QNetworkRequest::KnownHeaders header )
        const**

        Returns the value of the known header **header** , if that header was
        sent by the remote server. If the header was not sent, returns an
        invalid **QVariant** .

        **See also** **rawHeader** (), **setHeader** (), and
        **QNetworkRequest::header** ().
        """
        ...

    @overload
    def ignoreSslErrors(self) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#ignoreSslErrors

        **[virtual slot] void QNetworkReply::ignoreSslErrors()**

        If this function is called, SSL errors related to network connection
        will be ignored, including certificate validation errors.

        **Warning:** Be sure to always let the user inspect the errors reported
        by the **sslErrors** () signal, and only call this method upon
        confirmation from the user that proceeding is ok. If there are
        unexpected errors, the reply should be aborted. Calling this method
        without inspecting the actual errors will most likely pose a security
        risk for your application. Use it with great care!

        This function can be called from the slot connected to the **sslErrors**
        () signal, which indicates which errors were found.

        **Note:** If HTTP Strict Transport Security is enabled for
        **QNetworkAccessManager** , this function has no effect.

        **See also** **sslConfiguration** (), **sslErrors** (), and
        **QSslSocket::ignoreSslErrors** ().
        """
        ...

    @overload
    def ignoreSslErrors(self, errors: Sequence[PySide6.QtNetwork.QSslError]) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#ignoreSslErrors-1

        **void QNetworkReply::ignoreSslErrors(const QList<QSslError> & errors
        )**

        This is an overloaded function.

        If this function is called, the SSL errors given in **errors** will be
        ignored.

        **Note:** Because most SSL errors are associated with a certificate, for
        most of them you must set the expected certificate this SSL error is
        related to. If, for instance, you want to issue a request to a server
        that uses a self-signed certificate, consider the following snippet:

        **QList** <**QSslCertificate** > cert = **QSslCertificate**
        ::fromPath(QLatin1String("server-certificate.pem"));
            **QSslError**
        error(**QSslError** ::SelfSignedCertificate, cert.at(0));
            **QList**
        <**QSslError** > expectedSslErrors;
            expectedSslErrors.append(error);
        **QNetworkReply**  *reply = manager.get(**QNetworkRequest** (**QUrl**
        ("https://server.tld/index.html")));
        reply->ignoreSslErrors(expectedSslErrors);
            // here connect signals
        etc.

        Multiple calls to this function will replace the list of errors that
        were passed in previous calls. You can clear the list of errors you want
        to ignore by calling this function with an empty list.

        **Note:** If HTTP Strict Transport Security is enabled for
        **QNetworkAccessManager** , this function has no effect.

        **See also** **sslConfiguration** (), **sslErrors** (),
        **QSslSocket::ignoreSslErrors** (), and
        **QNetworkAccessManager::setStrictTransportSecurityEnabled** ().
        """
        ...

    def ignoreSslErrorsImplementation(
        self, arg__1: Sequence[PySide6.QtNetwork.QSslError]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#ignoreSslErrorsImplementation

        **[virtual protected, since 5.0] void
        QNetworkReply::ignoreSslErrorsImplementation(const QList<QSslError> &
        errors )**

        This virtual method is provided to enable overriding the behavior of
        **ignoreSslErrors** (). **ignoreSslErrors** () is a public wrapper for
        this method. **errors** contains the errors the user wishes ignored.

        This function was introduced in Qt 5.0.

        **See also** **ignoreSslErrors** ().
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#isFinished

        **bool QNetworkReply::isFinished() const**

        Returns `true` when the reply has finished or was aborted.

        **See also** **isRunning** ().
        """
        ...

    def isRunning(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#isRunning

        **bool QNetworkReply::isRunning() const**

        Returns `true` when the request is still processing and the reply has
        not finished or was aborted yet.

        **See also** **isFinished** ().
        """
        ...

    def isSequential(self) -> bool:
        ...

    def manager(self) -> PySide6.QtNetwork.QNetworkAccessManager:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#manager

        **QNetworkAccessManager *QNetworkReply::manager() const**

        Returns the **QNetworkAccessManager**  that was used to create this
        **QNetworkReply**  object. Initially, it is also the parent object.
        """
        ...

    def operation(self) -> PySide6.QtNetwork.QNetworkAccessManager.Operation:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#operation

        **QNetworkAccessManager::Operation QNetworkReply::operation() const**

        Returns the operation that was posted for this reply.

        **See also** **setOperation** ().
        """
        ...

    def rawHeader(
        self, headerName: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#rawHeader

        **QByteArray QNetworkReply::rawHeader(const QByteArray & headerName )
        const**

        Returns the raw contents of the header **headerName** as sent by the
        remote server. If there is no such header, returns an empty byte array,
        which may be indistinguishable from an empty header. Use
        **hasRawHeader** () to verify if the server sent such header field.

        **See also** **setRawHeader** (), **hasRawHeader** (), and **header**
        ().
        """
        ...

    def rawHeaderList(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#rawHeaderList

        **QList<QByteArray> QNetworkReply::rawHeaderList() const**

        Returns a list of headers fields that were sent by the remote server, in
        the order that they were sent. Duplicate headers are merged together and
        take place of the latter duplicate.
        """
        ...

    def rawHeaderPairs(
        self,
    ) -> List[Tuple[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]]:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#rawHeaderPairs

        **const QList<QNetworkReply::RawHeaderPair>
        &QNetworkReply::rawHeaderPairs() const**

        Returns a list of raw header pairs.
        """
        ...

    def readBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#readBufferSize

        **qint64 QNetworkReply::readBufferSize() const**

        Returns the size of the read buffer, in bytes.

        **See also** **setReadBufferSize** ().
        """
        ...

    def request(self) -> PySide6.QtNetwork.QNetworkRequest:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#request

        **QNetworkRequest QNetworkReply::request() const**

        Returns the request that was posted for this reply. In special, note
        that the URL for the request may be different than that of the reply.

        **See also** **QNetworkRequest::url** (), **url** (), and **setRequest**
        ().
        """
        ...

    def setAttribute(
        self, code: PySide6.QtNetwork.QNetworkRequest.Attribute, value: Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setAttribute

        **[protected] void
        QNetworkReply::setAttribute(QNetworkRequest::Attribute code , const
        QVariant & value )**

        Sets the attribute **code** to have value **value**. If **code** was
        previously set, it will be overridden. If **value** is an invalid
        **QVariant** , the attribute will be unset.

        **See also** **attribute** () and **QNetworkRequest::setAttribute** ().
        """
        ...

    def setError(
        self, errorCode: PySide6.QtNetwork.QNetworkReply.NetworkError, errorString: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setError

        **[protected] void QNetworkReply::setError(QNetworkReply::NetworkError
        errorCode , const QString & errorString )**

        Sets the error condition to be **errorCode**. The human-readable message
        is set with **errorString**.

        Calling setError() does not emit the **errorOccurred**
        (**QNetworkReply::NetworkError** ) signal.

        **See also** **error** () and **errorString** ().
        """
        ...

    def setFinished(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setFinished

        **[protected] void QNetworkReply::setFinished(bool finished )**

        Sets the reply as **finished**.

        After having this set the replies data must not change.

        **See also** **finished** () and **isFinished** ().
        """
        ...

    def setHeader(
        self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders, value: Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setHeader

        **[protected] void
        QNetworkReply::setHeader(QNetworkRequest::KnownHeaders header , const
        QVariant & value )**

        Sets the known header **header** to be of value **value**. The
        corresponding raw form of the header will be set as well.

        **See also** **header** (), **setRawHeader** (), and
        **QNetworkRequest::setHeader** ().
        """
        ...

    def setOperation(
        self, operation: PySide6.QtNetwork.QNetworkAccessManager.Operation
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setOperation

        **[protected] void
        QNetworkReply::setOperation(QNetworkAccessManager::Operation operation
        )**

        Sets the associated operation for this object to be **operation**. This
        value will be returned by **operation** ().

        **Note:** The operation should be set when this object is created and
        not changed again.

        **See also** **operation** () and **setRequest** ().
        """
        ...

    def setRawHeader(
        self,
        headerName: Union[PySide6.QtCore.QByteArray, bytes],
        value: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setRawHeader

        **[protected] void QNetworkReply::setRawHeader(const QByteArray &
        headerName , const QByteArray & value )**

        Sets the raw header **headerName** to be of value **value**. If
        **headerName** was previously set, it is overridden. Multiple HTTP
        headers of the same name are functionally equivalent to one single
        header with the values concatenated, separated by commas.

        If **headerName** matches a known header, the value **value** will be
        parsed and the corresponding parsed form will also be set.

        **See also** **rawHeader** (), **header** (), **setHeader** (), and
        **QNetworkRequest::setRawHeader** ().
        """
        ...

    def setReadBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setReadBufferSize

        **[virtual] void QNetworkReply::setReadBufferSize(qint64 size )**

        Sets the size of the read buffer to be **size** bytes. The read buffer
        is the buffer that holds data that is being downloaded off the network,
        before it is read with **QIODevice::read** (). Setting the buffer size
        to 0 will make the buffer unlimited in size.

        **QNetworkReply**  will try to stop reading from the network once this
        buffer is full (i.e., **bytesAvailable** () returns **size** or more),
        thus causing the download to throttle down as well. If the buffer is not
        limited in size, **QNetworkReply**  will try to download as fast as
        possible from the network.

        Unlike **QAbstractSocket::setReadBufferSize** (), **QNetworkReply**
        cannot guarantee precision in the read buffer size. That is,
        **bytesAvailable** () can return more than **size**.

        **See also** **readBufferSize** ().
        """
        ...

    def setRequest(self, request: PySide6.QtNetwork.QNetworkRequest) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setRequest

        **[protected] void QNetworkReply::setRequest(const QNetworkRequest &
        request )**

        Sets the associated request for this object to be **request**. This
        value will be returned by **request** ().

        **Note:** The request should be set when this object is created and not
        changed again.

        **See also** **request** () and **setOperation** ().
        """
        ...

    def setSslConfiguration(
        self, configuration: PySide6.QtNetwork.QSslConfiguration
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setSslConfiguration

        **void QNetworkReply::setSslConfiguration(const QSslConfiguration &
        config )**

        Sets the SSL configuration for the network connection associated with
        this request, if possible, to be that of **config**.

        **See also** **sslConfiguration** ().
        """
        ...

    def setSslConfigurationImplementation(
        self, arg__1: PySide6.QtNetwork.QSslConfiguration
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setSslConfigurationImplementat
        ion

        **[virtual protected, since 5.0] void
        QNetworkReply::setSslConfigurationImplementation(const QSslConfiguration
        & configuration )**

        This virtual method is provided to enable overriding the behavior of
        **setSslConfiguration** (). **setSslConfiguration** () is a public
        wrapper for this method. If you override this method use
        **configuration** to set the SSL configuration.

        This function was introduced in Qt 5.0.

        **See also** **sslConfigurationImplementation** () and
        **setSslConfiguration** ().
        """
        ...

    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#setUrl

        **[protected] void QNetworkReply::setUrl(const QUrl & url )**

        Sets the URL being processed to be **url**. Normally, the URL matches
        that of the request that was posted, but for a variety of reasons it can
        be different (for example, a file path being made absolute or
        canonical).

        **See also** **url** (), **request** (), and **QNetworkRequest::url**
        ().
        """
        ...

    def sslConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#sslConfiguration

        **QSslConfiguration QNetworkReply::sslConfiguration() const**

        Returns the SSL configuration and state associated with this reply, if
        SSL was used. It will contain the remote server's certificate, its
        certificate chain leading to the Certificate Authority as well as the
        encryption ciphers in use.

        The peer's certificate and its certificate chain will be known by the
        time **sslErrors** () is emitted, if it's emitted.

        **See also** **setSslConfiguration** ().
        """
        ...

    def sslConfigurationImplementation(
        self, arg__1: PySide6.QtNetwork.QSslConfiguration
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#sslConfigurationImplementation

        **[virtual protected, since 5.0] void
        QNetworkReply::sslConfigurationImplementation(QSslConfiguration &
        configuration ) const**

        This virtual method is provided to enable overriding the behavior of
        **sslConfiguration** (). **sslConfiguration** () is a public wrapper for
        this method. The configuration will be returned in **configuration**.

        This function was introduced in Qt 5.0.

        **See also** **setSslConfigurationImplementation** () and
        **sslConfiguration** ().
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#url

        **QUrl QNetworkReply::url() const**

        Returns the URL of the content downloaded or uploaded. Note that the URL
        may be different from that of the original request. If redirections were
        enabled in the request, then this function returns the current url that
        the network API is accessing, i.e the url of the resource the request
        got redirected to.

        **See also** **request** (), **setUrl** (), **QNetworkRequest::url** (),
        and **redirected** ().
        """
        ...

    def writeData(self, data: bytes, len: int) -> int:
        ...

    @property
    def downloadProgress(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#downloadProgress

        **[signal] void QNetworkReply::downloadProgress(qint64 bytesReceived ,
        qint64 bytesTotal )**

        This signal is emitted to indicate the progress of the download part of
        this network request, if there's any. If there's no download associated
        with this request, this signal will be emitted once with 0 as the value
        of both **bytesReceived** and **bytesTotal**.

        The **bytesReceived** parameter indicates the number of bytes received,
        while **bytesTotal** indicates the total number of bytes expected to be
        downloaded. If the number of bytes to be downloaded is not known,
        **bytesTotal** will be -1.

        The download is finished when **bytesReceived** is equal to
        **bytesTotal**. At that time, **bytesTotal** will not be -1.

        Note that the values of both **bytesReceived** and **bytesTotal** may be
        different from **size** (), the total number of bytes obtained through
        **read** () or **readAll** (), or the value of the
        header(ContentLengthHeader). The reason for that is that there may be
        protocol overhead or the data may be compressed during the download.

        **See also** **uploadProgress** () and **bytesAvailable** ().
        """
        ...

    @property
    def encrypted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#encrypted

        **[signal, since 5.1] void QNetworkReply::encrypted()**

        This signal is emitted when an SSL/TLS session has successfully
        completed the initial handshake. At this point, no user data has been
        transmitted. The signal can be used to perform additional checks on the
        certificate chain, for example to notify users when the certificate for
        a website has changed. If the reply does not match the expected criteria
        then it should be aborted by calling **QNetworkReply::abort** () by a
        slot connected to this signal. The SSL configuration in use can be
        inspected using the **QNetworkReply::sslConfiguration** () method.

        Internally, **QNetworkAccessManager**  may open multiple connections to
        a server, in order to allow it process requests in parallel. These
        connections may be reused, which means that the encrypted() signal would
        not be emitted. This means that you are only guaranteed to receive this
        signal for the first connection to a site in the lifespan of the
        **QNetworkAccessManager** .

        This function was introduced in Qt 5.1.

        **See also** **QSslSocket::encrypted** () and
        **QNetworkAccessManager::encrypted** ().
        """
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#errorOccurred

        **[signal, since 5.15] void
        QNetworkReply::errorOccurred(QNetworkReply::NetworkError code )**

        This signal is emitted when the reply detects an error in processing.
        The **finished** () signal will probably follow, indicating that the
        connection is over.

        The **code** parameter contains the code of the error that was detected.
        Call **errorString** () to obtain a textual representation of the error
        condition.

        **Note:** Do not delete the object in the slot connected to this signal.
        Use **deleteLater** ().

        This function was introduced in Qt 5.15.

        **See also** **error** () and **errorString** ().
        """
        ...

    @property
    def finished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#finished

        **[signal] void QNetworkReply::finished()**

        This signal is emitted when the reply has finished processing. After
        this signal is emitted, there will be no more updates to the reply's
        data or metadata.

        Unless **close** () or **abort** () have been called, the reply will be
        still be opened for reading, so the data can be retrieved by calls to
        **read** () or **readAll** (). In particular, if no calls to **read** ()
        were made as a result of **readyRead** (), a call to **readAll** () will
        retrieve the full contents in a **QByteArray** .

        This signal is emitted in tandem with
        **QNetworkAccessManager::finished** () where that signal's reply
        parameter is this object.

        **Note:** Do not delete the object in the slot connected to this signal.
        Use **deleteLater** ().

        You can also use **isFinished** () to check if a **QNetworkReply**  has
        finished even before you receive the finished() signal.

        **See also** **setFinished** (), **QNetworkAccessManager::finished** (),
        and **isFinished** ().
        """
        ...

    @property
    def metaDataChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#metaDataChanged

        **[signal] void QNetworkReply::metaDataChanged()**

        This signal is emitted whenever the metadata in this reply changes.
        metadata is any information that is not the content (data) itself,
        including the network headers. In the majority of cases, the metadata
        will be known fully by the time the first byte of data is received.
        However, it is possible to receive updates of headers or other metadata
        during the processing of the data.

        **See also** **header** (), **rawHeaderList** (), **rawHeader** (), and
        **hasRawHeader** ().
        """
        ...

    @property
    def preSharedKeyAuthenticationRequired(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#preSharedKeyAuthenticationRequ
        ired

        **[signal, since 5.5] void QNetworkReply::preSharedKeyAuthenticationRequ
        ired(QSslPreSharedKeyAuthenticator * authenticator )**

        This signal is emitted if the SSL/TLS handshake negotiates a PSK
        ciphersuite, and therefore a PSK authentication is then required.

        When using PSK, the client must send to the server a valid identity and
        a valid pre shared key, in order for the SSL handshake to continue.
        Applications can provide this information in a slot connected to this
        signal, by filling in the passed **authenticator** object according to
        their needs.

        **Note:** Ignoring this signal, or failing to provide the required
        credentials, will cause the handshake to fail, and therefore the
        connection to be aborted.

        **Note:** The **authenticator** object is owned by the reply and must
        not be deleted by the application.

        This function was introduced in Qt 5.5.

        **See also** **QSslPreSharedKeyAuthenticator** .
        """
        ...

    @property
    def redirectAllowed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#redirectAllowed

        **[signal, since 5.9] void QNetworkReply::redirectAllowed()**

        When client code handling the **redirected** () signal has verified the
        new URL, it emits this signal to allow the redirect to go ahead. This
        protocol applies to network requests whose redirects policy is set to
        **QNetworkRequest::UserVerifiedRedirectPolicy**

        This function was introduced in Qt 5.9.

        **See also** **QNetworkRequest::UserVerifiedRedirectPolicy** ,
        **QNetworkAccessManager::setRedirectPolicy** (), and
        **QNetworkRequest::RedirectPolicyAttribute** .
        """
        ...

    @property
    def redirected(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#redirected

        **[signal, since 5.6] void QNetworkReply::redirected(const QUrl & url
        )**

        This signal is emitted if the **QNetworkRequest::ManualRedirectPolicy**
        was set in the request and the server responded with a 3xx status
        (specifically 301, 302, 303, 305, 307 or 308 status code) with a valid
        url in the location header, indicating a HTTP redirect. The **url**
        parameter contains the new redirect url as returned by the server in the
        location header.

        This function was introduced in Qt 5.6.

        **See also** **QNetworkRequest::RedirectPolicy** .
        """
        ...

    @property
    def sslErrors(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#sslErrors

        **[signal] void QNetworkReply::sslErrors(const QList<QSslError> & errors
        )**

        This signal is emitted if the SSL/TLS session encountered errors during
        the set up, including certificate verification errors. The **errors**
        parameter contains the list of errors.

        To indicate that the errors are not fatal and that the connection should
        proceed, the **ignoreSslErrors** () function should be called from the
        slot connected to this signal. If it is not called, the SSL session will
        be torn down before any data is exchanged (including the URL).

        This signal can be used to display an error message to the user
        indicating that security may be compromised and display the SSL settings
        (see **sslConfiguration** () to obtain it). If the user decides to
        proceed after analyzing the remote certificate, the slot should call
        **ignoreSslErrors** ().

        **See also** **QSslSocket::sslErrors** (),
        **QNetworkAccessManager::sslErrors** (), **sslConfiguration** (), and
        **ignoreSslErrors** ().
        """
        ...

    @property
    def uploadProgress(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qnetworkreply.html#uploadProgress

        **[signal] void QNetworkReply::uploadProgress(qint64 bytesSent , qint64
        bytesTotal )**

        This signal is emitted to indicate the progress of the upload part of
        this network request, if there's any. If there's no upload associated
        with this request, this signal will not be emitted.

        The **bytesSent** parameter indicates the number of bytes uploaded,
        while **bytesTotal** indicates the total number of bytes to be uploaded.
        If the number of bytes to be uploaded could not be determined,
        **bytesTotal** will be -1.

        The upload is finished when **bytesSent** is equal to **bytesTotal**. At
        that time, **bytesTotal** will not be -1.

        **See also** **downloadProgress** ().
        """
        ...
