"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QLocalSocket(PySide6.QtCore.QIODevice):
    """
    https://doc.qt.io/qt-6/qlocalsocket.html

    **Detailed Description**

    On Windows this is a named pipe and on Unix this is a local domain socket.

    If an error occurs, **error** () returns the type of error, and
    **errorString** () can be called to get a human readable description of what
    happened.

    Although QLocalSocket is designed for use with an event loop, it's possible
    to use it without one. In that case, you must use **waitForConnected** (),
    **waitForReadyRead** (), **waitForBytesWritten** (), and
    **waitForDisconnected** () which blocks until the operation is complete or
    the timeout expires.

    **See also** **QLocalServer** .
    """

    UnknownSocketError: QLocalSocket.LocalSocketError = ...
    ConnectionRefusedError: QLocalSocket.LocalSocketError = ...
    PeerClosedError: QLocalSocket.LocalSocketError = ...
    ServerNotFoundError: QLocalSocket.LocalSocketError = ...
    SocketAccessError: QLocalSocket.LocalSocketError = ...
    SocketResourceError: QLocalSocket.LocalSocketError = ...
    SocketTimeoutError: QLocalSocket.LocalSocketError = ...
    DatagramTooLargeError: QLocalSocket.LocalSocketError = ...
    ConnectionError: QLocalSocket.LocalSocketError = ...
    UnsupportedSocketOperationError: QLocalSocket.LocalSocketError = ...
    OperationError: QLocalSocket.LocalSocketError = ...
    UnconnectedState: QLocalSocket.LocalSocketState = ...
    ConnectingState: QLocalSocket.LocalSocketState = ...
    ConnectedState: QLocalSocket.LocalSocketState = ...
    ClosingState: QLocalSocket.LocalSocketState = ...
    NoOptions: QLocalSocket.SocketOption = ...
    AbstractNamespaceOption: QLocalSocket.SocketOption = ...

    class LocalSocketError(Enum):
        UnknownSocketError: QLocalSocket.LocalSocketError = ...
        ConnectionRefusedError: QLocalSocket.LocalSocketError = ...
        PeerClosedError: QLocalSocket.LocalSocketError = ...
        ServerNotFoundError: QLocalSocket.LocalSocketError = ...
        SocketAccessError: QLocalSocket.LocalSocketError = ...
        SocketResourceError: QLocalSocket.LocalSocketError = ...
        SocketTimeoutError: QLocalSocket.LocalSocketError = ...
        DatagramTooLargeError: QLocalSocket.LocalSocketError = ...
        ConnectionError: QLocalSocket.LocalSocketError = ...
        UnsupportedSocketOperationError: QLocalSocket.LocalSocketError = ...
        OperationError: QLocalSocket.LocalSocketError = ...

    class LocalSocketState(Enum):
        UnconnectedState: QLocalSocket.LocalSocketState = ...
        ConnectingState: QLocalSocket.LocalSocketState = ...
        ConnectedState: QLocalSocket.LocalSocketState = ...
        ClosingState: QLocalSocket.LocalSocketState = ...

    class SocketOption(Enum):
        NoOptions: QLocalSocket.SocketOption = ...
        AbstractNamespaceOption: QLocalSocket.SocketOption = ...

    class SocketOptions(object):
        ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#QLocalSocket

        **QLocalSocket::QLocalSocket(QObject * parent = nullptr)**

        Creates a new local socket. The **parent** argument is passed to
        **QObject** 's constructor.
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#abort

        **void QLocalSocket::abort()**

        Aborts the current connection and resets the socket. Unlike
        **disconnectFromServer** (), this function immediately closes the
        socket, clearing any pending data in the write buffer.

        **See also** **disconnectFromServer** () and **close** ().
        """
        ...

    def bytesAvailable(self) -> int:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#bytesAvailable

        **[override virtual] qint64 QLocalSocket::bytesAvailable() const**

        Reimplements: **QIODevice::bytesAvailable() const** .
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#bytesToWrite

        **[override virtual] qint64 QLocalSocket::bytesToWrite() const**

        Reimplements: **QIODevice::bytesToWrite() const** .
        """
        ...

    def canReadLine(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#canReadLine

        **[override virtual] bool QLocalSocket::canReadLine() const**

        Reimplements: **QIODevice::canReadLine() const** .
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#close

        **[override virtual] void QLocalSocket::close()**

        Reimplements: **QIODevice::close** ().
        """
        ...

    @overload
    def connectToServer(
        self, name: str, openMode: PySide6.QtCore.QIODeviceBase.OpenMode = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#connectToServer

        **[since 5.1] void QLocalSocket::connectToServer(QIODeviceBase::OpenMode
        openMode = ReadWrite)**

        Attempts to make a connection to **serverName** (). **setServerName** ()
        must be called before you open the connection. Alternatively you can use
        connectToServer(const **QString**  &name, OpenMode openMode);

        The socket is opened in the given **openMode** and first enters
        **ConnectingState** . If a connection is established, **QLocalSocket**
        enters **ConnectedState**  and emits **connected** ().

        After calling this function, the socket can emit **errorOccurred** () to
        signal that an error occurred.

        This function was introduced in Qt 5.1.

        **See also** **state** (), **serverName** (), and **waitForConnected**
        ().
        """
        ...

    @overload
    def connectToServer(
        self, openMode: PySide6.QtCore.QIODeviceBase.OpenMode = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#connectToServer-1

        **void QLocalSocket::connectToServer(const QString & name ,
        QIODeviceBase::OpenMode openMode = ReadWrite)**

        This is an overloaded function.

        Set the server **name** and attempts to make a connection to it.

        The socket is opened in the given **openMode** and first enters
        **ConnectingState** . If a connection is established, **QLocalSocket**
        enters **ConnectedState**  and emits **connected** ().

        After calling this function, the socket can emit **errorOccurred** () to
        signal that an error occurred.

        **See also** **state** (), **serverName** (), and **waitForConnected**
        ().
        """
        ...

    def disconnectFromServer(self) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#disconnectFromServer

        **void QLocalSocket::disconnectFromServer()**

        Attempts to close the socket. If there is pending data waiting to be
        written, **QLocalSocket**  will enter **ClosingState**  and wait until
        all data has been written. Eventually, it will enter
        **UnconnectedState**  and emit the **disconnected** () signal.

        **See also** **connectToServer** ().
        """
        ...

    def error(self) -> PySide6.QtNetwork.QLocalSocket.LocalSocketError:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#error

        **QLocalSocket::LocalSocketError QLocalSocket::error() const**

        Returns the type of error that last occurred.

        **See also** **state** () and **errorString** ().
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#flush

        **bool QLocalSocket::flush()**

        This function writes as much as possible from the internal write buffer
        to the socket, without blocking. If any data was written, this function
        returns `true`; otherwise false is returned.

        Call this function if you need **QLocalSocket**  to start sending
        buffered data immediately. The number of bytes successfully written
        depends on the operating system. In most cases, you do not need to call
        this function, because **QLocalSocket**  will start sending data
        automatically once control goes back to the event loop. In the absence
        of an event loop, call **waitForBytesWritten** () instead.

        **See also** **write** () and **waitForBytesWritten** ().
        """
        ...

    def fullServerName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#fullServerName

        **QString QLocalSocket::fullServerName() const**

        Returns the server path that the socket is connected to.

        **Note:** The return value of this function is platform specific.

        **See also** **connectToServer** () and **serverName** ().
        """
        ...

    def isSequential(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#isSequential

        **[override virtual] bool QLocalSocket::isSequential() const**

        Reimplements: **QIODevice::isSequential() const** .
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#isValid

        **bool QLocalSocket::isValid() const**

        Returns `true` if the socket is valid and ready for use; otherwise
        returns `false`.

        **Note:** The socket's state must be **ConnectedState**  before reading
        and writing can occur.

        **See also** **state** () and **connectToServer** ().
        """
        ...

    def open(self, openMode: PySide6.QtCore.QIODeviceBase.OpenMode = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#open

        **[override virtual] bool QLocalSocket::open(QIODeviceBase::OpenMode
        openMode = ReadWrite)**

        Reimplements: **QIODevice::open** (QIODeviceBase::OpenMode mode).

        Equivalent to **connectToServer** (OpenMode mode). The socket is opened
        in the given **openMode** to the server defined by **setServerName** ().

        Note that unlike in most other **QIODevice**  subclasses, open() may not
        open the device directly. The function return false if the socket was
        already connected or if the server to connect to was not defined and
        true in any other case. The **connected** () or **errorOccurred** ()
        signals will be emitted once the device is actually open (or the
        connection failed).

        See **connectToServer** () for more details.
        """
        ...

    def readBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#readBufferSize

        **qint64 QLocalSocket::readBufferSize() const**

        Returns the size of the internal read buffer. This limits the amount of
        data that the client can receive before you call **read** () or
        **readAll** (). A read buffer size of 0 (the default) means that the
        buffer has no size limit, ensuring that no data is lost.

        **See also** **setReadBufferSize** () and **read** ().
        """
        ...

    def readData(self, arg__1: bytes, arg__2: int) -> object:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#readData

        **[override virtual protected] qint64 QLocalSocket::readData(char * data
        , qint64 c )**

        Reimplements: **QIODevice::readData** (char *data, qint64 maxSize).
        """
        ...

    def serverName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#serverName

        **QString QLocalSocket::serverName() const**

        Returns the name of the peer as specified by **setServerName** (), or an
        empty **QString**  if **setServerName** () has not been called or
        **connectToServer** () failed.

        **See also** **setServerName** (), **connectToServer** (), and
        **fullServerName** ().
        """
        ...

    def setReadBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#setReadBufferSize

        **void QLocalSocket::setReadBufferSize(qint64 size )**

        Sets the size of **QLocalSocket** 's internal read buffer to be **size**
        bytes.

        If the buffer size is limited to a certain size, **QLocalSocket**  won't
        buffer more than this size of data. Exceptionally, a buffer size of 0
        means that the read buffer is unlimited and all incoming data is
        buffered. This is the default.

        This option is useful if you only read the data at certain points in
        time (e.g., in a real-time streaming application) or if you want to
        protect your socket against receiving too much data, which may
        eventually cause your application to run out of memory.

        **See also** **readBufferSize** () and **read** ().
        """
        ...

    def setServerName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#setServerName

        **[since 5.1] void QLocalSocket::setServerName(const QString & name )**

        Set the **name** of the peer to connect to. On Windows name is the name
        of a named pipe; on Unix name is the name of a local domain socket.

        This function must be called when the socket is not connected.

        This function was introduced in Qt 5.1.

        **See also** **serverName** ().
        """
        ...

    def setSocketDescriptor(
        self,
        socketDescriptor: int,
        socketState: PySide6.QtNetwork.QLocalSocket.LocalSocketState = ...,
        openMode: PySide6.QtCore.QIODeviceBase.OpenMode = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#setSocketDescriptor

        **bool QLocalSocket::setSocketDescriptor(qintptr socketDescriptor ,
        QLocalSocket::LocalSocketState socketState = ConnectedState,
        QIODeviceBase::OpenMode openMode = ReadWrite)**

        Initializes **QLocalSocket**  with the native socket descriptor
        **socketDescriptor**. Returns `true` if **socketDescriptor**  is
        accepted as a valid socket descriptor; otherwise returns `false`. The
        socket is opened in the mode specified by **openMode** , and enters the
        socket state specified by **socketState**.

        **Note:** It is not possible to initialize two local sockets with the
        same native socket descriptor.

        **See also** **socketDescriptor** (), **state** (), and **openMode** ().
        """
        ...

    def setSocketOptions(
        self, option: PySide6.QtNetwork.QLocalSocket.SocketOptions
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#socketOptions-prop

        **[bindable, since 6.2] socketOptions : SocketOptions**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the socket options.

        Options must be set while the socket is in **UnconnectedState**  state.

        This property was introduced in Qt 6.2.

        **See also** **connectToServer** ().

        **Member Function Documentation**
        """
        ...

    def skipData(self, maxSize: int) -> int:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#skipData

        **[override virtual protected] qint64 QLocalSocket::skipData(qint64
        maxSize )**

        Reimplements: **QIODevice::skipData** (qint64 maxSize).
        """
        ...

    def socketDescriptor(self) -> int:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#socketDescriptor

        **qintptr QLocalSocket::socketDescriptor() const**

        Returns the native socket descriptor of the **QLocalSocket**  object if
        this is available; otherwise returns -1.

        The socket descriptor is not available when **QLocalSocket**  is in
        **UnconnectedState** . The type of the descriptor depends on the
        platform:

        * On Windows, the returned value is a **Winsock 2 Socket Handle** .
          *
        On INTEGRITY, the returned value is the **QTcpSocket**  socket
        descriptor and the type is defined by **socketDescriptor** .
          * On all
        other UNIX-like operating systems, the type is a file descriptor
        representing a socket.

        **See also** **setSocketDescriptor** ().
        """
        ...

    def socketOptions(self) -> PySide6.QtNetwork.QLocalSocket.SocketOptions:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#socketOptions-prop

        **[bindable, since 6.2] socketOptions : SocketOptions**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the socket options.

        Options must be set while the socket is in **UnconnectedState**  state.

        This property was introduced in Qt 6.2.

        **See also** **connectToServer** ().

        **Member Function Documentation**
        """
        ...

    def state(self) -> PySide6.QtNetwork.QLocalSocket.LocalSocketState:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#state

        **QLocalSocket::LocalSocketState QLocalSocket::state() const**

        Returns the state of the socket.

        **See also** **error** ().
        """
        ...

    def waitForBytesWritten(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#waitForBytesWritten

        **[override virtual] bool QLocalSocket::waitForBytesWritten(int msecs =
        30000)**

        Reimplements: **QIODevice::waitForBytesWritten** (int msecs).
        """
        ...

    def waitForConnected(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#waitForConnected

        **bool QLocalSocket::waitForConnected(int msecs = 30000)**

        Waits until the socket is connected, up to **msecs** milliseconds. If
        the connection has been established, this function returns `true`;
        otherwise it returns `false`. In the case where it returns `false`, you
        can call **error** () to determine the cause of the error.

        The following example waits up to one second for a connection to be
        established:

        socket->connectToServer("market");
            if
        (socket->waitForConnected(1000))
                **qDebug** ("Connected!");

        If **msecs** is -1, this function will not time out.

        **See also** **connectToServer** () and **connected** ().
        """
        ...

    def waitForDisconnected(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#waitForDisconnected

        **bool QLocalSocket::waitForDisconnected(int msecs = 30000)**

        Waits until the socket has disconnected, up to **msecs** milliseconds.
        If the connection was successfully disconnected, this function returns
        `true`; otherwise it returns `false` (if the operation timed out, if an
        error occurred, or if this **QLocalSocket**  is already disconnected).
        In the case where it returns `false`, you can call **error** () to
        determine the cause of the error.

        The following example waits up to one second for a connection to be
        closed:

        socket->disconnectFromServer();
            if (socket->state() ==
        **QLocalSocket** ::UnconnectedState
                ||
        socket->waitForDisconnected(1000)) {
                **qDebug**
        ("Disconnected!");
            }

        If **msecs** is -1, this function will not time out.

        **See also** **disconnectFromServer** () and **close** ().
        """
        ...

    def waitForReadyRead(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#waitForReadyRead

        **[override virtual] bool QLocalSocket::waitForReadyRead(int msecs =
        30000)**

        Reimplements: **QIODevice::waitForReadyRead** (int msecs).

        This function blocks until data is available for reading and the
        **readyRead** () signal has been emitted. The function will timeout
        after **msecs** milliseconds; the default timeout is 30000 milliseconds.

        The function returns `true` if data is available for reading; otherwise
        it returns `false` (if an error occurred or the operation timed out).

        **See also** **waitForBytesWritten** ().
        """
        ...

    def writeData(self, arg__1: bytes, arg__2: int) -> int:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#writeData

        **[override virtual protected] qint64 QLocalSocket::writeData(const char
        * data , qint64 c )**

        Reimplements: **QIODevice::writeData** (const char *data, qint64
        maxSize).
        """
        ...

    @property
    def connected(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#connected

        **[signal] void QLocalSocket::connected()**

        This signal is emitted after **connectToServer** () has been called and
        a connection has been successfully established.

        **See also** **connectToServer** () and **disconnected** ().
        """
        ...

    @property
    def disconnected(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#disconnected

        **[signal] void QLocalSocket::disconnected()**

        This signal is emitted when the socket has been disconnected.

        **See also** **connectToServer** (), **disconnectFromServer** (),
        **abort** (), and **connected** ().
        """
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#errorOccurred

        **[signal, since 5.15] void
        QLocalSocket::errorOccurred(QLocalSocket::LocalSocketError socketError
        )**

        This signal is emitted after an error occurred. The **socketError**
        parameter describes the type of error that occurred.

        **QLocalSocket::LocalSocketError**  is not a registered metatype, so for
        queued connections, you will have to register it with
        **Q_DECLARE_METATYPE** () and **qRegisterMetaType** ().

        This function was introduced in Qt 5.15.

        **See also** **error** (), **errorString** (), and **Creating Custom Qt
        Types** .
        """
        ...

    @property
    def stateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qlocalsocket.html#stateChanged

        **[signal] void
        QLocalSocket::stateChanged(QLocalSocket::LocalSocketState socketState
        )**

        This signal is emitted whenever **QLocalSocket** 's state changes. The
        **socketState** parameter is the new state.

        QLocalSocket::SocketState is not a registered metatype, so for queued
        connections, you will have to register it with **Q_DECLARE_METATYPE** ()
        and **qRegisterMetaType** ().

        **See also** **state** () and **Creating Custom Qt Types** .
        """
        ...
