"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QHostAddress(object):
    """
    https://doc.qt.io/qt-6/qhostaddress.html

    **Detailed Description**

    This class holds an IPv4 or IPv6 address in a platform- and protocol-
    independent manner.

    QHostAddress is normally used with the **QTcpSocket** , **QTcpServer** , and
    **QUdpSocket**  to connect to a host or to set up a server.

    A host address is set with **setAddress** (), and retrieved with
    **toIPv4Address** (), **toIPv6Address** (), or **toString** (). You can
    check the type with **protocol** ().

    **Note:** Please note that QHostAddress does not do DNS lookups.
    **QHostInfo**  is needed for that.

    The class also supports common predefined addresses: **Null** ,
    **LocalHost** , **LocalHostIPv6** , **Broadcast** , and **Any** .

    **See also** **QHostInfo** , **QTcpSocket** , **QTcpServer** , and
    **QUdpSocket** .
    """

    UnknownNetworkLayerProtocol: QAbstractSocket.NetworkLayerProtocol = ...
    IPv4Protocol: QAbstractSocket.NetworkLayerProtocol = ...
    IPv6Protocol: QAbstractSocket.NetworkLayerProtocol = ...
    AnyIPProtocol: QAbstractSocket.NetworkLayerProtocol = ...
    StrictConversion: QHostAddress.ConversionModeFlag = ...
    ConvertV4MappedToIPv4: QHostAddress.ConversionModeFlag = ...
    ConvertV4CompatToIPv4: QHostAddress.ConversionModeFlag = ...
    ConvertUnspecifiedAddress: QHostAddress.ConversionModeFlag = ...
    ConvertLocalHost: QHostAddress.ConversionModeFlag = ...
    TolerantConversion: QHostAddress.ConversionModeFlag = ...
    Null: QHostAddress.SpecialAddress = ...
    Broadcast: QHostAddress.SpecialAddress = ...
    LocalHost: QHostAddress.SpecialAddress = ...
    LocalHostIPv6: QHostAddress.SpecialAddress = ...
    Any: QHostAddress.SpecialAddress = ...
    AnyIPv6: QHostAddress.SpecialAddress = ...
    AnyIPv4: QHostAddress.SpecialAddress = ...

    class ConversionMode(object):
        ...

    class ConversionModeFlag(Enum):
        StrictConversion: QHostAddress.ConversionModeFlag = ...
        ConvertV4MappedToIPv4: QHostAddress.ConversionModeFlag = ...
        ConvertV4CompatToIPv4: QHostAddress.ConversionModeFlag = ...
        ConvertUnspecifiedAddress: QHostAddress.ConversionModeFlag = ...
        ConvertLocalHost: QHostAddress.ConversionModeFlag = ...
        TolerantConversion: QHostAddress.ConversionModeFlag = ...

    class SpecialAddress(Enum):
        Null: QHostAddress.SpecialAddress = ...
        Broadcast: QHostAddress.SpecialAddress = ...
        LocalHost: QHostAddress.SpecialAddress = ...
        LocalHostIPv6: QHostAddress.SpecialAddress = ...
        Any: QHostAddress.SpecialAddress = ...
        AnyIPv6: QHostAddress.SpecialAddress = ...
        AnyIPv4: QHostAddress.SpecialAddress = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#QHostAddress

        **QHostAddress::QHostAddress()**

        Constructs a null host address object, i.e. an address which is not
        valid for any host or interface.

        **See also** **clear** ().
        """
        ...

    @overload
    def __init__(self, address: PySide6.QtNetwork.QHostAddress.SpecialAddress) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#QHostAddress-1

        **QHostAddress::QHostAddress(quint32 ip4Addr )**

        Constructs a host address object with the IPv4 address **ip4Addr**.
        """
        ...

    @overload
    def __init__(self, address: str) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#QHostAddress-2

        **[since 5.5] QHostAddress::QHostAddress(const quint8 * ip6Addr )**

        Constructs a host address object with the IPv6 address **ip6Addr**.

        **ip6Addr** must be a 16-byte array in network byte order (big endian).

        This function was introduced in Qt 5.5.
        """
        ...

    @overload
    def __init__(
        self,
        copy: Union[
            PySide6.QtNetwork.QHostAddress,
            PySide6.QtNetwork.QHostAddress.SpecialAddress,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#QHostAddress-3

        **QHostAddress::QHostAddress(const Q_IPV6ADDR & ip6Addr )**

        Constructs a host address object with the IPv6 address **ip6Addr**.
        """
        ...

    @overload
    def __init__(self, ip4Addr: int) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#QHostAddress-4

        **QHostAddress::QHostAddress(const sockaddr * sockaddr )**

        Constructs an IPv4 or IPv6 address using the address specified by the
        native structure **sockaddr**.

        **See also** **setAddress** ().
        """
        ...

    @overload
    def __init__(self, ip6Addr: PySide6.QtNetwork.QIPv6Address) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#QHostAddress-5

        **QHostAddress::QHostAddress(const QString & address )**

        Constructs an IPv4 or IPv6 address based on the string **address**
        (e.g., "127.0.0.1").

        **See also** **setAddress** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#clear

        **void QHostAddress::clear()**

        Sets the host address to null and sets the protocol to
        **QAbstractSocket::UnknownNetworkLayerProtocol** .

        **See also** **QHostAddress::Null** .
        """
        ...

    def isBroadcast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isBroadcast

        **[since 5.11] bool QHostAddress::isBroadcast() const**

        Returns `true` if the address is the IPv4 broadcast address, `false`
        otherwise. The IPv4 broadcast address is 255.255.255.255.

        Note that this function does not return true for an IPv4 network's local
        broadcast address. For that, please use **QNetworkInterface**  to obtain
        the broadcast addresses of the local machine.

        This function was introduced in Qt 5.11.

        **See also** **isLoopback** (), **isGlobal** (), **isMulticast** (),
        **isLinkLocal** (), and **isUniqueLocalUnicast** ().
        """
        ...

    def isEqual(
        self,
        address: Union[
            PySide6.QtNetwork.QHostAddress,
            PySide6.QtNetwork.QHostAddress.SpecialAddress,
        ],
        mode: PySide6.QtNetwork.QHostAddress.ConversionMode = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isEqual

        **[since 5.8] bool QHostAddress::isEqual(const QHostAddress & other ,
        QHostAddress::ConversionMode mode = TolerantConversion) const**

        Returns `true` if this host address is the same as the **other** address
        given; otherwise returns `false`.

        The parameter **mode** controls which conversions are preformed between
        addresses of differing protocols. If no **mode** is given,
        `TolerantConversion` is performed by default.

        This function was introduced in Qt 5.8.

        **See also** **ConversionMode**  and **operator==** ().
        """
        ...

    def isGlobal(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isGlobal

        **[since 5.11] bool QHostAddress::isGlobal() const**

        Returns `true` if the address is an IPv4 or IPv6 global address, `false`
        otherwise. A global address is an address that is not reserved for
        special purposes (like loopback or multicast) or future purposes.

        Note that IPv6 unique local unicast addresses are considered global
        addresses (see **isUniqueLocalUnicast** ()), as are IPv4 addresses
        reserved for local networks by **RFC 1918** .

        Also note that IPv6 site-local addresses are deprecated and should be
        considered as global in new applications. This function returns true for
        site-local addresses too.

        This function was introduced in Qt 5.11.

        **See also** **isLoopback** (), **isSiteLocal** (), and
        **isUniqueLocalUnicast** ().
        """
        ...

    @overload
    def isInSubnet(self, subnet: Tuple[PySide6.QtNetwork.QHostAddress, int]) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isInSubnet

        **bool QHostAddress::isInSubnet(const QHostAddress & subnet , int
        netmask ) const**

        Returns `true` if this IP is in the subnet described by the network
        prefix **subnet** and netmask **netmask**.

        An IP is considered to belong to a subnet if it is contained between the
        lowest and the highest address in that subnet. In the case of IP version
        4, the lowest address is the network address, while the highest address
        is the broadcast address.

        The **subnet** argument does not have to be the actual network address
        (the lowest address in the subnet). It can be any valid IP belonging to
        that subnet. In particular, if it is equal to the IP address held by
        this object, this function will always return true (provided the netmask
        is a valid value).

        **See also** **parseSubnet** ().
        """
        ...

    @overload
    def isInSubnet(
        self,
        subnet: Union[
            PySide6.QtNetwork.QHostAddress,
            PySide6.QtNetwork.QHostAddress.SpecialAddress,
        ],
        netmask: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isInSubnet-1

        **bool QHostAddress::isInSubnet(const QPair<QHostAddress, int> & subnet
        ) const**

        This is an overloaded function.

        Returns `true` if this IP is in the subnet described by **subnet**. The
        **QHostAddress**  member of **subnet** contains the network prefix and
        the int (second) member contains the netmask (prefix length).
        """
        ...

    def isLinkLocal(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isLinkLocal

        **[since 5.11] bool QHostAddress::isLinkLocal() const**

        Returns `true` if the address is an IPv4 or IPv6 link-local address,
        `false` otherwise.

        An IPv4 link-local address is an address in the network 169.254.0.0/16.
        An IPv6 link-local address is one in the network fe80::/10. See the
        **IANA IPv6 Address Space**  registry for more information.

        This function was introduced in Qt 5.11.

        **See also** **isLoopback** (), **isGlobal** (), **isMulticast** (),
        **isSiteLocal** (), and **isUniqueLocalUnicast** ().
        """
        ...

    def isLoopback(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isLoopback

        **[since 5.0] bool QHostAddress::isLoopback() const**

        returns `true` if the address is the IPv6 loopback address, or any of
        the IPv4 loopback addresses.

        This function was introduced in Qt 5.0.
        """
        ...

    def isMulticast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isMulticast

        **[since 5.6] bool QHostAddress::isMulticast() const**

        Returns `true` if the address is an IPv4 or IPv6 multicast address,
        `false` otherwise.

        This function was introduced in Qt 5.6.

        **See also** **isLoopback** (), **isGlobal** (), **isLinkLocal** (),
        **isSiteLocal** (), and **isUniqueLocalUnicast** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isNull

        **bool QHostAddress::isNull() const**

        Returns `true` if this host address is not valid for any host or
        interface.

        The default constructor creates a null address.

        **See also** **QHostAddress::Null** .
        """
        ...

    def isSiteLocal(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isSiteLocal

        **[since 5.11] bool QHostAddress::isSiteLocal() const**

        Returns `true` if the address is an IPv6 site-local address, `false`
        otherwise.

        An IPv6 site-local address is one in the network fec0::/10. See the
        **IANA IPv6 Address Space**  registry for more information.

        IPv6 site-local addresses are deprecated and should not be depended upon
        in new applications. New applications should not depend on this function
        and should consider site-local addresses the same as global (which is
        why **isGlobal** () also returns true). Site-local addresses were
        replaced by Unique Local Addresses (ULA).

        This function was introduced in Qt 5.11.

        **See also** **isLoopback** (), **isGlobal** (), **isMulticast** (),
        **isLinkLocal** (), and **isUniqueLocalUnicast** ().
        """
        ...

    def isUniqueLocalUnicast(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#isUniqueLocalUnicast

        **[since 5.11] bool QHostAddress::isUniqueLocalUnicast() const**

        Returns `true` if the address is an IPv6 unique local unicast address,
        `false` otherwise.

        An IPv6 unique local unicast address is one in the network fc00::/7. See
        the **IANA IPv6 Address Space**  registry for more information.

        Note that Unique local unicast addresses count as global addresses too.
        RFC 4193 says that, in practice, "applications may treat these addresses
        like global scoped addresses." Only routers need care about the
        distinction.

        This function was introduced in Qt 5.11.

        **See also** **isLoopback** (), **isGlobal** (), **isMulticast** (),
        **isLinkLocal** (), and isUniqueLocalUnicast().
        """
        ...

    @staticmethod
    def parseSubnet(subnet: str) -> Tuple[PySide6.QtNetwork.QHostAddress, int]:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#parseSubnet

        **[static] QPair<QHostAddress, int> QHostAddress::parseSubnet(const
        QString & subnet )**

        Parses the IP and subnet information contained in **subnet** and returns
        the network prefix for that network and its prefix length.

        The IP address and the netmask must be separated by a slash (/).

        This function supports arguments in the form:

        * 123.123.123.123/n where n is any value between 0 and 32
          *
        123.123.123.123/255.255.255.255
          * <ipv6-address>/n where n is any
        value between 0 and 128

        For IP version 4, this function accepts as well missing trailing
        components (i.e., less than 4 octets, like "192.168.1"), followed or not
        by a dot. If the netmask is also missing in that case, it is set to the
        number of octets actually passed (in the example above, it would be 24,
        for 3 octets).

        **See also** **isInSubnet** ().
        """
        ...

    def protocol(self) -> PySide6.QtNetwork.QAbstractSocket.NetworkLayerProtocol:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#protocol

        **int QHostAddress::protocol() const**

        Returns the network layer protocol of the host address.
        """
        ...

    def scopeId(self) -> str:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#scopeId

        **QString QHostAddress::scopeId() const**

        Returns the scope ID of an IPv6 address. For IPv4 addresses, or if the
        address does not contain a scope ID, an empty **QString**  is returned.

        The IPv6 scope ID specifies the scope of **reachability** for non-global
        IPv6 addresses, limiting the area in which the address can be used. All
        IPv6 addresses are associated with such a reachability scope. The scope
        ID is used to disambiguate addresses that are not guaranteed to be
        globally unique.

        IPv6 specifies the following four levels of reachability:

        * Node-local: Addresses that are only used for communicating with
        services on the same interface (e.g., the loopback interface "::1").
          *
        Link-local: Addresses that are local to the network interface ( **link**
        ). There is always one link-local address for each IPv6 interface on
        your host. Link-local addresses ("fe80...") are generated from the MAC
        address of the local network adaptor, and are not guaranteed to be
        unique.
          * Global: For globally routable addresses, such as public
        servers on the Internet.

        When using a link-local or site-local address for IPv6 connections, you
        must specify the scope ID. The scope ID for a link-local address is
        usually the same as the interface name (e.g., "eth0", "en1") or number
        (e.g., "1", "2").

        **See also** **setScopeId** (), **QNetworkInterface** , and
        **QNetworkInterface::interfaceFromName** .
        """
        ...

    @overload
    def setAddress(
        self, address: PySide6.QtNetwork.QHostAddress.SpecialAddress
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#setAddress

        **void QHostAddress::setAddress(quint32 ip4Addr )**

        Set the IPv4 address specified by **ip4Addr**.
        """
        ...

    @overload
    def setAddress(self, address: str) -> bool:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#setAddress-1

        **[since 5.5] void QHostAddress::setAddress(const quint8 * ip6Addr )**

        This is an overloaded function.

        Set the IPv6 address specified by **ip6Addr**.

        **ip6Addr** must be an array of 16 bytes in network byte order (high-
        order byte first).

        This function was introduced in Qt 5.5.
        """
        ...

    @overload
    def setAddress(self, ip4Addr: int) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#setAddress-2

        **void QHostAddress::setAddress(const Q_IPV6ADDR & ip6Addr )**

        This is an overloaded function.

        Set the IPv6 address specified by **ip6Addr**.
        """
        ...

    @overload
    def setAddress(self, ip6Addr: PySide6.QtNetwork.QIPv6Address) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#setAddress-3

        **void QHostAddress::setAddress(const sockaddr * sockaddr )**

        This is an overloaded function.

        Sets the IPv4 or IPv6 address specified by the native structure
        **sockaddr**. Returns `true` and sets the address if the address was
        successfully parsed; otherwise returns `false`.
        """
        ...

    def setScopeId(self, id: str) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#setScopeId

        **void QHostAddress::setScopeId(const QString & id )**

        Sets the IPv6 scope ID of the address to **id**. If the address protocol
        is not IPv6, this function does nothing. The scope ID may be set as an
        interface name (such as "eth0" or "en1") or as an integer representing
        the interface index. If **id** is an interface name, **QtNetwork**  will
        convert to an interface index using
        **QNetworkInterface::interfaceIndexFromName** () before calling the
        operating system networking functions.

        **See also** **scopeId** (), **QNetworkInterface** , and
        **QNetworkInterface::interfaceFromName** .
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtNetwork.QHostAddress,
            PySide6.QtNetwork.QHostAddress.SpecialAddress,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#swap

        **[since 5.6] void QHostAddress::swap(QHostAddress & other )**

        Swaps this host address with **other**. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.6.
        """
        ...

    def toIPv4Address(self) -> Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#toIPv4Address

        **quint32 QHostAddress::toIPv4Address(bool * ok = nullptr) const**

        Returns the IPv4 address as a number.

        For example, if the address is 127.0.0.1, the returned value is
        2130706433 (i.e. 0x7f000001).

        This value is valid if the **protocol** () is **IPv4Protocol** , or if
        the protocol is **IPv6Protocol** , and the IPv6 address is an IPv4
        mapped address (RFC4291). In those cases, **ok** will be set to true.
        Otherwise, it will be set to false.

        **See also** **toString** ().
        """
        ...

    def toIPv6Address(self) -> PySide6.QtNetwork.QIPv6Address:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#toIPv6Address

        **Q_IPV6ADDR QHostAddress::toIPv6Address() const**

        Returns the IPv6 address as a Q_IPV6ADDR structure. The structure
        consists of 16 unsigned characters.

        Q_IPV6ADDR addr = hostAddr.toIPv6Address();
            // addr contains 16
        unsigned characters

            for (int i = 0; i < 16; ++i) {
                //
        process addr[i]
            }

        This value is valid if the **protocol** () is **IPv6Protocol** . If the
        protocol is **IPv4Protocol** , then the address is returned an an IPv4
        mapped IPv6 address. (RFC4291)

        **See also** **toString** ().
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qhostaddress.html#toString

        **QString QHostAddress::toString() const**

        Returns the address as a string.

        For example, if the address is the IPv4 address 127.0.0.1, the returned
        string is "127.0.0.1". For IPv6 the string format will follow the
        RFC5952 recommendation. For **QHostAddress::Any** , its IPv4 address
        will be returned ("0.0.0.0")

        **See also** **toIPv4Address** ().
        """
        ...
