"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QDnsMailExchangeRecord(object):
    """
    https://doc.qt.io/qt-6/qdnsmailexchangerecord.html

    **Detailed Description**

    When performing a lookup on a service, zero or more records will be
    returned. Each record is represented by a QDnsMailExchangeRecord instance.

    The meaning of the fields is defined in **RFC 1035** .

    **See also** **QDnsLookup** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#QDnsMailExchangeRecor
        d

        **QDnsMailExchangeRecord::QDnsMailExchangeRecord()**

        Constructs an empty mail exchange record object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsMailExchangeRecord) -> None:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#QDnsMailExchangeRecor
        d-1

        **QDnsMailExchangeRecord::QDnsMailExchangeRecord(const
        QDnsMailExchangeRecord & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def exchange(self) -> str:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#exchange

        **QString QDnsMailExchangeRecord::exchange() const**

        Returns the domain name of the mail exchange for this record.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#name

        **QString QDnsMailExchangeRecord::name() const**

        Returns the name for this record.
        """
        ...

    def preference(self) -> int:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#preference

        **quint16 QDnsMailExchangeRecord::preference() const**

        Returns the preference for this record.
        """
        ...

    def swap(self, other: PySide6.QtNetwork.QDnsMailExchangeRecord) -> None:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#swap

        **void QDnsMailExchangeRecord::swap(QDnsMailExchangeRecord & other )**

        Swaps this mail exchange record with **other**. This function is very
        fast and never fails.
        """
        ...

    def timeToLive(self) -> int:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#timeToLive

        **quint32 QDnsMailExchangeRecord::timeToLive() const**

        Returns the duration in seconds for which this record is valid.
        """
        ...
