"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QDnsHostAddressRecord(object):
    """
    https://doc.qt.io/qt-6/qdnshostaddressrecord.html

    **Detailed Description**

    When performing an address lookup, zero or more records will be returned.
    Each record is represented by a QDnsHostAddressRecord instance.

    **See also** **QDnsLookup** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdnshostaddressrecord.html#QDnsHostAddressRecord

        **QDnsHostAddressRecord::QDnsHostAddressRecord()**

        Constructs an empty host address record object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsHostAddressRecord) -> None:
        """
        https://doc.qt.io/qt-6/qdnshostaddressrecord.html#QDnsHostAddressRecord-
        1

        **QDnsHostAddressRecord::QDnsHostAddressRecord(const
        QDnsHostAddressRecord & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qdnshostaddressrecord.html#name

        **QString QDnsHostAddressRecord::name() const**

        Returns the name for this record.
        """
        ...

    def swap(self, other: PySide6.QtNetwork.QDnsHostAddressRecord) -> None:
        """
        https://doc.qt.io/qt-6/qdnshostaddressrecord.html#swap

        **void QDnsHostAddressRecord::swap(QDnsHostAddressRecord & other )**

        Swaps this host address record instance with **other**. This function is
        very fast and never fails.
        """
        ...

    def timeToLive(self) -> int:
        """
        https://doc.qt.io/qt-6/qdnshostaddressrecord.html#timeToLive

        **quint32 QDnsHostAddressRecord::timeToLive() const**

        Returns the duration in seconds for which this record is valid.
        """
        ...

    def value(self) -> PySide6.QtNetwork.QHostAddress:
        """
        https://doc.qt.io/qt-6/qdnshostaddressrecord.html#value

        **QHostAddress QDnsHostAddressRecord::value() const**

        Returns the value for this host address record.
        """
        ...
