"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QAbstractNetworkCache(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstractnetworkcache.html

    **Detailed Description**

    QAbstractNetworkCache is the base class for every standard cache that is
    used by **QNetworkAccessManager** . QAbstractNetworkCache is an abstract
    class and cannot be instantiated.

    **See also** **QNetworkDiskCache** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#QAbstractNetworkCache

        **[protected] QAbstractNetworkCache::QAbstractNetworkCache(QObject *
        parent = nullptr)**

        Constructs an abstract network cache with the given **parent**.
        """
        ...

    def cacheSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#cacheSize

        **[pure virtual] qint64 QAbstractNetworkCache::cacheSize() const**

        Returns the current size taken up by the cache. Depending upon the cache
        implementation this might be disk or memory size.

        In the base class this is a pure virtual function.

        **See also** **clear** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#clear

        **[pure virtual slot] void QAbstractNetworkCache::clear()**

        Removes all items from the cache. Unless there was failures clearing the
        cache **cacheSize** () should return 0 after a call to clear.

        In the base class this is a pure virtual function.

        **See also** **cacheSize** () and **remove** ().
        """
        ...

    def data(self, url: Union[PySide6.QtCore.QUrl, str]) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#data

        **[pure virtual] QIODevice *QAbstractNetworkCache::data(const QUrl & url
        )**

        Returns the data associated with **url**.

        It is up to the application that requests the data to delete the
        **QIODevice**  when done with it.

        If there is no cache for **url** , the url is invalid, or if there is an
        internal cache error `nullptr` is returned.

        In the base class this is a pure virtual function.

        **See also** **metaData** () and **prepare** ().
        """
        ...

    def insert(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#insert

        **[pure virtual] void QAbstractNetworkCache::insert(QIODevice * device
        )**

        Inserts the data in **device** and the prepared meta data into the
        cache. After this function is called the data and meta data should be
        retrievable using **data** () and **metaData** ().

        To cancel a prepared inserted call **remove** () on the metadata's url.

        In the base class this is a pure virtual function.

        **See also** **prepare** () and **remove** ().
        """
        ...

    def metaData(
        self, url: Union[PySide6.QtCore.QUrl, str]
    ) -> PySide6.QtNetwork.QNetworkCacheMetaData:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#metaData

        **[pure virtual] QNetworkCacheMetaData
        QAbstractNetworkCache::metaData(const QUrl & url )**

        Returns the meta data for the url **url**.

        If the url is valid and the cache contains the data for url, a valid
        **QNetworkCacheMetaData**  is returned.

        In the base class this is a pure virtual function.

        **See also** **updateMetaData** () and **data** ().
        """
        ...

    def prepare(
        self, metaData: PySide6.QtNetwork.QNetworkCacheMetaData
    ) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#prepare

        **[pure virtual] QIODevice *QAbstractNetworkCache::prepare(const
        QNetworkCacheMetaData & metaData )**

        Returns the device that should be populated with the data for the cache
        item **metaData**. When all of the data has been written **insert** ()
        should be called. If **metaData**  is invalid or the url in the metadata
        is invalid `nullptr` is returned.

        The cache owns the device and will take care of deleting it when it is
        inserted or removed.

        To cancel a prepared inserted call **remove** () on the metadata's url.

        In the base class this is a pure virtual function.

        **See also** **remove** (), **updateMetaData** (), and **insert** ().
        """
        ...

    def remove(self, url: Union[PySide6.QtCore.QUrl, str]) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#remove

        **[pure virtual] bool QAbstractNetworkCache::remove(const QUrl & url )**

        Removes the cache entry for **url** , returning true if success
        otherwise false.

        In the base class this is a pure virtual function.

        **See also** **clear** () and **prepare** ().
        """
        ...

    def updateMetaData(self, metaData: PySide6.QtNetwork.QNetworkCacheMetaData) -> None:
        """
        https://doc.qt.io/qt-6/qabstractnetworkcache.html#updateMetaData

        **[pure virtual] void QAbstractNetworkCache::updateMetaData(const
        QNetworkCacheMetaData & metaData )**

        Updates the cache meta date for the **metaData** 's url to **metaData**

        If the cache does not contains a cache item for the url then no action
        is taken.

        In the base class this is a pure virtual function.

        **See also** **metaData** () and **prepare** ().
        """
        ...
