"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimediaWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtMultimedia
import PySide6.QtMultimediaWidgets

bytes = str


class QVideoWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qvideowidget.html

    **Detailed Description**

    Attaching a QVideoWidget to a **QMediaPlayer**  or **QCamera**  allows it to
    display the video or image output of that object.

    player = new **QMediaPlayer** ;
        player->setSource(**QUrl**
    ("http://example.com/myclip1.mp4"));

        videoWidget = new
    **QVideoWidget** ;
        player->setVideoOutput(videoWidget);
    videoWidget->show();
        player->play();

    **Note** : Only a single display output can be attached to a media object at
    one time.

    **See also** **QCamera** , **QMediaPlayer** , and **QGraphicsVideoItem** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#QVideoWidget

        **QVideoWidget::QVideoWidget(QWidget * parent = nullptr)**

        Constructs a new video widget.

        The **parent** is passed to **QWidget** .
        """
        ...

    def aspectRatioMode(self) -> PySide6.QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how video is scaled with respect to its aspect ratio.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )

        **Notifier signal:**

        void **aspectRatioModeChanged** (Qt::AspectRatioMode **mode** )
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#event

        **[override virtual protected] bool QVideoWidget::event(QEvent * event
        )**

        Reimplements: **QWidget::event** (QEvent *event).

        Current event **event**. Returns the value of the base class
        **QWidget::event** (**QEvent**  *event) function.
        """
        ...

    def hideEvent(self, event: PySide6.QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#hideEvent

        **[override virtual protected] void QVideoWidget::hideEvent(QHideEvent *
        event )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).

        Handles the hide **event**.
        """
        ...

    def moveEvent(self, event: PySide6.QtGui.QMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#moveEvent

        **[override virtual protected] void QVideoWidget::moveEvent(QMoveEvent *
        event )**

        Reimplements: **QWidget::moveEvent** (QMoveEvent *event).

        Handles the move **event**.
        """
        ...

    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#resizeEvent

        **[override virtual protected] void
        QVideoWidget::resizeEvent(QResizeEvent * event )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).

        Handles the resize **event**.
        """
        ...

    def setAspectRatioMode(self, mode: PySide6.QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how video is scaled with respect to its aspect ratio.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )

        **Notifier signal:**

        void **aspectRatioModeChanged** (Qt::AspectRatioMode **mode** )
        """
        ...

    def setFullScreen(self, fullScreen: bool) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#fullScreen-prop

        **fullScreen : bool**

        This property holds whether video display is confined to a window or is
        fullScreen.

        **Access functions:**

        bool **isFullScreen** () const
        void **setFullScreen** (bool
        **fullScreen** )

        **Notifier signal:**

        void ****fullScreenChanged** ** (bool **fullScreen** )

        **Member Function Documentation**
        """
        ...

    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#showEvent

        **[override virtual protected] void QVideoWidget::showEvent(QShowEvent *
        event )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).

        Handles the show **event**.
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#sizeHint

        **[override virtual] QSize QVideoWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .

        Returns the size hint for the current back end, if there is one, or else
        the size hint from **QWidget** .
        """
        ...

    def videoSink(self) -> PySide6.QtMultimedia.QVideoSink:
        ...

    @property
    def aspectRatioModeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def fullScreenChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#fullScreenChanged

        **[signal] void QVideoWidget::fullScreenChanged(bool fullScreen )**

        Signals that the **fullScreen** mode of a video widget has changed.

        **Note:** Notifier signal for property **fullScreen** .

        **See also** **isFullScreen** ().
        """
        ...
