"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QVideoSink(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qvideosink.html

    **Detailed Description**

    The QVideoSink class can be used to retrieve video data on a frame by frame
    basis from Qt Multimedia.

    QVideoSink can operate in two modes. In the first mode, it can render the
    video stream to a native window of the underlying windowing system. In the
    other mode, it will provide individual video frames to the application
    developer through the videoFrameChanged() signal.

    The video frame can then be used to read out the data of those frames and
    handle them further. When using **QPainter** , the **QVideoFrame**  can be
    drawing using the paint() method in QVideoSink.

    **QVideoFrame**  objects can consume a significant amount of memory or
    system resources and should thus not be held for longer than required by the
    application.

    **See also** **QMediaPlayer**  and **QMediaCaptureSession** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvideosink.html#QVideoSink

        **QVideoSink::QVideoSink(QObject * parent = nullptr)**

        Constructs a new QVideoSink object with **parent**.
        """
        ...

    def setSubtitleText(self, subtitle: str) -> None:
        """
        https://doc.qt.io/qt-6/qvideosink.html#setSubtitleText

        **void QVideoSink::setSubtitleText(const QString & subtitle )**

        Sets the current **subtitle** text.

        **See also** **subtitleText** ().
        """
        ...

    def setVideoFrame(
        self,
        frame: Union[
            PySide6.QtMultimedia.QVideoFrame, PySide6.QtMultimedia.QVideoFrameFormat
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvideosink.html#setVideoFrame

        **void QVideoSink::setVideoFrame(const QVideoFrame & frame )**

        Sets the current video **frame**.

        **See also** **videoFrame** ().
        """
        ...

    def subtitleText(self) -> str:
        """
        https://doc.qt.io/qt-6/qvideosink.html#subtitleText

        **QString QVideoSink::subtitleText() const**

        Returns the current subtitle text.

        **See also** **setSubtitleText** ().
        """
        ...

    def videoFrame(self) -> PySide6.QtMultimedia.QVideoFrame:
        """
        https://doc.qt.io/qt-6/qvideosink.html#videoFrame

        **QVideoFrame QVideoSink::videoFrame() const**

        Returns the current video frame.

        **See also** **setVideoFrame** ().
        """
        ...

    def videoSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qvideosink.html#videoSize

        **QSize QVideoSink::videoSize() const**

        Returns the size of the video currently being played back. If no video
        is being played, this method returns an invalid size.
        """
        ...
