"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QSoundEffect(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsoundeffect.html

    **Detailed Description**

    This class allows you to play uncompressed audio files (typically WAV files)
    in a generally lower latency way, and is suitable for "feedback" type sounds
    in response to user actions (e.g. virtual keyboard sounds, positive or
    negative feedback for popup dialogs, or game sounds). If low latency is not
    important, consider using the **QMediaPlayer**  class instead, since it
    supports a wider variety of media formats and is less resource intensive.

    This example shows how a looping, somewhat quiet sound effect can be played:

    **QSoundEffect**  effect;
        effect.setSource(**QUrl**
    ::fromLocalFile("engine.wav"));
        effect.setLoopCount(**QSoundEffect**
    ::Infinite);
        effect.setVolume(0.25f);
        effect.play();

    Typically the sound effect should be reused, which allows all the parsing
    and preparation to be done ahead of time, and only triggered when necessary.
    This assists with lower latency audio playback.

    MyGame()
            : m_explosion(this)
        {
    m_explosion.setSource(**QUrl** ::fromLocalFile("explosion.wav"));
    m_explosion.setVolume(0.25f);

            // Set up click handling etc.
    connect(clickSource, &**QPushButton** ::clicked, &m_explosion,
    &**QSoundEffect** ::play);
        }
        private:
        **QSoundEffect**
    m_explosion;

    Since QSoundEffect requires slightly more resources to achieve lower latency
    playback, the platform may limit the number of simultaneously playing sound
    effects.
    """

    Infinite: QSoundEffect.Loop = ...
    Null: QSoundEffect.Status = ...
    Loading: QSoundEffect.Status = ...
    Ready: QSoundEffect.Status = ...
    Error: QSoundEffect.Status = ...

    class Loop(Enum):
        Infinite: QSoundEffect.Loop = ...

    class Status(Enum):
        Null: QSoundEffect.Status = ...
        Loading: QSoundEffect.Status = ...
        Ready: QSoundEffect.Status = ...
        Error: QSoundEffect.Status = ...

    @overload
    def __init__(
        self,
        audioDevice: PySide6.QtMultimedia.QAudioDevice,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#QSoundEffect

        **QSoundEffect::QSoundEffect(QObject * parent = nullptr)**

        Creates a QSoundEffect with the given **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#QSoundEffect-1

        **QSoundEffect::QSoundEffect(const QAudioDevice & audioDevice , QObject
        * parent = nullptr)**

        Creates a QSoundEffect with the given **audioDevice** and **parent**.
        """
        ...

    def audioDevice(self) -> PySide6.QtMultimedia.QAudioDevice:
        ...

    def isLoaded(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#isLoaded

        **bool QSoundEffect::isLoaded() const**

        Returns whether the sound effect has finished loading the **source** ().
        """
        ...

    def isMuted(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#isMuted

        **bool QSoundEffect::isMuted() const**

        Returns whether this sound effect is muted

        **Note:** Getter function for property **muted** .
        """
        ...

    def isPlaying(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#isPlaying

        **bool QSoundEffect::isPlaying() const**

        Returns true if the sound effect is currently playing, or false
        otherwise

        **Note:** Getter function for property **playing** .
        """
        ...

    def loopCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#loopCount

        **int QSoundEffect::loopCount() const**

        Returns the total number of times that this sound effect will be played
        before stopping.

        See the **loopsRemaining** () method for the number of loops currently
        remaining.

        **Note:** Getter function for property **loops** .

        **See also** **setLoopCount** ().
        """
        ...

    def loopsRemaining(self) -> int:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#loopsRemaining-prop

        **[read-only] loopsRemaining : const int**

        This property contains the number of loops remaining before the sound
        effect stops by itself, or **QSoundEffect::Infinite**  if that's what
        has been set in **loops** .

        **Access functions:**

        int **loopsRemaining** () const

        **Notifier signal:**

        void ****loopsRemainingChanged** ** ()
        """
        ...

    def play(self) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#play

        **[slot] void QSoundEffect::play()**

        Start playback of the sound effect, looping the effect for the number of
        times as specified in the loops property.
        """
        ...

    def setAudioDevice(self, device: PySide6.QtMultimedia.QAudioDevice) -> None:
        ...

    def setLoopCount(self, loopCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#setLoopCount

        **void QSoundEffect::setLoopCount(int loopCount )**

        Set the total number of times to play this sound effect to
        **loopCount**.

        Setting the loop count to 0 or 1 means the sound effect will be played
        only once; pass `QSoundEffect::Infinite` to repeat indefinitely. The
        loop count can be changed while the sound effect is playing, in which
        case it will update the remaining loops to the new **loopCount**.

        **Note:** Setter function for property **loops** .

        **See also** **loopCount** () and **loopsRemaining** ().
        """
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#setMuted

        **void QSoundEffect::setMuted(bool muted )**

        Sets whether to mute this sound effect's playback.

        If **muted** is true, playback will be muted (silenced), and otherwise
        playback will occur with the currently specified **volume** ().

        **Note:** Setter function for property **muted** .

        **See also** **isMuted** ().
        """
        ...

    def setSource(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#setSource

        **void QSoundEffect::setSource(const QUrl & url )**

        Set the current URL to play to **url**.

        **Note:** Setter function for property **source** .

        **See also** **source** ().
        """
        ...

    def setVolume(self, volume: float) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#setVolume

        **void QSoundEffect::setVolume(float volume )**

        Sets the sound effect volume to **volume**.

        The volume is scaled linearly from `0.0` (silence) to `1.0` (full
        volume). Values outside this range will be clamped.

        The default volume is `1.0`.

        UI volume controls should usually be scaled non-linearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control. See **QAudio::convertVolume** () for more details.

        **Note:** Setter function for property **volume** .

        **See also** **volume** ().
        """
        ...

    def source(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#source

        **QUrl QSoundEffect::source() const**

        Returns the URL of the current source to play

        **Note:** Getter function for property source.

        **See also** **setSource** ().
        """
        ...

    def status(self) -> PySide6.QtMultimedia.QSoundEffect.Status:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#status

        **QSoundEffect::Status QSoundEffect::status() const**

        Returns the current status of this sound effect.

        **Note:** Getter function for property status.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#stop

        **[slot] void QSoundEffect::stop()**

        Stop current playback.
        """
        ...

    @staticmethod
    def supportedMimeTypes() -> List[str]:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#supportedMimeTypes

        **[static] QStringList QSoundEffect::supportedMimeTypes()**

        Returns a list of the supported mime types for this platform.
        """
        ...

    def volume(self) -> float:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#volume

        **float QSoundEffect::volume() const**

        Returns the current volume of this sound effect, from 0.0 (silent) to
        1.0 (maximum volume).

        **Note:** Getter function for property volume.

        **See also** **setVolume** ().
        """
        ...

    @property
    def audioDeviceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def loadedChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#loadedChanged

        **[signal] void QSoundEffect::loadedChanged()**

        The `loadedChanged` signal is emitted when the loading state has
        changed.
        """
        ...

    @property
    def loopCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#loopCountChanged

        **[signal] void QSoundEffect::loopCountChanged()**

        The `loopCountChanged` signal is emitted when the initial number of
        loops has changed.

        **Note:** Notifier signal for property **loops** .
        """
        ...

    @property
    def loopsRemainingChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#loopsRemainingChanged

        **[signal] void QSoundEffect::loopsRemainingChanged()**

        The `loopsRemainingChanged` signal is emitted when the remaining number
        of loops has changed.

        **Note:** Notifier signal for property **loopsRemaining** .
        """
        ...

    @property
    def mutedChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#mutedChanged

        **[signal] void QSoundEffect::mutedChanged()**

        The `mutedChanged` signal is emitted when the mute state has changed.

        **Note:** Notifier signal for property **muted** .
        """
        ...

    @property
    def playingChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#playingChanged

        **[signal] void QSoundEffect::playingChanged()**

        The `playingChanged` signal is emitted when the playing property has
        changed.

        **Note:** Notifier signal for property **playing** .
        """
        ...

    @property
    def sourceChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#sourceChanged

        **[signal] void QSoundEffect::sourceChanged()**

        The `sourceChanged` signal is emitted when the source has been changed.

        **Note:** Notifier signal for property **source** .
        """
        ...

    @property
    def statusChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#statusChanged

        **[signal] void QSoundEffect::statusChanged()**

        The `statusChanged` signal is emitted when the status property has
        changed.

        **Note:** Notifier signal for property **status** .
        """
        ...

    @property
    def volumeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsoundeffect.html#volumeChanged

        **[signal] void QSoundEffect::volumeChanged()**

        The `volumeChanged` signal is emitted when the volume has changed.

        **Note:** Notifier signal for property **volume** .
        """
        ...
