"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QMediaRecorder(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qmediarecorder.html

    **Detailed Description**

    The QMediaRecorder class is a class for encoding and recording media
    generated in a **QMediaCaptureSession** .

    **QMediaCaptureSession**  session;
        **QAudioInput**  audioInput;
    session.setAudioInput(&input);
        **QMediaRecorder**  recorder;
    session.setMediaRecorder(&recorder);
    recorder.setQuality(**QMediaRecorder** ::HighQuality);
    recorder.setOutputLocation(**QUrl** ::fromLocalFile("test.mp3"));
    recorder.record();
    """

    ConstantQualityEncoding: QMediaRecorder.EncodingMode = ...
    ConstantBitRateEncoding: QMediaRecorder.EncodingMode = ...
    AverageBitRateEncoding: QMediaRecorder.EncodingMode = ...
    TwoPassEncoding: QMediaRecorder.EncodingMode = ...
    NoError: QMediaRecorder.Error = ...
    ResourceError: QMediaRecorder.Error = ...
    FormatError: QMediaRecorder.Error = ...
    OutOfSpaceError: QMediaRecorder.Error = ...
    LocationNotWritable: QMediaRecorder.Error = ...
    VeryLowQuality: QMediaRecorder.Quality = ...
    LowQuality: QMediaRecorder.Quality = ...
    NormalQuality: QMediaRecorder.Quality = ...
    HighQuality: QMediaRecorder.Quality = ...
    VeryHighQuality: QMediaRecorder.Quality = ...
    StoppedState: QMediaRecorder.RecorderState = ...
    RecordingState: QMediaRecorder.RecorderState = ...
    PausedState: QMediaRecorder.RecorderState = ...

    class EncodingMode(Enum):
        ConstantQualityEncoding: QMediaRecorder.EncodingMode = ...
        ConstantBitRateEncoding: QMediaRecorder.EncodingMode = ...
        AverageBitRateEncoding: QMediaRecorder.EncodingMode = ...
        TwoPassEncoding: QMediaRecorder.EncodingMode = ...

    class Error(Enum):
        NoError: QMediaRecorder.Error = ...
        ResourceError: QMediaRecorder.Error = ...
        FormatError: QMediaRecorder.Error = ...
        OutOfSpaceError: QMediaRecorder.Error = ...
        LocationNotWritable: QMediaRecorder.Error = ...

    class Quality(Enum):
        VeryLowQuality: QMediaRecorder.Quality = ...
        LowQuality: QMediaRecorder.Quality = ...
        NormalQuality: QMediaRecorder.Quality = ...
        HighQuality: QMediaRecorder.Quality = ...
        VeryHighQuality: QMediaRecorder.Quality = ...

    class RecorderState(Enum):
        StoppedState: QMediaRecorder.RecorderState = ...
        RecordingState: QMediaRecorder.RecorderState = ...
        PausedState: QMediaRecorder.RecorderState = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#QMediaRecorder

        **QMediaRecorder::QMediaRecorder(QObject * parent = nullptr)**

        Constructs a media recorder which records the media produced by a
        microphone and camera. The media recorder is a child of **parent**.
        """
        ...

    def actualLocation(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#actualLocation-prop

        **[read-only] actualLocation : const QUrl**

        This property holds the actual location of the last media content.

        The actual location is usually available after recording starts, and
        reset when new location is set or new recording starts.

        **Access functions:**

        QUrl **actualLocation** () const

        **Notifier signal:**

        void ****actualLocationChanged** ** (const QUrl & **location** )
        """
        ...

    def addMetaData(self, metaData: PySide6.QtMultimedia.QMediaMetaData) -> None:
        ...

    def audioBitRate(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#audioBitRate

        **int QMediaRecorder::audioBitRate() const**

        Returns the bit rate of the compressed audio stream in bits per second.

        **See also** **setAudioBitRate** ().
        """
        ...

    def audioChannelCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#audioChannelCount

        **int QMediaRecorder::audioChannelCount() const**

        Returns the number of audio channels.

        **See also** **setAudioChannelCount** ().
        """
        ...

    def audioSampleRate(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#audioSampleRate

        **int QMediaRecorder::audioSampleRate() const**

        Returns the audio sample rate in Hz.

        **See also** **setAudioSampleRate** ().
        """
        ...

    def captureSession(self) -> PySide6.QtMultimedia.QMediaCaptureSession:
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#duration-prop

        **[read-only] duration : const qint64**

        This property holds the recorded media duration in milliseconds.

        **Access functions:**

        qint64 **duration** () const

        **Notifier signal:**

        void ****durationChanged** ** (qint64 **duration** )
        """
        ...

    def encodingMode(self) -> PySide6.QtMultimedia.QMediaRecorder.EncodingMode:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#encodingMode

        **QMediaRecorder::EncodingMode QMediaRecorder::encodingMode() const**

        Returns the encoding mode.

        **See also** **setEncodingMode** () and **EncodingMode** .
        """
        ...

    def error(self) -> PySide6.QtMultimedia.QMediaRecorder.Error:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#error

        **QMediaRecorder::Error QMediaRecorder::error() const**

        Returns the current error state.

        **Note:** Getter function for property error.

        **See also** **errorString** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#errorString

        **QString QMediaRecorder::errorString() const**

        Returns a string describing the current error state.

        **Note:** Getter function for property errorString.

        **See also** **error** ().
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#isAvailable

        **bool QMediaRecorder::isAvailable() const**

        Returns `true` if media recorder service ready to use.
        """
        ...

    def mediaFormat(self) -> PySide6.QtMultimedia.QMediaFormat:
        ...

    def metaData(self) -> PySide6.QtMultimedia.QMediaMetaData:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#metaData

        **QMediaMetaData QMediaRecorder::metaData() const**

        Returns the metaData associated with the recording.

        **Note:** Getter function for property metaData.

        **See also** **setMetaData** ().
        """
        ...

    def outputLocation(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#outputLocation-prop

        **outputLocation : QUrl**

        This property holds the destination location of media content.

        Setting the location can fail, for example when the service supports
        only local file system locations but a network URL was passed. If the
        operation fails an errorOccured() signal is emitted.

        The output location can be relative or empty; in the latter case the
        recorder uses the system specific place and file naming scheme.

        **Access functions:**

        QUrl **outputLocation** () const
        void **setOutputLocation** (const
        QUrl & **location** )
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#pause

        **[slot] void QMediaRecorder::pause()**

        Pauses recording.

        The recorder state is changed to **QMediaRecorder::PausedState** .

        Depending on the platform, pausing recording may be not supported. In
        this case the recorder state is unchanged.
        """
        ...

    def quality(self) -> PySide6.QtMultimedia.QMediaRecorder.Quality:
        ...

    def record(self) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#record

        **[slot] void QMediaRecorder::record()**

        Start recording.

        While the recorder state is changed immediately to
        c{**QMediaRecorder::RecordingState** }, recording may start
        asynchronously.

        If recording fails **error** () signal is emitted with recorder state
        being reset back to `QMediaRecorder::StoppedState`.

        **Note:** On mobile devices, recording will happen in the orientation
        the device had when calling record and is locked for the duration of the
        recording. To avoid artifacts on the user interface, we recommend to
        keep the user interface locked to the same orientation as long as the
        recording is ongoing using the contentOrientation property of
        **QWindow**  and unlock it again once the recording is finished.
        """
        ...

    def recorderState(self) -> PySide6.QtMultimedia.QMediaRecorder.RecorderState:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#recorderState

        **QMediaRecorder::RecorderState QMediaRecorder::recorderState() const**

        Returns the current media recorder state.

        **Note:** Getter function for property recorderState.

        **See also** **QMediaRecorder::RecorderState** .
        """
        ...

    def setAudioBitRate(self, bitRate: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setAudioBitRate

        **void QMediaRecorder::setAudioBitRate(int bitRate )**

        Sets the audio **bitRate** in bits per second.

        **See also** **audioBitRate** ().
        """
        ...

    def setAudioChannelCount(self, channels: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setAudioChannelCount

        **void QMediaRecorder::setAudioChannelCount(int channels )**

        Sets the number of audio **channels**.

        A value of -1 indicates the recorder should make an optimal choice based
        on what is available from the audio source and the limitations of the
        codec.

        **See also** **audioChannelCount** ().
        """
        ...

    def setAudioSampleRate(self, sampleRate: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setAudioSampleRate

        **void QMediaRecorder::setAudioSampleRate(int sampleRate )**

        Sets the audio **sampleRate** in Hz.

        A value of `-1` indicates the recorder should make an optimal choice
        based on what is available from the audio source, and the limitations of
        the codec.

        **See also** **audioSampleRate** ().
        """
        ...

    def setEncodingMode(
        self, arg__1: PySide6.QtMultimedia.QMediaRecorder.EncodingMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setEncodingMode

        **void QMediaRecorder::setEncodingMode(QMediaRecorder::EncodingMode mode
        )**

        Sets the encoding **mode** setting.

        If **ConstantQualityEncoding**  is set, the quality encoding parameter
        is used and bit rates are ignored, otherwise the bitrates are used.

        **See also** **encodingMode** () and **EncodingMode** .
        """
        ...

    def setMediaFormat(
        self,
        format: Union[
            PySide6.QtMultimedia.QMediaFormat,
            PySide6.QtMultimedia.QMediaFormat.FileFormat,
        ],
    ) -> None:
        ...

    def setMetaData(self, metaData: PySide6.QtMultimedia.QMediaMetaData) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setMetaData

        **void QMediaRecorder::setMetaData(const QMediaMetaData & metaData )**

        Sets the meta data to **metaData**.

        **Note:** To ensure that meta-data is set correctly, it should be set
        before starting the recording. Once the recording is started, any meta-
        data set will be attached to the next recording.

        **Note:** Setter function for property **metaData** .

        **See also** **metaData** ().
        """
        ...

    def setOutputLocation(self, location: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#outputLocation-prop

        **outputLocation : QUrl**

        This property holds the destination location of media content.

        Setting the location can fail, for example when the service supports
        only local file system locations but a network URL was passed. If the
        operation fails an errorOccured() signal is emitted.

        The output location can be relative or empty; in the latter case the
        recorder uses the system specific place and file naming scheme.

        **Access functions:**

        QUrl **outputLocation** () const
        void **setOutputLocation** (const
        QUrl & **location** )
        """
        ...

    def setQuality(self, quality: PySide6.QtMultimedia.QMediaRecorder.Quality) -> None:
        ...

    def setVideoBitRate(self, bitRate: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setVideoBitRate

        **void QMediaRecorder::setVideoBitRate(int bitRate )**

        Sets the video **bitRate** in bits per second.

        **See also** **videoBitRate** ().
        """
        ...

    def setVideoFrameRate(self, frameRate: float) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setVideoFrameRate

        **void QMediaRecorder::setVideoFrameRate(qreal frameRate )**

        Sets the video **frameRate**.

        A value of 0 indicates the recorder should make an optimal choice based
        on what is available from the video source and the limitations of the
        codec.

        **See also** **videoFrameRate** ().
        """
        ...

    @overload
    def setVideoResolution(self, arg__1: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setVideoResolution

        **void QMediaRecorder::setVideoResolution(const QSize & size )**

        Sets the resolution of the encoded video to **size**.

        Pass an empty **QSize**  to make the recorder choose an optimal
        resolution based on what is available from the video source and the
        limitations of the codec.

        **See also** **videoResolution** ().
        """
        ...

    @overload
    def setVideoResolution(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#setVideoResolution-1

        **void QMediaRecorder::setVideoResolution(int width , int height )**

        Sets the **width** and **height** of the resolution of the encoded
        video.

        This is an overloaded function.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#stop

        **[slot] void QMediaRecorder::stop()**

        Stops recording.

        The recorder state is changed to **QMediaRecorder::StoppedState** .
        """
        ...

    def videoBitRate(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#videoBitRate

        **int QMediaRecorder::videoBitRate() const**

        Returns the bit rate of the compressed video stream in bits per second.

        **See also** **setVideoBitRate** ().
        """
        ...

    def videoFrameRate(self) -> float:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#videoFrameRate

        **qreal QMediaRecorder::videoFrameRate() const**

        Returns the video frame rate.

        **See also** **setVideoFrameRate** ().
        """
        ...

    def videoResolution(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#videoResolution

        **QSize QMediaRecorder::videoResolution() const**

        Returns the resolution of the encoded video.

        **See also** **setVideoResolution** ().
        """
        ...

    @property
    def actualLocationChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#actualLocationChanged

        **[signal] void QMediaRecorder::actualLocationChanged(const QUrl &
        location )**

        Signals that the actual **location** of the recorded media has changed.
        This signal is usually emitted when recording starts.

        **Note:** Notifier signal for property **actualLocation** .
        """
        ...

    @property
    def durationChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#durationChanged

        **[signal] void QMediaRecorder::durationChanged(qint64 duration )**

        Signals that the **duration** of the recorded media has changed.

        **Note:** Notifier signal for property **duration** .
        """
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#errorOccurred

        **[signal] void QMediaRecorder::errorOccurred(QMediaRecorder::Error
        error , const QString & errorString )**

        Signals that an **error** has occurred, with **errorString** containing
        a description of the error.
        """
        ...

    @property
    def mediaFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def metaDataChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#metaDataChanged

        **[signal] void QMediaRecorder::metaDataChanged()**

        Signals that a media object's meta-data has changed.

        If multiple meta-data elements are changed metaDataChanged() is emitted
        once.

        **Note:** Notifier signal for property **metaData** .
        """
        ...

    @property
    def recorderStateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediarecorder.html#recorderStateChanged

        **[signal] void
        QMediaRecorder::recorderStateChanged(QMediaRecorder::RecorderState state
        )**

        Signals that a media recorder's **state** has changed.

        **Note:** Notifier signal for property **recorderState** .
        """
        ...
