"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QMediaCaptureSession(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qmediacapturesession.html

    **Detailed Description**

    The QMediaCaptureSession is the central class that manages capturing of
    media on the local device.

    You can connect a camera and a microphone to QMediaCaptureSession using
    **setCamera** () and **setAudioInput** (). A preview of the captured media
    can be seen by setting a **QVideoSink**  of **QVideoWidget**  using
    **setVideoOutput** () and heard by routing the audio to an output device
    using **setAudioOutput** ().

    You can capture still images from a camera by setting a **QImageCapture**
    object on the capture session, and record audio/video using a
    **QMediaRecorder** .

    **See also** **QCamera** , **QAudioDevice** , **QMediaRecorder** ,
    **QImageCapture** , and **QMediaRecorder** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#QMediaCaptureSession

        **QMediaCaptureSession::QMediaCaptureSession(QObject * parent =
        nullptr)**

        Creates a session for media capture from the **parent** object.
        """
        ...

    def audioInput(self) -> PySide6.QtMultimedia.QAudioInput:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#audioInput

        **QAudioInput *QMediaCaptureSession::audioInput() const**

        Returns the device that is being used to capture audio.

        **Note:** Getter function for property audioInput.

        **See also** **setAudioInput** ().
        """
        ...

    def audioOutput(self) -> PySide6.QtMultimedia.QAudioOutput:
        ...

    def camera(self) -> PySide6.QtMultimedia.QCamera:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#camera-prop

        **camera : QCamera***

        This property holds the camera used to capture video.

        Record video or take images by adding a camera to the capture session
        using this property,

        **Access functions:**

        QCamera * **camera** () const
        void **setCamera** (QCamera * **camera**
        )

        **Notifier signal:**

        void **cameraChanged** ()
        """
        ...

    def imageCapture(self) -> PySide6.QtMultimedia.QImageCapture:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#imageCapture-prop

        **imageCapture : QImageCapture***

        This property holds the object used to capture still images.

        Add a **QImageCapture**  object to the capture session to enable
        capturing of still images from the camera.

        **Access functions:**

        QImageCapture * **imageCapture** ()
        void **setImageCapture**
        (QImageCapture * **imageCapture** )

        **Notifier signal:**

        void **imageCaptureChanged** ()
        """
        ...

    def recorder(self) -> PySide6.QtMultimedia.QMediaRecorder:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#recorder-prop

        **recorder : QMediaRecorder***

        This property holds the recorder object used to capture audio/video.

        Add a **QMediaRecorder**  object to the capture session to enable
        recording of audio and/or video from the capture session.

        **Access functions:**

        QMediaRecorder * **recorder** ()
        void **setRecorder** (QMediaRecorder
        * **recorder** )

        **Notifier signal:**

        void **recorderChanged** ()

        **Member Function Documentation**
        """
        ...

    def setAudioInput(self, input: PySide6.QtMultimedia.QAudioInput) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setAudioInput

        **void QMediaCaptureSession::setAudioInput(QAudioInput * input )**

        Sets the audio input device to **input**. If setting it to an empty
        **QAudioDevice**  the capture session will use the default input as
        defined by the operating system.

        **Note:** Setter function for property **audioInput** .

        **See also** **audioInput** ().
        """
        ...

    def setAudioOutput(self, output: PySide6.QtMultimedia.QAudioOutput) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setAudioOutput

        **void QMediaCaptureSession::setAudioOutput(QAudioOutput * output )**

        Sets the audio output device to **output**.

        **Note:** Setter function for property **audioOutput** .

        **See also** **audioOutput** ().
        """
        ...

    def setCamera(self, camera: PySide6.QtMultimedia.QCamera) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#camera-prop

        **camera : QCamera***

        This property holds the camera used to capture video.

        Record video or take images by adding a camera to the capture session
        using this property,

        **Access functions:**

        QCamera * **camera** () const
        void **setCamera** (QCamera * **camera**
        )

        **Notifier signal:**

        void **cameraChanged** ()
        """
        ...

    def setImageCapture(self, imageCapture: PySide6.QtMultimedia.QImageCapture) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#imageCapture-prop

        **imageCapture : QImageCapture***

        This property holds the object used to capture still images.

        Add a **QImageCapture**  object to the capture session to enable
        capturing of still images from the camera.

        **Access functions:**

        QImageCapture * **imageCapture** ()
        void **setImageCapture**
        (QImageCapture * **imageCapture** )

        **Notifier signal:**

        void **imageCaptureChanged** ()
        """
        ...

    def setRecorder(self, recorder: PySide6.QtMultimedia.QMediaRecorder) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#recorder-prop

        **recorder : QMediaRecorder***

        This property holds the recorder object used to capture audio/video.

        Add a **QMediaRecorder**  object to the capture session to enable
        recording of audio and/or video from the capture session.

        **Access functions:**

        QMediaRecorder * **recorder** ()
        void **setRecorder** (QMediaRecorder
        * **recorder** )

        **Notifier signal:**

        void **recorderChanged** ()

        **Member Function Documentation**
        """
        ...

    def setVideoOutput(self, output: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setVideoOutput

        **void QMediaCaptureSession::setVideoOutput(QObject * output )**

        Sets a **QObject** , ( **output** ), to a video preview for the capture
        session.

        A **QObject**  based preview is expected to have an invokable
        videoSink() method that returns a **QVideoSink** .

        The previously set preview is detached.

        **Note:** Setter function for property **videoOutput** .

        **See also** **videoOutput** ().
        """
        ...

    def setVideoSink(self, sink: PySide6.QtMultimedia.QVideoSink) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setVideoSink

        **void QMediaCaptureSession::setVideoSink(QVideoSink * sink )**

        Sets a **QVideoSink** , ( **sink** ), to a video preview for the capture
        session.

        A **QObject**  based preview is expected to have an invokable
        videoSink() method that returns a **QVideoSink** .

        The previously set preview is detached.
        """
        ...

    def videoOutput(self) -> PySide6.QtCore.QObject:
        ...

    def videoSink(self) -> PySide6.QtMultimedia.QVideoSink:
        ...

    @property
    def audioOutputChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def cameraChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def imageCaptureChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def recorderChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def videoOutputChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
