"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QImageCapture(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qimagecapture.html

    **Detailed Description**

    The QImageCapture class is a high level images recording class. It's not
    intended to be used alone but for accessing the media recording functions of
    other media objects, like **QCamera** .

    **QMediaCaptureSession**  captureSession;
        camera = new **QCamera** ;
    captureSession.setCamera(camera);

        **QVideoWidget**  *preview = new
    **QVideoWidget** ();
        preview->show();
    captureSession.setVideoOutput(preview);

        imageCapture = new
    **QImageCapture** (camera);
    captureSession.setImageCapture(imageCapture);

        camera->start();
    //on shutter button pressed
        imageCapture->capture();

    **See also** **QCamera** .
    """

    NoError: QImageCapture.Error = ...
    NotReadyError: QImageCapture.Error = ...
    ResourceError: QImageCapture.Error = ...
    OutOfSpaceError: QImageCapture.Error = ...
    NotSupportedFeatureError: QImageCapture.Error = ...
    FormatError: QImageCapture.Error = ...
    UnspecifiedFormat: QImageCapture.FileFormat = ...
    JPEG: QImageCapture.FileFormat = ...
    PNG: QImageCapture.FileFormat = ...
    WebP: QImageCapture.FileFormat = ...
    LastFileFormat: QImageCapture.FileFormat = ...
    Tiff: QImageCapture.FileFormat = ...
    VeryLowQuality: QImageCapture.Quality = ...
    LowQuality: QImageCapture.Quality = ...
    NormalQuality: QImageCapture.Quality = ...
    HighQuality: QImageCapture.Quality = ...
    VeryHighQuality: QImageCapture.Quality = ...

    class Error(Enum):
        NoError: QImageCapture.Error = ...
        NotReadyError: QImageCapture.Error = ...
        ResourceError: QImageCapture.Error = ...
        OutOfSpaceError: QImageCapture.Error = ...
        NotSupportedFeatureError: QImageCapture.Error = ...
        FormatError: QImageCapture.Error = ...

    class FileFormat(Enum):
        UnspecifiedFormat: QImageCapture.FileFormat = ...
        JPEG: QImageCapture.FileFormat = ...
        PNG: QImageCapture.FileFormat = ...
        WebP: QImageCapture.FileFormat = ...
        LastFileFormat: QImageCapture.FileFormat = ...
        Tiff: QImageCapture.FileFormat = ...

    class Quality(Enum):
        VeryLowQuality: QImageCapture.Quality = ...
        LowQuality: QImageCapture.Quality = ...
        NormalQuality: QImageCapture.Quality = ...
        HighQuality: QImageCapture.Quality = ...
        VeryHighQuality: QImageCapture.Quality = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#QImageCapture

        **QImageCapture::QImageCapture(QObject * parent = nullptr)**

        Constructs a image capture object, from a **parent** , that can capture
        individual still images produced by a camera.

        You must connect both an image capture object and a **QCamera**  to a
        capture session to capture images.
        """
        ...

    def addMetaData(self, metaData: PySide6.QtMultimedia.QMediaMetaData) -> None:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#addMetaData

        **void QImageCapture::addMetaData(const QMediaMetaData & metaData )**

        Adds additional **metaData** to any existing meta data, that is embedded
        into the captured image.
        """
        ...

    def capture(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#capture

        **[slot] int QImageCapture::capture()**

        Capture the image and make it available as a **QImage** . This operation
        is asynchronous in majority of cases, followed by signals
        **QImageCapture::imageExposed** (), **QImageCapture::imageCaptured** ()
        or **QImageCapture::error** ().

        QImageCapture::capture returns the capture Id parameter, used with
        **imageExposed** (), **imageCaptured** () and **imageSaved** () signals.

        **See also** **isReadyForCapture** ().
        """
        ...

    def captureSession(self) -> PySide6.QtMultimedia.QMediaCaptureSession:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#captureSession

        **QMediaCaptureSession *QImageCapture::captureSession() const**

        Returns the capture session this camera is connected to, or a nullptr if
        the camera is not connected to a capture session.

        Use **QMediaCaptureSession::setImageCapture** () to connect the image
        capture to a session.
        """
        ...

    def captureToFile(self, location: str = ...) -> int:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#captureToFile

        **[slot] int QImageCapture::captureToFile(const QString & file =
        QString())**

        Capture the image and save it to **file**. This operation is
        asynchronous in majority of cases, followed by signals
        **QImageCapture::imageExposed** (), **QImageCapture::imageCaptured** (),
        **QImageCapture::imageSaved** () or **QImageCapture::error** ().

        If an empty **file** is passed, the camera back end chooses the default
        location and naming scheme for photos on the system, if only file name
        without full path is specified, the image will be saved to the default
        directory, with a full path reported with **imageCaptured** () and
        **imageSaved** () signals.

        **QCamera**  saves all the capture parameters like exposure settings or
        image processing parameters, so changes to camera parameters after
        **capture** () is called do not affect previous capture requests.

        **QImageCapture::capture**  returns the capture Id parameter, used with
        **imageExposed** (), **imageCaptured** () and **imageSaved** () signals.

        **See also** **isReadyForCapture** ().
        """
        ...

    def error(self) -> PySide6.QtMultimedia.QImageCapture.Error:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#error

        **QImageCapture::Error QImageCapture::error() const**

        Returns the current error state.

        **Note:** Getter function for property error.

        **See also** **errorString** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#errorString

        **QString QImageCapture::errorString() const**

        Returns a string describing the current error state.

        **Note:** Getter function for property errorString.

        **See also** **error** ().
        """
        ...

    def fileFormat(self) -> PySide6.QtMultimedia.QImageCapture.FileFormat:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#fileFormat-prop

        **[read-only] fileFormat : const FileFormat**

        This property holds the image format.

        **Access functions:**

        QImageCapture::FileFormat **fileFormat** () const

        **Notifier signal:**

        void **fileFormatChanged** ()
        """
        ...

    @staticmethod
    def fileFormatDescription(c: PySide6.QtMultimedia.QImageCapture.FileFormat) -> str:
        ...

    @staticmethod
    def fileFormatName(c: PySide6.QtMultimedia.QImageCapture.FileFormat) -> str:
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#isAvailable

        **bool QImageCapture::isAvailable() const**

        Returns true if the images capture service ready to use.
        """
        ...

    def isReadyForCapture(self) -> bool:
        ...

    def metaData(self) -> PySide6.QtMultimedia.QMediaMetaData:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#metaData-prop

        **metaData : QMediaMetaData**

        This property holds the meta data that will get embedded into the image.

        **Note:** Additional fields such as a time stamp or location may get
        added by the camera back end.

        **Access functions:**

        QMediaMetaData **metaData** () const
        void ****setMetaData** ** (const
        QMediaMetaData & **metaData** )

        **Notifier signal:**

        void **metaDataChanged** ()
        """
        ...

    def quality(self) -> PySide6.QtMultimedia.QImageCapture.Quality:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#quality-prop

        **[read-only] quality : const Quality**

        This property holds the image encoding quality.

        **Access functions:**

        QImageCapture::Quality **quality** () const

        **Notifier signal:**

        void **qualityChanged** ()
        """
        ...

    def resolution(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#resolution

        **QSize QImageCapture::resolution() const**

        Returns the resolution of the encoded image.

        **See also** **setResolution** ().
        """
        ...

    def setFileFormat(
        self, format: PySide6.QtMultimedia.QImageCapture.FileFormat
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#setFileFormat

        **void QImageCapture::setFileFormat(QImageCapture::FileFormat format )**

        Sets the image **format**.

        **See also** **fileFormat** ().
        """
        ...

    def setMetaData(self, metaData: PySide6.QtMultimedia.QMediaMetaData) -> None:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#setMetaData

        **void QImageCapture::setMetaData(const QMediaMetaData & metaData )**

        Replaces any existing meta data, to be embedded into the captured image,
        with a set of **metaData**.

        **Note:** Setter function for property **metaData** .

        **See also** **metaData** ().
        """
        ...

    def setQuality(self, quality: PySide6.QtMultimedia.QImageCapture.Quality) -> None:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#setQuality

        **void QImageCapture::setQuality(QImageCapture::Quality quality )**

        Sets the image encoding **quality**.

        **See also** **quality** ().
        """
        ...

    @overload
    def setResolution(self, arg__1: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#setResolution

        **void QImageCapture::setResolution(const QSize & resolution )**

        Sets the **resolution** of the encoded image.

        An empty **QSize**  indicates the encoder should make an optimal choice
        based on what is available from the image source and the limitations of
        the codec.

        **See also** **resolution** ().
        """
        ...

    @overload
    def setResolution(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#setResolution-1

        **void QImageCapture::setResolution(int width , int height )**

        Sets the **width** and **height** of the resolution of the encoded
        image.

        This is an overloaded function.
        """
        ...

    @staticmethod
    def supportedFormats() -> List[PySide6.QtMultimedia.QImageCapture.FileFormat]:
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#errorOccurred

        **[signal] void QImageCapture::errorOccurred(int id ,
        QImageCapture::Error error , const QString & errorString )**

        Signals that the capture request **id** has failed with an **error** and
        **errorString** description.
        """
        ...

    @property
    def fileFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def imageAvailable(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#imageAvailable

        **[signal] void QImageCapture::imageAvailable(int id , const QVideoFrame
        & frame )**

        Signal emitted when QImageCapture::CaptureToBuffer is set and the
        **frame** with request **id** is available.
        """
        ...

    @property
    def imageCaptured(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#imageCaptured

        **[signal] void QImageCapture::imageCaptured(int id , const QImage &
        preview )**

        Signal emitted when the frame with request **id** was captured, but not
        processed and saved yet. Frame **preview** can be displayed to user.
        """
        ...

    @property
    def imageExposed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#imageExposed

        **[signal] void QImageCapture::imageExposed(int id )**

        Signal emitted when the frame with request **id** was exposed.
        """
        ...

    @property
    def imageSaved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#imageSaved

        **[signal] void QImageCapture::imageSaved(int id , const QString &
        fileName )**

        Signal emitted when QImageCapture::CaptureToFile is set and the frame
        with request **id** was saved to **fileName**.
        """
        ...

    @property
    def metaDataChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def qualityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def readyForCaptureChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qimagecapture.html#readyForCaptureChanged

        **[signal] void QImageCapture::readyForCaptureChanged(bool ready )**

        Signals that a camera's **ready** for capture state has changed.

        **Note:** Notifier signal for property **readyForCapture** .
        """
        ...
